/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddViewSqlReportFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddViewSqlReportFormatter.class);
    private final String viewIdKey = "viewId";
    private final String sqlQueryKey = "sqlQuery";
    private final String reportNameKey = "reportName";
    private final String reportDescriptionKey = "reportDescr";
    private final String canFilterResultKey = "canFilterResult";
    private final String showFormOnResultKey = "showFormOnResult";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String viewId = map.get("viewId");
            String sqlQuery = map.get("sqlQuery");
            String canFilterResult = map.get("canFilterResult");
            String showFormOnResult = map.get("showFormOnResult");
            canFilterResult = this.validateBooleanParam(canFilterResult);
            showFormOnResult = this.validateBooleanParam(showFormOnResult);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)sqlQuery)) {
                formattedMap.put(AuditParamsNames.QUERY.toString(), sqlQuery);
            } else {
                formattedMap.put(AuditParamsNames.VIEW_ID.toString(), viewId);
            }
            formattedMap.put(AuditParamsNames.REPORT_NAME.toString(), map.get("reportName"));
            formattedMap.put(AuditParamsNames.REPORT_DESCR.toString(), map.get("reportDescr"));
            formattedMap.put(AuditParamsNames.REPORT_CAN_FILTER.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(canFilterResult.toUpperCase())));
            formattedMap.put(AuditParamsNames.REPORT_SHOW_FORM.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(showFormOnResult.toUpperCase())));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String validateBooleanParam(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return "FALSE";
        }
        return param;
    }
}

