/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.menuitem.MenuTabFactory;
import com.plusmpm.util.reports.ReportPermissions;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ShowReportsAction
extends Action {
    public static Logger log = Logger.getLogger(ShowReportsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************ShowRaportsAction********************");
        try {
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String sUserName = (String)session.getAttribute("username");
            int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().reports().build(), (String)sUserName, (boolean)false, (boolean)false);
            if (rights == 1 || rights == 0 || MenuTabFactory.userHasReports((String)sUserName)) {
                String type = request.getParameter("type");
                if (type == null) {
                    request.setAttribute("canCreateRaport", (Object)ReportPermissions.reportPermissions((String)sUserName, null));
                    request.setAttribute("ReportPrivate", (Object)"true");
                    request.setAttribute("ReportPublic", (Object)"true");
                    return mapping.findForward("showReports");
                }
                DBManagement dbm = new DBManagement();
                ReportService reportService = ServiceFactory.getReportService();
                ArrayList alReports = dbm.GetAllReportsForUserWithType(sUserName, type);
                for (ReportsTable report : alReports) {
                    report.setReportName(reportService.getReportTranslation(report.getId(), TranslatedFieldType.NAME));
                    report.setReportDescr(reportService.getReportTranslation(report.getId(), TranslatedFieldType.DESCRIPTION));
                }
                request.setAttribute("type", (Object)type);
                request.setAttribute("alReports", (Object)alReports);
                return mapping.findForward("showTypedReports");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mapping.findForward("welcome");
    }
}

