/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportVariableTable;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.action.reports.ShowReportsAction;
import com.plusmpm.struts.form.ReportVariableForm;
import com.plusmpm.util.reports.view.View;
import com.plusmpm.util.reports.view.ViewFactory;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class SaveReportAction
extends Action {
    public static Logger log = Logger.getLogger(SaveReportAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        I18N oMessage = new I18N(request);
        try {
            long lId;
            ReportsTable report;
            long viewId;
            String reportName;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            String sUserName = (String)session.getAttribute("username");
            DynaActionForm reportDefinitionForm = (DynaActionForm)form;
            ReportVariableForm[] reportVariable = (ReportVariableForm[])reportDefinitionForm.get("variable");
            String sViewId = (String)reportDefinitionForm.get("viewId");
            String sqlQuery = (String)reportDefinitionForm.get("sqlQuery");
            if (sqlQuery != null && !sqlQuery.equals("")) {
                sViewId = "";
            }
            if ((reportName = (String)reportDefinitionForm.get("reportName")) == null || reportName.equals("")) {
                request.setAttribute("errorMessage", (Object)oMessage.getString("Prosze_wprowadzic_nazwe_raportu"));
                return mapping.findForward("showError");
            }
            String reportDescr = (String)reportDefinitionForm.get("reportDescr");
            String showFormOnResult = (String)reportDefinitionForm.get("showFormOnResult");
            String canFilterResult = (String)reportDefinitionForm.get("canFilterResult");
            String showFormOnResultBoolean = showFormOnResult.equalsIgnoreCase("on") ? "true" : "false";
            String canFilterResultBoolean = canFilterResult.equalsIgnoreCase("on") ? "true" : "false";
            DBManagement dbm = new DBManagement();
            ArrayList alReports = dbm.GetAllReportsForUserWithType(sUserName, "private");
            for (Object obj : alReports) {
                ReportsTable table = (ReportsTable)obj;
                if (table.getReportName().compareToIgnoreCase(reportName) != 0) continue;
                request.setAttribute("errorMessage", (Object)oMessage.getString("Raport_o_podanej_nazwie_juz_istnieje"));
                return mapping.findForward("showError");
            }
            try {
                viewId = Long.parseLong(sViewId);
                report = new ReportsTable(Long.valueOf(viewId), reportName, reportDescr, "private", sUserName, showFormOnResultBoolean, canFilterResultBoolean);
                lId = dbm.addReport(report);
            }
            catch (Exception e) {
                log.info((Object)("Saving SQL view based on query: " + sqlQuery), (Throwable)e);
                try {
                    View view = new ViewFactory().make(sUserName, sqlQuery);
                    viewId = view.save(reportName);
                    report = new ReportsTable(Long.valueOf(viewId), reportName, reportDescr, "private", sUserName, showFormOnResultBoolean, canFilterResultBoolean);
                    lId = dbm.addReport(report);
                    view.populate(reportVariable);
                }
                catch (SQLException ex) {
                    String[] msgs = ex.getMessage().split(";");
                    Object message = "";
                    if (msgs != null) {
                        message = (String)message + oMessage.getString(msgs[0]);
                        for (int i = 1; i < msgs.length; ++i) {
                            message = (String)message + "  /  ";
                            message = (String)message + oMessage.getString(msgs[i]);
                        }
                    }
                    request.setAttribute("errorMessage", message);
                    return mapping.findForward("showError");
                }
                catch (ViewDoesNotExistException ex) {
                    request.setAttribute("errorMessage", (Object)MessageHelper.getMessage((String)"Widok_nie_istnieje", (Object[])new Object[]{ex.getId()}));
                    return mapping.findForward("showError");
                }
            }
            for (int i = 0; i < reportVariable.length; ++i) {
                if (reportVariable[i].getName() != null && reportVariable[i].getName().compareToIgnoreCase("") != 0) {
                    ReportVariableTable reportVariableTable = new ReportVariableTable("" + lId, reportVariable[i].getName(), reportVariable[i].getViewname(), reportVariable[i].getSortType(), reportVariable[i].getPosition(), reportVariable[i].getActive(), reportVariable[i].getGrouped(), reportVariable[i].getSum(), reportVariable[i].getAvg(), reportVariable[i].getMin(), reportVariable[i].getMax(), reportVariable[i].getCount());
                    dbm.addReportVariable(reportVariableTable);
                    log.info((Object)("Added to DB:" + reportVariable[i].getName() + " , " + reportVariable[i].getViewname() + " , " + reportVariable[i].getSortType() + " , " + reportVariable[i].getPosition() + " , " + reportVariable[i].getActive() + " , " + reportVariable[i].getGrouped() + " , " + reportVariable[i].getSum() + " , " + reportVariable[i].getAvg() + " , " + reportVariable[i].getMin() + " , " + reportVariable[i].getMax() + " , " + reportVariable[i].getCount()));
                    continue;
                }
                log.info((Object)("Added to DB:" + reportVariable[i].getName() + " , " + reportVariable[i].getViewname() + " , " + reportVariable[i].getSortType() + " , " + reportVariable[i].getPosition() + " , " + reportVariable[i].getActive() + " , " + reportVariable[i].getGrouped() + " , " + reportVariable[i].getSum() + " , " + reportVariable[i].getAvg() + " , " + reportVariable[i].getMin() + " , " + reportVariable[i].getMax() + " , " + reportVariable[i].getCount()));
            }
            request.setAttribute("auditSuccess", (Object)true);
            ShowReportsAction showReportsAction = new ShowReportsAction();
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Raport_zostal_zapisany"));
            request.setAttribute("messageType", (Object)"success");
            return showReportsAction.execute(mapping, form, request, response);
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()));
            request.setAttribute("errorMessage", (Object)oMessage.getString("Raport_zawiera_bledy"));
            return mapping.findForward("showError");
        }
    }
}

