/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.struts.form.FilterVariableForm;
import com.plusmpm.util.ReportResult;
import com.plusmpm.util.reports.Report;
import com.plusmpm.util.reports.ReportExecutor;
import com.plusmpm.util.reports.ReportResults;
import com.plusmpm.util.reports.util.PageProperties;
import com.plusmpm.util.reports.util._PageProperties;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.i18n.MessageHelper;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.displaytag.properties.MediaTypeEnum;

public class ReportFilterAction
extends Action {
    public static Logger log = Logger.getLogger(ReportFilterAction.class);
    public static Logger performanceLog = Logger.getLogger((String)"PerformanceLog");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************ReportFilterAction********************");
        try {
            String exportType;
            boolean isExport;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            Date dt = new Date();
            String userName = (String)session.getAttribute("username");
            DynaActionForm reportFilterForm = (DynaActionForm)form;
            _PageProperties pageProperties = new _PageProperties(request, userName);
            Report report = (Report)session.getAttribute("report");
            FilterVariableForm[] filter = (FilterVariableForm[])reportFilterForm.get("filter");
            int last = 0;
            while (filter[last].getName() != null) {
                ++last;
            }
            if (last > 0) {
                FilterVariableForm[] newF = new FilterVariableForm[last];
                for (int i = 0; i < newF.length; ++i) {
                    newF[i] = filter[i];
                }
                filter = newF;
            } else {
                filter = report.filterVariables(null);
            }
            if (pageProperties.sourceType() != null && pageProperties.sourceType().equals("filter")) {
                filter = report.filterVariables(filter);
                log.info((Object)"Filtering report variables...");
            }
            boolean bl = isExport = (exportType = pageProperties.exportType()) != null;
            if (isExport && exportType.equalsIgnoreCase(String.valueOf(MediaTypeEnum.EXCEL.getCode())) && SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.USE_SYSTEM_REPORT_EXCEL_EXPORT).booleanValue()) {
                this.doExcelExport(report, userName, (PageProperties)pageProperties, response);
                return null;
            }
            ReportExecutor reportExecutor = new ReportExecutor(report);
            ReportResults results = reportExecutor.execute(pageProperties.addOrderType(), Integer.toString(pageProperties.addOrderColNr()), pageProperties.offset(), pageProperties.pageSize(), isExport);
            Date dt2 = new Date();
            performanceLog.info((Object)("|Report|" + report.name() + "|" + (dt2.getTime() - dt.getTime())));
            if (!isExport) {
                request.setAttribute("iPageSize", (Object)Integer.toString(pageProperties.pageSize()));
            } else {
                request.setAttribute("iPageSize", (Object)Integer.toString(results.records()));
            }
            request.setAttribute("alResult", (Object)results.result());
            request.setAttribute("iMaxPageSize", (Object)Integer.toString(results.records()));
            request.setAttribute("reportName", (Object)report.name());
            session.setAttribute("report", (Object)report);
            request.setAttribute("showForm", (Object)report.showFormOnResult());
            request.setAttribute("canFilter", (Object)report.canFilterResult());
            reportFilterForm.set("filter", (Object)filter);
            request.setAttribute("filter", (Object)filter);
            request.setAttribute("auditExtraParam", (Object)("reportName=" + report.name()));
            request.setAttribute("auditSuccess", (Object)true);
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            request.setAttribute("errorMessage", (Object)(MessageHelper.getMessage((String)"Raport_zawiera_bledy") + ". " + MessageHelper.getMessage((String)"Mozliwy_tryb_wielooknowy") + "."));
            return mapping.findForward("showReportError");
        }
        return mapping.findForward("showResult");
    }

    private void doExcelExport(Report report, String userName, PageProperties pageProperties, HttpServletResponse response) throws Exception {
        int iSize = 0;
        SXSSFWorkbook wb = null;
        SXSSFSheet sheet = null;
        SXSSFRow row = null;
        Cell cell = null;
        CellStyle headerStyle = null;
        Font bold = null;
        int iIterations = 0;
        int iPageSize = 1000;
        int rowNum = 0;
        int colNum = 0;
        boolean checkTextAsNumber = false;
        int noOfColumns = 0;
        try (ServletOutputStream os = null;){
            wb = new SXSSFWorkbook(200);
            wb.setCompressTempFiles(true);
            sheet = wb.createSheet("-");
            sheet.trackAllColumnsForAutoSizing();
            headerStyle = wb.createCellStyle();
            headerStyle.setFillPattern(FillPatternType.FINE_DOTS);
            headerStyle.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
            bold = wb.createFont();
            bold.setBold(true);
            bold.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            headerStyle.setFont(bold);
            ReportExecutor reportExecutor = new ReportExecutor(report);
            ReportResults results = reportExecutor.execute(pageProperties.addOrderType(), Integer.toString(pageProperties.addOrderColNr()), pageProperties.offset(), pageProperties.pageSize(), true);
            if (results != null) {
                checkTextAsNumber = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CHECK_TEXT_AS_NUMBER_IN_ADVANCE_SEARCH_EXPORT);
                CellWriter cellWriter = new CellWriter(wb, checkTextAsNumber);
                ArrayList reportResults = results.result();
                if (reportResults != null && reportResults.size() > 0) {
                    iSize = reportResults.size();
                    log.info((Object)("Ilosc wynikow: " + iSize));
                    row = sheet.createRow(rowNum++);
                    cell = row.createCell(colNum++);
                    cell.setCellValue((RichTextString)new XSSFRichTextString("Lp."));
                    cell.setCellStyle(headerStyle);
                    for (ReportResult.AdvanceVariable var : ((ReportResult)reportResults.get(0)).getVariables()) {
                        cell = row.createCell(colNum++);
                        cell.setCellValue((RichTextString)new XSSFRichTextString(var.getDisplayName()));
                        cell.setCellStyle(headerStyle);
                    }
                    noOfColumns = row.getLastCellNum();
                    while (iIterations * iPageSize < iSize) {
                        for (int i = iIterations * iPageSize; i < iIterations * iPageSize + iPageSize && i < iSize; ++i) {
                            ReportResult reportResult = (ReportResult)reportResults.get(i);
                            row = sheet.createRow(rowNum++);
                            colNum = 0;
                            cell = row.createCell(colNum++);
                            cell.setCellValue((double)(rowNum - 1));
                            for (ReportResult.AdvanceVariable var : reportResult.getVariables()) {
                                cell = row.createCell(colNum++);
                                cellWriter.writeCell(var.getDisplayValue(), var.getValue(), var.getVariableType(), cell);
                            }
                        }
                        log.info((Object)("Iteracja: " + ++iIterations));
                    }
                    for (int i = 0; i <= noOfColumns; ++i) {
                        sheet.autoSizeColumn(i);
                    }
                } else {
                    log.info((Object)"Brak wynikow raportu");
                }
            } else {
                log.info((Object)"Brak wynikow raportu");
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.addHeader("Content-Disposition", "attachment; filename=\"eksport.xlsx\"");
            response.addHeader("6578706f7274", "true");
            os = response.getOutputStream();
            wb.write((OutputStream)os);
            os.flush();
        }
    }

    private class CellWriter {
        private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        private SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private SimpleDateFormat dateTimeShortFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private CellStyle dateCellStyle;
        private CellStyle dateTimeCellStyle;
        private CellStyle dateTimeShortCellStyle;
        private boolean checkTextAsNumber;
        private CreationHelper createHelper;

        public CellWriter(SXSSFWorkbook wb, boolean checkTextAsNumber) {
            this.createHelper = wb.getCreationHelper();
            this.checkTextAsNumber = checkTextAsNumber;
            this.createCellStyles(wb);
        }

        private void createCellStyles(SXSSFWorkbook wb) {
            this.dateCellStyle = wb.createCellStyle();
            this.dateCellStyle.setDataFormat(this.createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
            this.dateTimeCellStyle = wb.createCellStyle();
            this.dateTimeCellStyle.setDataFormat(this.createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
            this.dateTimeShortCellStyle = wb.createCellStyle();
            this.dateTimeShortCellStyle.setDataFormat(this.createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm"));
        }

        public void writeCell(String displayValue, Object realValue, Type<?> type, Cell cell) {
            if (!this.trySetCellValueAsDate(cell, displayValue, type)) {
                if (this.isNumber(realValue, type)) {
                    String stringValue;
                    String string = stringValue = realValue == null ? null : realValue.toString();
                    if (StringUtils.isNotBlank((String)stringValue)) {
                        cell.setCellValue(Double.valueOf(realValue.toString()).doubleValue());
                    }
                } else if (this.checkTextAsNumber) {
                    String replacedValue = displayValue.replace(",", ".").replace(" ", "");
                    if (NumberUtils.isNumber((String)replacedValue) && replacedValue.matches("^\\-?[0-9.]+")) {
                        Number num = (Number)this.getNumberClassObject(replacedValue);
                        cell.setCellValue(num.doubleValue());
                    } else {
                        cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(displayValue)));
                    }
                } else {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(this.escapeExcelColumnValue(displayValue)));
                }
            }
        }

        private boolean trySetCellValueAsDate(Cell cell, String value, Type<?> type) {
            Date date = null;
            if (type == null || type.toString().equals("datetime") || type.toString().equals("date")) {
                try {
                    date = this.dateTimeFormatter.parse(value);
                    this.setCellValue(cell, date, this.dateTimeCellStyle);
                }
                catch (Exception e1) {
                    try {
                        date = this.dateTimeShortFormatter.parse(value);
                        this.setCellValue(cell, date, this.dateTimeShortCellStyle);
                    }
                    catch (Exception e2) {
                        try {
                            date = this.dateFormatter.parse(value);
                            this.setCellValue(cell, date, this.dateCellStyle);
                        }
                        catch (Exception e3) {
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }

        private void setCellValue(Cell cell, Date date, CellStyle dateCellStyle) {
            cell.setCellValue(date);
            cell.setCellStyle(dateCellStyle);
        }

        private String escapeExcelColumnValue(String rawValue) {
            if (rawValue == null) {
                return "";
            }
            rawValue = StringEscapeUtils.escapeJava((String)StringUtils.trimToEmpty((String)rawValue));
            rawValue = StringUtils.replace((String)StringUtils.trim((String)rawValue), (String)"\\t", (String)"    ");
            rawValue = StringUtils.replace((String)StringUtils.trim((String)rawValue), (String)"\\r", (String)" ");
            rawValue = StringEscapeUtils.unescapeJava((String)rawValue);
            return rawValue;
        }

        private Object getNumberClassObject(String sTest) {
            try {
                Integer.parseInt(sTest);
                return new Integer(sTest);
            }
            catch (NumberFormatException nfe1) {
                try {
                    Long.parseLong(sTest);
                    return new Long(sTest);
                }
                catch (NumberFormatException nfe2) {
                    try {
                        Double.parseDouble(sTest);
                        return new Double(sTest);
                    }
                    catch (NumberFormatException nfe3) {
                        try {
                            Float.parseFloat(sTest);
                            return new Float(sTest);
                        }
                        catch (NumberFormatException nfe4) {
                            return sTest;
                        }
                    }
                }
            }
        }

        private boolean isNumber(Object value, Type<?> type) {
            return value instanceof Number || this.isNumber(type);
        }

        private boolean isNumber(Type<?> type) {
            return type == Types.INTEGER || type == Types.INTEGER_ARRAY || type == Types.FLOAT || type == Types.FLOAT_ARRAY;
        }
    }
}

