/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportVariableTable;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.i18n.I18N;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.struts.action.reports.ShowJasperRaportResultAction;
import com.plusmpm.struts.action.reports.ShowReportParametersAction;
import com.plusmpm.struts.form.FilterVariableForm;
import com.plusmpm.util.ReportResult;
import com.plusmpm.util.Tools;
import com.plusmpm.util.reports.Report;
import com.plusmpm.util.reports.ReportExecutor;
import com.plusmpm.util.reports.ReportFactory;
import com.plusmpm.util.reports.ReportPermissions;
import com.plusmpm.util.reports.ReportResults;
import com.plusmpm.util.reports.util._PageProperties;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.report.ReportService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.hibernate.HibernateException;

public class ReportCreateAction
extends Action {
    public static Logger log = Logger.getLogger(ReportCreateAction.class);
    public static Logger performanceLog = Logger.getLogger((String)"PerformanceLog");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        I18NCustom customi18n = new I18NCustom(request);
        log.info((Object)"******************************ReportCreateAction********************");
        try {
            ReportResults results;
            String userName;
            HttpSession session = request.getSession(false);
            if (session == null || (userName = (String)session.getAttribute("username")) == null) {
                return mapping.findForward("welcome");
            }
            DynaActionForm reportDefinitionForm = (DynaActionForm)form;
            _PageProperties pageProperties = new _PageProperties(request, userName);
            String reportId = request.getParameter("reportId");
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "html";
            }
            if (!ReportPermissions.reportPermissions((String)userName, (String)reportId)) {
                return mapping.findForward("welcome");
            }
            DBManagement dbm = new DBManagement();
            ReportsTable reportTable = null;
            if (!Tools.isNullOrEmpty((String)reportId)) {
                reportTable = dbm.getReport(reportId);
            }
            if (reportTable != null && reportTable.getReportType() != null && reportTable.getReportType().compareTo(ReportsTable.REPORT_TYPE_JASPER) == 0) {
                ArrayList alReportVariable = (ArrayList)dbm.GetAllVariableInReport(reportId);
                if (alReportVariable.size() == 0) {
                    if (reportType.equals("html")) {
                        return mapping.findForward("showJasperRaportParams");
                    }
                    HashMap<String, String> hmParameters = new HashMap<String, String>();
                    ShowJasperRaportResultAction showJasperRaportResultAction = new ShowJasperRaportResultAction();
                    return showJasperRaportResultAction.createJasperReport(mapping, request, response, hmParameters);
                }
                boolean bOnlyUserNameParam = true;
                HashMap<String, String> hmParameters = new HashMap<String, String>();
                for (ReportVariableTable param : alReportVariable) {
                    String sortType = param.getSortType();
                    if (!sortType.equalsIgnoreCase("username")) {
                        bOnlyUserNameParam = false;
                        break;
                    }
                    hmParameters.put(param.getName(), userName);
                }
                if (bOnlyUserNameParam) {
                    if (reportType.equals("html")) {
                        request.setAttribute("params", hmParameters);
                        return mapping.findForward("showJasperRaportParams");
                    }
                    ShowJasperRaportResultAction showJasperRaportResultAction = new ShowJasperRaportResultAction();
                    return showJasperRaportResultAction.createJasperReport(mapping, request, response, hmParameters);
                }
                ShowReportParametersAction showReportParametersAction = new ShowReportParametersAction();
                return showReportParametersAction.execute(mapping, (ActionForm)reportDefinitionForm, request, response);
            }
            String viewInfo = (String)reportDefinitionForm.get("sqlQuery");
            if (viewInfo == null || viewInfo.equals("")) {
                viewInfo = (String)reportDefinitionForm.get("viewId");
            }
            Date dt = new Date();
            Report report = new ReportFactory().make(reportId, userName, viewInfo, reportDefinitionForm);
            FilterVariableForm[] filter = report.filterVariables(null);
            if ("true".equalsIgnoreCase(report.showFormOnResult()) || "on".equalsIgnoreCase(report.showFormOnResult())) {
                ArrayList list = new ArrayList(0);
                results = new ReportResults(list, 0);
            } else {
                ReportExecutor reportExecutor = new ReportExecutor(report);
                results = reportExecutor.execute(pageProperties.addOrderType(), Integer.toString(pageProperties.addOrderColNr()), pageProperties.offset(), pageProperties.pageSize());
                Date dt2 = new Date();
                performanceLog.info((Object)("|Report|" + report.name() + "|" + (dt2.getTime() - dt.getTime())));
            }
            ArrayList resultsList = results.result();
            for (ReportResult reportResult : resultsList) {
                for (ReportResult.AdvanceVariable variable : reportResult.getVariables()) {
                    variable.setDisplayName(customi18n.getString(variable.getDisplayName()));
                }
            }
            request.setAttribute("iPageSize", (Object)Integer.toString(pageProperties.pageSize()));
            request.setAttribute("alResult", (Object)results.result());
            request.setAttribute("iMaxPageSize", (Object)Integer.toString(results.records()));
            ReportService reportService = ServiceFactory.getReportService();
            String reportName = StringUtils.isBlank((String)reportId) ? report.name() : reportService.getReportTranslation(Long.valueOf(reportId), TranslatedFieldType.NAME);
            request.setAttribute("reportName", (Object)reportName);
            session.setAttribute("report", (Object)report);
            request.setAttribute("showForm", (Object)report.showFormOnResult());
            request.setAttribute("canFilter", (Object)report.canFilterResult());
            request.setAttribute("filter", (Object)filter);
            request.setAttribute("auditSuccess", (Object)true);
        }
        catch (SQLException | HibernateException e) {
            I18N oMessage = new I18N(request);
            log.error((Object)("Exception:" + e.getLocalizedMessage()), e);
            request.setAttribute("errorMessage", (Object)oMessage.getString("Wygenerowane_zapytanie_SQL_jest_niepoprawne"));
            return mapping.findForward("showReportError");
        }
        catch (ViewDoesNotExistException e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            request.setAttribute("errorMessage", (Object)MessageHelper.getMessage((String)"Widok_nie_istnieje", (Object[])new Object[]{e.getId()}));
            return mapping.findForward("showReportError");
        }
        catch (Exception e) {
            I18N oMessage = new I18N(request);
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            request.setAttribute("errorMessage", (Object)oMessage.getString("Raport_zawiera_bledy"));
            return mapping.findForward("showReportError");
        }
        return mapping.findForward("showResult");
    }
}

