/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.query.NamedParametersQuery;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UserInfo;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.classLoader.PlusClassLoader;
import com.plusmpm.util.delegation.DelegationUsers;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.database.NativeSqlUtils;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.displaytag.util.ParamEncoder;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.StringType;

public class ShowGetsUsersAction
extends Action {
    public static Logger log = Logger.getLogger(ShowGetsUsersAction.class);
    private HookRegistry hr = (HookRegistry)SpringContext.getBean(HookRegistry.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SortDirection sortDirection;
        log.info((Object)"******************************ShowGetsUsersAction********************");
        HttpSession session = request.getSession(false);
        String sUserName = (String)session.getAttribute("username");
        String sQuerry = "";
        String userType = request.getParameter("userType");
        String destination = request.getParameter("destination");
        String groupId = request.getParameter("groupId");
        List<Object> alUserList = null;
        UserFinder userFinder = (UserFinder)SpringContext.getBean(UserFinder.class);
        UserSettingsService userSettingsService = (UserSettingsService)SpringContext.getBean(UserSettingsService.class);
        if (userType == null) {
            userType = "";
        }
        HashMap<String, Object> params = null;
        String pageNumberParam = request.getParameter(new ParamEncoder("shortgroup").encodeParameterName("p"));
        int pageSize = userSettingsService.getUserPageSize(UserContext.current().getUser().getUserName());
        int pageNumber = pageNumberParam != null ? Integer.parseInt(pageNumberParam) : 1;
        int start = (pageNumber - 1) * pageSize;
        String sortByParam = request.getParameter(new ParamEncoder("shortgroup").encodeParameterName("s"));
        String sortDirectionParam = request.getParameter(new ParamEncoder("shortgroup").encodeParameterName("o"));
        String sortBy = sortByParam != null ? this.getSortByName(sortByParam) : "userName";
        SortDirection sortDirection2 = sortDirection = sortDirectionParam != null ? this.getSortDirection(sortDirectionParam) : SortDirection.ASC;
        if (userType.equalsIgnoreCase("delegation")) {
            String delegationUsernameId = request.getParameter("delegationUsernameId");
            if (StringUtils.isNotBlank((CharSequence)delegationUsernameId)) {
                List users = ((SubstitutionHook)this.hr.invoke(SubstitutionHook.class)).getSubstitutes(sUserName, delegationUsernameId);
                if (users == null) {
                    String userListType = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DELEGATION_USERLISTTYPE);
                    alUserList = ShowGetsUsersAction.getDelegationUserList(request, sUserName, delegationUsernameId, destination, userListType);
                    if (alUserList == null) {
                        if (userListType != null && userListType.compareToIgnoreCase("ouUsers") == 0) {
                            alUserList = this.getOrgUnitsUserList(delegationUsernameId, destination);
                            userType = "ouUsers";
                        } else {
                            if (!Tools.isNullOrEmpty((String)userListType) && !userListType.equalsIgnoreCase("allUsers")) {
                                log.warn((Object)"B\u0142\u0105d w pliku shark.conf. Delegation.UserListType ma nieprawidlow\u0105 warto\u015b\u0107");
                            }
                            alUserList = userFinder.findByCriteria(this.getDetachedCriteria(sortBy, sortDirection), Integer.valueOf(start), Integer.valueOf(pageSize), true).stream().map(user -> {
                                UserInfo userInfo = UserInfo.fromEntity((User)user);
                                userInfo.setM_sSpecialValue(destination);
                                if (StringUtils.isNotBlank((CharSequence)groupId)) {
                                    userInfo.setM_sSpecialValue(groupId);
                                    request.setAttribute("groupId", (Object)groupId);
                                }
                                return userInfo;
                            }).collect(Collectors.toList());
                            userType = "allUsers";
                        }
                    }
                } else {
                    for (User user2 : users) {
                        UserInfo userInfo = UserInfo.fromEntity((User)user2);
                        userInfo.setM_sSpecialValue(destination);
                        alUserList.add((UserInfo)((Object)userInfo));
                    }
                }
                if (alUserList != null) {
                    alUserList = alUserList.stream().filter(user -> !user.getM_sUserName().equals(delegationUsernameId)).collect(Collectors.toList());
                }
            } else {
                log.warn((Object)"B\u0142\u0105d - brak nazwy u\u017cytkownika, dla kt\u00f3rego wybieramy zast\u0119pce.");
            }
        } else if (userType.equalsIgnoreCase("ouUsers")) {
            alUserList = this.getOrgUnitsUserList(sUserName, destination);
        } else if (userType.equalsIgnoreCase("allUsers")) {
            alUserList = userFinder.findByCriteria(this.getDetachedCriteria(sortBy, sortDirection), Integer.valueOf(start), Integer.valueOf(pageSize), true).stream().map(user -> {
                UserInfo userInfo = UserInfo.fromEntity((User)user);
                userInfo.setM_sSpecialValue(destination);
                if (StringUtils.isNotBlank((CharSequence)groupId)) {
                    userInfo.setM_sSpecialValue(groupId);
                    request.setAttribute("groupId", (Object)groupId);
                }
                return userInfo;
            }).collect(Collectors.toList());
        } else {
            params = new HashMap<String, Object>();
            sQuerry = this.getSearchUsersQuery(request, params);
        }
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(User.class);
        int resultSize = (int)userFinder.count(detachedCriteria);
        if (!Tools.isNullOrEmpty((String)sQuerry)) {
            alUserList = this.getUserListFromQuerry(request, sQuerry, params, groupId, destination);
            resultSize = alUserList.size();
            alUserList = alUserList.stream().sorted(this.getComparator(sortBy, sortDirection)).skip(start).limit(pageSize).collect(Collectors.toList());
        }
        request.setAttribute("userList", alUserList);
        request.setAttribute("resultSize", (Object)resultSize);
        request.setAttribute("destination", (Object)destination);
        boolean tableAction = Boolean.valueOf(request.getParameter("tableAction"));
        if (userType.compareToIgnoreCase("allUsers") == 0 && !tableAction) {
            return mapping.findForward("showSearchUser");
        }
        return mapping.findForward("showSearchedUser");
    }

    private Comparator<? super UserInfo> getComparator(String sortBy, SortDirection sortDirection) {
        Comparator<UserInfo> comparator = switch (sortBy) {
            case "firstName" -> Comparator.comparing(UserInfo::getM_sUserFirstName);
            case "lastName" -> Comparator.comparing(UserInfo::getM_sUserLastName);
            default -> Comparator.comparing(UserInfo::getM_sUserName);
        };
        comparator = sortDirection == SortDirection.ASC ? comparator : comparator.reversed();
        return comparator;
    }

    private DetachedCriteria getDetachedCriteria(String sortBy, SortDirection sortDirection) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(User.class);
        Order order = sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy);
        detachedCriteria.addOrder(order);
        return detachedCriteria;
    }

    private String getSortByName(String sortByParam) {
        switch (Integer.parseInt(sortByParam)) {
            case 1: {
                return "firstName";
            }
            case 2: {
                return "lastName";
            }
        }
        return "userName";
    }

    private SortDirection getSortDirection(String sortDirectionParam) {
        return Integer.parseInt(sortDirectionParam) == 1 ? SortDirection.DESC : SortDirection.ASC;
    }

    protected static String divideTooLongTableField(String anyField) {
        if (anyField.length() > 22 && anyField.trim().matches(".*\\S{22,}+.*")) {
            String pre = anyField.substring(0, 22);
            String post = anyField.substring(22);
            return pre + "- " + post;
        }
        return anyField;
    }

    private static ArrayList<UserInfo> getCustomClassUserList(String delegationUsernameId, String destination, String className) {
        ArrayList loginList = null;
        ArrayList<Object> userList = null;
        DelegationUsers du = null;
        PlusClassLoader plusClassLoader = new PlusClassLoader();
        try {
            Class classDU = plusClassLoader.loadClass(className);
            du = (DelegationUsers)classDU.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Nie uda\u0142o si\u0119 wczyta\u0107 klasy \"" + className + "\" - Delegation.CustomClass"), (Throwable)e);
            userList = new ArrayList<UserInfo>();
            return userList;
        }
        loginList = du.getUsersList(delegationUsernameId);
        if (loginList != null) {
            userList = new ArrayList();
            for (String userId : loginList) {
                UserInfo usersInfo = new UserInfo();
                usersInfo.setM_sUserName(userId);
                try {
                    String sFirstName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserFirstName(userId);
                    usersInfo.setM_sUserFirstName(sFirstName);
                    String sLastName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserLastName(userId);
                    usersInfo.setM_sUserLastName(sLastName);
                    usersInfo.setM_sSpecialValue(destination);
                    userList.add(usersInfo);
                }
                catch (BaseException e) {
                    log.warn((Object)("B\u0142\u0105d odczytu u\u017cytkownika o loginie: " + userId));
                }
            }
        }
        return userList;
    }

    private ArrayList<UserInfo> getOrgUnitsUserList(String sUserName, String destination) {
        DBManagement dbm = new DBManagement();
        UsersManagement um = new UsersManagement();
        ArrayList alOus = um.getUserOUs(sUserName);
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        OrganizationalUnitFinder ous = FinderFactory.getOrganizationalUnitFinder();
        UserFinder userFinder = FinderFactory.getUserFinder();
        for (int i = 0; i < alOus.size(); ++i) {
            String sOU = (String)alOus.get(i);
            if (sOU == null) continue;
            List alOUs = ous.findByName(sOU, new String[0]);
            for (OrganizationalUnit ou : alOUs) {
                List users = userFinder.findByOU(ou.getSymbol());
                for (User user : users) {
                    String sUserId = user.getUserName();
                    boolean userInList = false;
                    for (UserInfo u : userList) {
                        if (!sUserId.equals(u.getM_sUserName())) continue;
                        userInList = true;
                    }
                    if (userInList) continue;
                    UserInfo usersInfo = new UserInfo();
                    usersInfo.setM_sUserName(sUserId);
                    try {
                        String sFirstName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserFirstName(sUserId);
                        usersInfo.setM_sUserFirstName(sFirstName);
                        String sLastName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserLastName(sUserId);
                        usersInfo.setM_sUserLastName(sLastName);
                    }
                    catch (BaseException e) {
                        log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    usersInfo.setM_sSpecialValue(destination);
                    userList.add(usersInfo);
                }
            }
        }
        return userList;
    }

    public static ArrayList<UserInfo> getDelegationUserList(HttpServletRequest request, String sUserName, String delegationUsernameId, String destination, String userListType) {
        String className = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DELEGATION_CUSTOMCLASS);
        ArrayList<UserInfo> userList = null;
        if (!Tools.isNullOrEmpty((String)className)) {
            userList = ShowGetsUsersAction.getCustomClassUserList(delegationUsernameId, destination, className);
        }
        return userList;
    }

    private String getAllUsersQuery(String delegationUsernameId) {
        String query = "select * from usertable where active=" + NativeSqlUtils.getBooleanValue((boolean)true) + " ";
        if (!StringUtils.isEmpty((CharSequence)delegationUsernameId)) {
            query = query + "and userid <> '" + delegationUsernameId + "' ";
        }
        return query;
    }

    private String getSearchUsersQuery(HttpServletRequest request, Map<String, Object> params) {
        String sUserLogin = request.getParameter("searchUserName");
        String sUserFirstName = request.getParameter("searchUserFirstName");
        String searchUserLastName = request.getParameter("searchUserLastName");
        String sQuerry = "select * from usertable where active=" + NativeSqlUtils.getBooleanValue((boolean)true) + " ";
        if (sUserLogin != null && sUserLogin.compareToIgnoreCase("") != 0) {
            sUserLogin = sUserLogin.toUpperCase().replaceAll("[*]", "%");
            sQuerry = sQuerry + " and upper(userid) LIKE :userlogin";
            params.put("userlogin", "%" + sUserLogin + "%");
        }
        if (sUserFirstName != null && sUserFirstName.compareToIgnoreCase("") != 0) {
            sUserFirstName = sUserFirstName.toUpperCase().replaceAll("[*]", "%");
            sUserFirstName = sUserFirstName.replaceAll(" +", "%");
            sQuerry = sQuerry + " and upper(firstname) LIKE :firstname";
            params.put("firstname", "%" + sUserFirstName + "%");
        }
        if (searchUserLastName != null && searchUserLastName.compareToIgnoreCase("") != 0) {
            searchUserLastName = searchUserLastName.toUpperCase().replaceAll("[*]", "%");
            searchUserLastName = searchUserLastName.replaceAll(" +", "%");
            sQuerry = sQuerry + " and upper(lastname) LIKE :lastname";
            params.put("lastname", "%" + searchUserLastName + "%");
        }
        return sQuerry;
    }

    private ArrayList<UserInfo> getUserListFromQuerry(HttpServletRequest request, String sQuerry, Map<String, Object> params, String groupId, String destination) {
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        try {
            log.info((Object)("Querry: " + sQuerry));
            HashMap<String, StringType> scalars = new HashMap<String, StringType>();
            scalars.put("userid", StandardBasicTypes.STRING);
            scalars.put("firstname", StandardBasicTypes.STRING);
            scalars.put("lastname", StandardBasicTypes.STRING);
            NamedParametersQuery namedParametersQuery = new NamedParametersQuery(sQuerry, params, null);
            namedParametersQuery.setScalars(scalars);
            List results = namedParametersQuery.list(0, 0);
            for (Map row : results) {
                String userid = (String)row.get("userid");
                String firstname = (String)row.get("firstname");
                String lastname = (String)row.get("lastname");
                UserInfo usersInfo = new UserInfo();
                usersInfo.setM_sUserName(userid);
                usersInfo.setM_sUserFirstName(firstname);
                usersInfo.setM_sUserLastName(lastname);
                usersInfo.setM_sSpecialValue(destination);
                if (StringUtils.isNotBlank((CharSequence)groupId)) {
                    usersInfo.setM_sSpecialValue(groupId);
                    request.setAttribute("groupId", (Object)groupId);
                }
                userList.add(usersInfo);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return userList;
    }
}

