/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.files.DocumentSearch;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.database.files.FileVersions;
import com.plusmpm.database.files.FileVersionsAccess;
import com.plusmpm.i18n.I18N;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.struts.form.VariableListForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.IndexData;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.context.i18n.LocaleContextHolder;

public class ShowDocumentInformationAction
extends Action {
    public static Logger log = Logger.getLogger(ShowDocumentInformationAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info((Object)"*********************ShowDocumentInformationAction******************");
        I18N oMessage = new I18N(request);
        HttpSession session = request.getSession(false);
        String userName = (String)session.getAttribute("username");
        if (session == null || userName == null) {
            return mapping.findForward("disconnect");
        }
        String encodedFileId = request.getParameter("fileId");
        String docClassId = request.getParameter("docClassId");
        if (Tools.isNullOrEmpty((String)encodedFileId)) {
            log.info((Object)"Brak parametru fileId");
            request.setAttribute("message", (Object)(oMessage.getString("Dokument_nie_istnieje") + "!"));
            return mapping.findForward("showMessage");
        }
        String fileId = Tools.decodeStringBase64((String)encodedFileId);
        if (fileId == null) {
            log.warn((Object)"B\u0142\u0105d podczas dekodowania fileId");
            request.setAttribute("message", (Object)(oMessage.getString("Dokument_nie_istnieje") + "!"));
            return mapping.findForward("showMessage");
        }
        if (Tools.isNullOrEmpty((String)docClassId)) {
            DBManagement dbm = new DBManagement();
            DocClassTable docClass = dbm.getDocClassNameForFileId(new Long(fileId));
            docClassId = docClass.getId().toString();
        }
        String processRightKey = request.getParameter("key");
        Boolean hasRights = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, Long.valueOf(Long.parseLong(fileId))) || this.checkRightsToFile(userName, Long.parseLong(fileId), processRightKey) != false;
        if (hasRights.booleanValue()) {
            ExtendedDocumentData documentData = ShowDocumentInformationAction.getExtDocumentDataForFileId(fileId, docClassId, userName);
            if (documentData == null) {
                log.info((Object)("Nie znaleziono dokumentu dla pliku fileId: " + fileId));
                request.setAttribute("message", (Object)(oMessage.getString("Dokument_nie_istnieje") + "!"));
                return mapping.findForward("showMessage");
            }
            List<FileVersions> versions = this.getAllVersions(fileId);
            if (versions.size() > 1) {
                request.setAttribute("versions", versions);
            }
            if (documentData.getAlIndecies().size() > 0) {
                request.setAttribute("indices", (Object)documentData.getAlIndecies());
            }
            String processId = (String)session.getAttribute("processKey");
            String activityId = (String)session.getAttribute("activityId");
            String documentLinkTemplate = "ShowFile.do?processId=" + processId + "&activityId=" + activityId + "&fileName=";
            request.setAttribute("documentLinkTemplate", (Object)documentLinkTemplate);
            request.setAttribute("documentData", (Object)documentData);
            return mapping.findForward("showInformations");
        }
        log.info((Object)("Uzytkownik nie ma praw do podanego dokumentu - " + userName));
        request.setAttribute("message", (Object)oMessage.getString("Brak_uprawnien"));
        return mapping.findForward("showMessage");
    }

    private Boolean checkRightsToFile(String userName, Long fileId, String processRightKey) {
        return Authorization.hasRightsToReadFile((String)userName, (Long)fileId, (String)processRightKey);
    }

    private List<FileVersions> getAllVersions(String fileId) {
        FileVersionsAccess fva = new FileVersionsAccess();
        List versions = fva.getAllVersions(new Long(fileId));
        return versions;
    }

    public static ExtendedDocumentData getExtDocumentDataForFileId(String fileId, String docClassId, String userName) {
        String restriction = String.format("pm_files.id=%s", fileId);
        DocumentSearch docSearch = new DocumentSearch(userName, -651234L);
        ArrayList indexes = DBManagement.GetAllIndecies((String)docClassId);
        VariableListForm[] indexesForm = new VariableListForm[indexes.size() + 1];
        indexesForm[0] = new VariableListForm();
        indexesForm[0].setVarName("DocClassId");
        indexesForm[0].setVarType("String");
        indexesForm[0].setVarValue(docClassId);
        for (int i = 0; i < indexes.size(); ++i) {
            IndexTable index = (IndexTable)indexes.get(i);
            VariableListForm var = new VariableListForm();
            var.setVarID(index.getId().toString());
            var.setVarName(index.getIndexName());
            var.setVarType(index.getIndexType());
            var.setVarShow("on");
            indexesForm[i + 1] = var;
        }
        docSearch.addIndexes(indexesForm);
        docSearch.addCustomRestriction(restriction);
        List docs = docSearch.list();
        if (docs.size() == 0) {
            log.info((Object)("Nie znaleziono pliku o podanym id: " + fileId));
            return null;
        }
        ExtendedDocumentData documentData = (ExtendedDocumentData)docs.get(0);
        ShowDocumentInformationAction.translateDocumentData(documentData);
        return documentData;
    }

    private static void translateDocumentData(ExtendedDocumentData documentData) {
        I18NCustom i18n = new I18NCustom(LocaleContextHolder.getLocale());
        documentData.setLDocClassName(i18n.getStringSilent(documentData.getLDocClassName()));
        documentData.setDescription(i18n.getStringSilent(documentData.getDescription()));
        for (IndexData indexData : documentData.getAlIndecies()) {
            indexData.setName(i18n.getStringSilent(indexData.getName()));
        }
    }
}

