/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.workflow.processes.ProcessVariable;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.variable.VariableTypeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.context.i18n.LocaleContextHolder;

public class ProcessVariablesAction
extends Action {
    private VariableTypeResolver variableTypeResolver = (VariableTypeResolver)SpringContext.getBean(VariableTypeResolver.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String processDefinitionId = request.getParameter("procTypeId");
        String packageId = request.getParameter("processPackageId");
        request.setAttribute("processVariables", this.getDataFields(processDefinitionId, packageId));
        request.setAttribute("processDefinitionId", (Object)processDefinitionId);
        return mapping.findForward("processVariables");
    }

    private List<ProcessVariable> getDataFields(String processDefinitionId, String packageId) {
        I18Nxpdl translator = new I18Nxpdl(LocaleContextHolder.getLocale());
        WorkflowProcess workflowProcess = XpdlPackageManager.getInstance().getPackage(packageId).getWorkflowProcess(processDefinitionId);
        ArrayList elements = workflowProcess.getDataFields().toElements();
        return elements.stream().map(dataField -> {
            String typeTranslationKey;
            String dataFieldId = dataField.getId();
            String translationKey = XpdlKey.forPackage((String)packageId).forProcess(processDefinitionId).forDataField(dataFieldId).getKey();
            String translatedName = translator.getStringSilent(translationKey);
            Type type = this.variableTypeResolver.guessType(dataField);
            Boolean isArray = false;
            if (type instanceof JsonTypeBase) {
                typeTranslationKey = ((JsonTypeBase)type).translationKey();
            } else if (type instanceof ArrayType) {
                isArray = true;
                Type elementType = ((ArrayType)type).getElementType();
                typeTranslationKey = ((JsonTypeBase)elementType).translationKey();
            } else {
                typeTranslationKey = type.name();
            }
            return new ProcessVariable(dataFieldId, translatedName, MessageHelper.getOptionalMessage((String)typeTranslationKey), isArray);
        }).collect(Collectors.toList());
    }
}

