/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.VariableListForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocsMerger.DocsMerger;
import com.plusmpm.util.DocumentData;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintLinkSearchedDocumentsAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(PrintLinkSearchedDocumentsAction.class);
    private final LinkService linkService = (LinkService)SpringContext.getBean(LinkService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("******************************PrintLinkSearchedDocumentsAction********************");
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        String username = (String)session.getAttribute("username");
        int sortColumnNumber = session.getAttribute("searchLinkSortColumn") != null ? (Integer)session.getAttribute("searchLinkSortColumn") : 0;
        int sortOrderType = session.getAttribute("searchLinkSortOrder") != null ? (Integer)session.getAttribute("searchLinkSortOrder") : 0;
        ArrayList<String> searchedDocumentClasses = new ArrayList<String>();
        DynaActionForm searchVariableForm = (DynaActionForm)session.getAttribute("searchLinkForm");
        session.setAttribute("searchLinkForm", (Object)searchVariableForm);
        VariableListForm[] variableListForm = (VariableListForm[])searchVariableForm.get("lines");
        VariableListForm[] documentClassesListForm = (VariableListForm[])searchVariableForm.get("docclasses");
        if (documentClassesListForm != null) {
            for (VariableListForm listForm : documentClassesListForm) {
                if (listForm.VarID == null) break;
                if (listForm.VarValue == null || listForm.VarValue.compareToIgnoreCase("on") != 0) continue;
                searchedDocumentClasses.add(listForm.VarID);
            }
        }
        DBManagement dbm = new DBManagement();
        String dateStart = (String)searchVariableForm.get("dateStart");
        String dateFinish = (String)searchVariableForm.get("dateFinish");
        boolean showDate = "on".equals(searchVariableForm.get("showDate"));
        List documents = new ArrayList();
        if (!searchedDocumentClasses.isEmpty()) {
            try {
                documents = dbm.searchLinkCounted(variableListForm, username, dateStart, dateFinish, -1, -1, sortOrderType, sortColumnNumber, searchedDocumentClasses, showDate, true).getData();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                request.setAttribute("linkId", (Object)variableListForm[0].VarValue);
                request.setAttribute("errorMessage", (Object)MessageHelper.getMessage((String)"Bledna_konfiguracja_powiazan_indeksow"));
                return mapping.findForward("showLinkSearchError");
            }
        }
        HashMap<String, Long> rightMap = new HashMap<String, Long>();
        for (String id : searchedDocumentClasses) {
            long printRights = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)id).printing().build(), (String)username, (boolean)false, (boolean)false);
            rightMap.put(id, printRights);
        }
        List foundFileIds = documents.stream().filter(document -> {
            Long right = (Long)rightMap.get(String.valueOf(document.getLDocClassId()));
            return right.equals(0L) || right.equals(1L);
        }).map(DocumentData::getLFileId).collect(Collectors.toList());
        try {
            response.setContentType("aplication/pdf");
            response.setHeader("Content-Disposition", "attachment; filename=\"Documents.pdf\"");
            DocsMerger.merge(foundFileIds, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.info("Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia dokument\u00f3w");
        }
        return null;
    }
}

