/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.struts.action.DocumentTemplatesAction;
import com.plusmpm.struts.form.DocumentTemplateForm;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AddDocumentTemplateAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        I18NCustom customi18n = new I18NCustom(request);
        DocumentTemplateForm documentTemplateForm = (DocumentTemplateForm)form;
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("disconnect");
        }
        DocumentTemplatesAction documentTemplatesAction = new DocumentTemplatesAction();
        ArrayList alDocumentTemplates = documentTemplatesAction.GetDocumentTemplates(request, documentTemplateForm.getProcessId());
        Boolean validate = this.validation(request, documentTemplateForm, alDocumentTemplates);
        if (validate.booleanValue()) {
            DocumentTemplateTable documentTemplateTable = new DocumentTemplateTable(documentTemplateForm.getTemplateName(), documentTemplateForm.getTemplatePath(), documentTemplateForm.getProcessId());
            DBManagement dbm = new DBManagement();
            dbm.addDocumentTemplate(documentTemplateTable);
            alDocumentTemplates.add(documentTemplateTable);
            for (DocumentTemplateTable template : alDocumentTemplates) {
                template.setTemplateName(customi18n.getString(template.getTemplateName()));
            }
            request.setAttribute("auditSuccess", (Object)true);
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Szablon_zostal_dodany"));
            request.setAttribute("messageType", (Object)"success");
        } else {
            request.setAttribute("auditSuccess", (Object)false);
            request.setAttribute("messageType", (Object)"error");
        }
        request.setAttribute("alDocumentTemplates", (Object)alDocumentTemplates);
        return mapping.findForward("showNewDocumentTemplates");
    }

    public Boolean validation(HttpServletRequest request, DocumentTemplateForm documentTemplateForm, List<DocumentTemplateTable> alDocumentTemplates) {
        if (StringUtils.isBlank((CharSequence)documentTemplateForm.getTemplatePath()) || StringUtils.isBlank((CharSequence)documentTemplateForm.getTemplateName())) {
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Uzupelnij_nazwe_i_sciezke_szablonu"));
            return false;
        }
        for (DocumentTemplateTable template : alDocumentTemplates) {
            if (template.getTemplatePath().equals(documentTemplateForm.getTemplatePath())) {
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Szablon_o_podanej_sciezce_ju\u017c_istnieje"));
                return false;
            }
            if (!template.getTemplateName().equals(documentTemplateForm.getTemplateName())) continue;
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Szablon_o_podanej_nazwie_ju\u017c_istnieje"));
            return false;
        }
        return true;
    }
}

