/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.virtualtables;

import com.plusmpm.database.virtualtables.Column;
import com.plusmpm.database.virtualtables.Table;
import com.plusmpm.util.Tools;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VTManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class exportValues
extends HttpServlet {
    public static Logger log = Logger.getLogger(exportValues.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream outputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WorkbookSettings wbs = null;
        WritableWorkbook w = null;
        JSONObject jsonExportData = null;
        JSONArray jsonRecords = null;
        try {
            String tableId = request.getParameter("tableId");
            String jsonExportDataString = request.getParameter("exportData");
            Table table = VTManager.getTable((String)tableId);
            String tableName = table.getName();
            if (Tools.isNullOrEmpty((String)tableName)) {
                tableName = new String(tableId);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            outputStream = response.getOutputStream();
            w = Workbook.createWorkbook((OutputStream)baos, (WorkbookSettings)wbs);
            WritableSheet sheet = w.createSheet(tableName, 0);
            WritableFont times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.WHITE);
            WritableCellFormat times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBackground(Colour.BLUE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            CellView cellView = new CellView();
            cellView.setAutosize(true);
            ArrayList columns = VColumn.getColumns((String)tableId);
            int yPos = 0;
            int xPos = 0;
            jsonExportData = new JSONObject(jsonExportDataString);
            jsonRecords = jsonExportData.getJSONArray("records");
            for (Column column : columns) {
                String columnId = column.getId();
                Label colLabel = new Label(xPos, yPos, columnId, (CellFormat)times12format);
                sheet.addCell((WritableCell)colLabel);
                sheet.setColumnView(xPos, cellView);
                ++xPos;
            }
            ++yPos;
            for (int i = 0; i < jsonRecords.length(); ++i) {
                xPos = 0;
                JSONObject oneRow = jsonRecords.getJSONObject(i);
                for (Column column : columns) {
                    String columnId = column.getId();
                    Object oVal = oneRow.get(columnId);
                    String val = "";
                    if (oVal != null) {
                        val = oVal.toString();
                        String columnType = column.getType().getName();
                        if (columnType.equalsIgnoreCase("data") && val.equalsIgnoreCase("null")) {
                            val = "";
                        }
                    }
                    Label valueLabel = new Label(xPos, yPos, val);
                    sheet.addCell((WritableCell)valueLabel);
                    sheet.setColumnView(xPos, cellView);
                    ++xPos;
                }
                ++yPos;
            }
            w.write();
            w.close();
            response.setContentType("application/ms-excel");
            response.setContentLength(baos.size());
            String filename = tableName + ".xls";
            response.setHeader("Content-Disposition", this.getContentDisposition(filename));
            byte[] bosArray = baos.toByteArray();
            for (int i = 0; i < baos.size(); ++i) {
                outputStream.write((int)bosArray[i]);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getContentDisposition(String filename) {
        String filenameEncoding = URIUtil.encodeAll((String)filename);
        StringBuilder contentDisposition = new StringBuilder();
        contentDisposition.append("attachment;");
        contentDisposition.append(" filename=");
        contentDisposition.append(filenameEncoding);
        contentDisposition.append("; filename*=UTF-8''");
        contentDisposition.append(filenameEncoding);
        return contentDisposition.toString();
    }
}

