/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.packages;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.plusmpm.database.DBManagement;
import com.plusmpm.i18n.I18N;
import com.plusmpm.servlet.packages.ProcessInfo;
import com.plusmpm.servlet.packages.filter.Filter;
import com.plusmpm.servlet.packages.filter.ListFilter;
import com.plusmpm.servlet.packages.filter.SimpleFilter;
import com.plusmpm.system.scheduler.tasks.internal.PackageTasks;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.plusmpm.util.scheduledTasks.AbstractTask;
import com.plusmpm.util.scheduledTasks.MemoryTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.xpdl.XpdlDifferences;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.xpdl.elements.Package;

public class PackageProcessesServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(PackageProcessesServlet.class);
    private static final long serialVersionUID = 1L;
    private ShaKey key = (ShaKey)SpringContext.getBean(ShaKey.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final int CHAR_LIMIT = 1000000;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long count;
        String packageId = request.getParameter("packageId");
        String packageVersion = request.getParameter("packageVersion");
        String start = request.getParameter("start");
        String limit = request.getParameter("limit");
        String sortDir = request.getParameter("dir");
        Object sortColumn = request.getParameter("sort");
        if (sortColumn != null) {
            sortColumn = "\"" + ((String)sortColumn).toLowerCase() + "\"";
        }
        String rawFilters = request.getParameter("filter");
        List<Filter> filters = this.getFilters(rawFilters);
        Package pack = SharkFunctions.getPackageManager().getPackage(packageId, packageVersion);
        if (pack == null) {
            response.setStatus(400);
            return;
        }
        List processes = null;
        if (start != null && limit != null) {
            processes = DBManagement.getCreatedProcessesForPackage((Package)pack, (Integer)Integer.valueOf(start), (Integer)Integer.valueOf(limit), (String)sortDir, (String)sortColumn, filters);
            count = DBManagement.getCreatedProcessesForPackageCount((Package)pack, filters);
        } else {
            processes = DBManagement.getCreatedProcessesForPackage((Package)pack, null, null, (String)sortDir, (String)sortColumn, filters);
            count = processes.size();
        }
        ArrayList<ProcessInfo> procInfos = new ArrayList<ProcessInfo>();
        for (Map row : processes) {
            String id = (String)row.get("id");
            String procDefId = (String)row.get("processdefinitionid");
            String name = (String)row.get("name");
            String state = (String)row.get("state");
            state = LanguageUtils.changeStateName((String)state, (boolean)true);
            String description = (String)row.get("description");
            Date created = new Date((Long)row.get("created"));
            Date started = new Date((Long)row.get("started"));
            Date laststatetime = new Date((Long)row.get("laststatetime"));
            ProcessInfo info = new ProcessInfo(id, procDefId, name, description, state, created, started, laststatetime);
            try {
                info.setKey(this.key.get(id));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            procInfos.add(info);
        }
        Gson gson = GsonFactory.getGson();
        Type collectionType = new TypeToken<List<ProcessInfo>>(){}.getType();
        String procInfoJson = gson.toJson(procInfos, collectionType);
        String returnJson = "{\"results\":" + count + ",\"processes\":" + procInfoJson + "}";
        response.getWriter().write(returnJson);
    }

    private List<Filter> getFilters(String rawFilters) {
        Gson gson = GsonFactory.getGson();
        ArrayList<Filter> result = new ArrayList<Filter>();
        JsonElement jsonFilters = (JsonElement)gson.fromJson(rawFilters, JsonElement.class);
        if (jsonFilters != null) {
            JsonArray filterItems = jsonFilters.getAsJsonArray();
            for (JsonElement element : filterItems) {
                JsonObject obj = element.getAsJsonObject();
                String field = obj.get("field").getAsString();
                String type = obj.get("type").getAsString();
                if (!"list".equals(type)) {
                    String value = obj.get("value").getAsString();
                    result.add((Filter)new SimpleFilter(field, value));
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                JsonArray jsonArray = obj.get("value").getAsJsonArray();
                for (JsonElement el : jsonArray) {
                    values.add(el.getAsString());
                }
                result.add((Filter)new ListFilter(field, values));
            }
        }
        return result;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String errors;
        I18N oMessage = new I18N(request);
        XpdlDifferences diff = new XpdlDifferences(oMessage);
        String action = request.getParameter("actionType");
        if (action == null) {
            log.info((Object)"Brak parametru actionType!!!");
            response.sendError(400);
        }
        HashMap<String, List<String>> processesMap = null;
        String packageId = request.getParameter("packageId");
        String packageVersion = request.getParameter("packageVersion");
        String processListJson = request.getParameter("processes");
        String rawFilters = request.getParameter("filter");
        List<Filter> filters = this.getFilters(rawFilters);
        if (processListJson != null) {
            Gson gson = GsonFactory.getGson();
            Type collectionType = new TypeToken<List<ProcessInfo>>(){}.getType();
            List processesToUpdate = (List)gson.fromJson(processListJson, collectionType);
            processesMap = new HashMap();
            Iterator iterator = processesToUpdate.iterator();
            while (iterator.hasNext()) {
                ProcessInfo proc = (ProcessInfo)iterator.next();
                ArrayList<String> ids = (ArrayList<String>)processesMap.get(proc.getProcDefId());
                if (ids == null) {
                    ids = new ArrayList<String>();
                    processesMap.put(proc.getProcDefId(), ids);
                }
                ids.add(proc.getId());
            }
        } else if (!filters.isEmpty()) {
            Package pack = SharkFunctions.getPackageManager().getPackage(packageId, packageVersion);
            if (pack == null) {
                response.setStatus(400);
                return;
            }
            processesMap = new HashMap<String, List<String>>();
            List processes = DBManagement.getCreatedProcessesForPackage((Package)pack, null, null, null, null, filters);
            for (Map process : processes) {
                String processDefId = (String)process.get("processdefinitionid");
                String processId = (String)process.get("id");
                ArrayList<String> processIds2 = (ArrayList<String>)processesMap.get(processDefId);
                if (processIds2 == null) {
                    processIds2 = new ArrayList<String>();
                    processesMap.put(processDefId, processIds2);
                }
                processIds2.add(processId);
            }
        }
        if (action.equalsIgnoreCase("newest")) {
            int newestVersion = Integer.parseInt(XpdlPackageManager.getInstance().getPackage(packageId).getInternalVersion());
            boolean forceUpdate = Boolean.parseBoolean(request.getParameter("force"));
            if (!forceUpdate && !StringUtils.isEmpty((String)(errors = diff.getAllXpdlDifferencesHtml(packageId, packageVersion, Integer.toString(newestVersion), 1000000)))) {
                response.getWriter().write(String.format("{\"success\":false, \"reason\":\"compatibility\",\"errors\":%s}", GsonFactory.getGson().toJson((Object)errors)));
                return;
            }
            response.getWriter().write(this.executeMemoryTask(processesMap, packageId, packageVersion, newestVersion));
            return;
        }
        if (action.equalsIgnoreCase("version")) {
            int version = Integer.parseInt(request.getParameter("version"));
            boolean forceUpdate = Boolean.parseBoolean(request.getParameter("force"));
            if (!forceUpdate && !StringUtils.isEmpty((String)(errors = diff.getAllXpdlDifferencesHtml(packageId, packageVersion, Integer.toString(version), 1000000)))) {
                response.getWriter().write(String.format("{\"success\":false, \"reason\":\"compatibility\",\"errors\":%s}", GsonFactory.getGson().toJson((Object)errors)));
                return;
            }
            response.getWriter().write(this.executeMemoryTask(processesMap, packageId, packageVersion, version));
            return;
        }
        if (action.equalsIgnoreCase("remove")) {
            if (processesMap == null) {
                log.info((Object)"Brak listy proces\u00f3w do usuni\u0119cia.");
                response.setStatus(400);
                return;
            }
            ArrayList audits = new ArrayList();
            List allProcesses = processesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            int count = allProcesses.size();
            String userName = SessionUtils.getLoggedUserName();
            String ip = StringUtils.defaultIfEmpty((String)request.getRemoteAddr(), (String)ManualAuditBuilder.UNKNOWN);
            log.info((Object)("Usuwanie zaznaczonych proces\u00f3w. \u0141\u0105cznie do usuni\u0119cia: " + count));
            Date started = new Date();
            try {
                processesMap.forEach((processDefinitionId, processIds) -> processIds.forEach(processId -> this.buildDeleteProcessAudit(audits, (String)processId, (String)processDefinitionId, request, userName, ip)));
                ServiceFactory.getProcessService().deleteProcesses(allProcesses);
                if (!audits.isEmpty()) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("amount", count);
                    params.put("operation_source", "administracja_pakiety");
                    ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESSES).success(true).started(started).username(userName).ipAddress(ip).params(params).build().log();
                    audits.forEach(audit -> audit.log());
                }
                response.getWriter().write("{success:true, total:" + count + " }");
                return;
            }
            catch (Exception e) {
                log.error((Object)("Nieoczekiwany b\u0142\u0105d w trakcie usuwanie proces\u00f3w dla pakietu:" + packageId + " wersja:" + packageVersion), (Throwable)e);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("amount", count);
                params.put("operation_source", "administracja_pakiety");
                ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESSES).success(false).started(started).username(userName).ipAddress(ip).params(params).build().log();
                response.getWriter().write("{success:false}");
                return;
            }
        }
        if (action.equalsIgnoreCase("check")) {
            String key = request.getParameter("task");
            if (StringUtils.isBlank((String)key)) {
                key = this.concatKey(packageId, packageVersion);
            }
            boolean success = false;
            AbstractTask task = ScheduledTasksManager.getInstance().getExecutor().getTask((Object)key);
            if (task == null) {
                response.getWriter().write("{\"success\":true}");
            } else if (task.awaitCompletion(25L, TimeUnit.SECONDS)) {
                success = task.getStatus().isSuccess();
                response.getWriter().write("{\"success\":" + success + "}");
            } else {
                response.getWriter().write("{\"success\":false, \"reason\":\"timeout\", \"key\":\"" + key + "\"}");
            }
            return;
        }
        log.info((Object)("Nieznana akcja: " + action));
        response.setStatus(400);
    }

    private String concatKey(String packageId, String packageVersion) {
        return "--update--" + packageId + "-VER-" + packageVersion;
    }

    private String executeMemoryTask(Map<String, List<String>> processes, String packageId, String packageVer, int targetVersion) {
        boolean success = false;
        String key = this.concatKey(packageId, packageVer);
        MemoryTask memoryTask = null;
        memoryTask = processes != null ? new MemoryTask(key, PackageTasks.class, "updateProcessesToVersion", new Class[]{Map.class, Integer.TYPE}, new Object[]{processes, targetVersion}) : new MemoryTask(key, PackageTasks.class, "updateAllProcessesToVersion", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{packageId, packageVer, targetVersion});
        boolean isPlacedInQueue = ScheduledTasksManager.getInstance().getExecutor().executeTask((AbstractTask)memoryTask);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (!isPlacedInQueue) {
            parameters.put("success", false);
            parameters.put("errors", "alreadyInitialized");
            parameters.put("key", key);
            return this.getAsJson(parameters);
        }
        if (memoryTask.awaitCompletion(25L, TimeUnit.SECONDS)) {
            success = memoryTask.getStatus().isSuccess();
            Object result = memoryTask.getStatus().getResult();
            parameters.put("success", success);
            String json = this.getAsJson(parameters);
            if (result instanceof Map) {
                Map e = (Map)result;
                parameters.put("failureIds", e);
                json = this.getAsJson(parameters);
            }
            return json;
        }
        parameters.put("success", false);
        parameters.put("reason", "timeout");
        parameters.put("key", key);
        return this.getAsJson(parameters);
    }

    private String getAsJson(Map<String, Object> jsonAsMap) {
        return objectMapper.writeValueAsString(jsonAsMap);
    }

    private void buildDeleteProcessAuditParams(Map<String, Object> params, String processId, String processDefinitionId, HttpServletRequest request) throws BaseException, NotConnected {
        WfProcess wfProcess = SharkUtils.getExecutionAdministration().getProcess(processId);
        String processName = wfProcess.name();
        String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefinitionId);
        params.put("processId", processId);
        params.put("package_name", packageId);
        params.put("process_name", processName);
        params.put("processDefId", processDefinitionId);
        params.put("operation_source", "administracja_pakiety");
        params.put("is_group_operation", "Tak");
    }

    private void buildDeleteProcessAudit(List<AuditWrapper> audits, String processId, String processDefinitionId, HttpServletRequest request, String userName, String ip) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            this.buildDeleteProcessAuditParams(params, processId, processDefinitionId, request);
        }
        catch (BaseException e) {
            log.error((Object)("B\u0142\u0105d podczas pobierania informacji o procesie: " + processId + "  " + e.getLocalizedMessage()));
        }
        catch (NotConnected e) {
            log.error((Object)("Brak po\u0142\u0105czenia " + e.getMessage()));
        }
        AuditWrapper audit = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS).success(true).started(new Date()).username(userName).ipAddress(ip).params(params).build();
        audits.add(audit);
    }
}

