/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.notifications;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plusmpm.database.notifications.Notification;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.plusmpm.util.notifications.Helpers;
import com.plusmpm.util.notifications.NotificationManager;
import com.plusmpm.util.notifications.NotificationReceiver;
import com.plusmpm.util.notifications.NotificationReceiverType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class NotificationManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = -6429870757312725609L;
    private static final Logger log = Logger.getLogger(NotificationManagerServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username;
        HttpSession session = req.getSession(false);
        if (session == null || (username = (String)session.getAttribute("username")) == null) {
            return;
        }
        String type = req.getParameter("type");
        resp.setContentType("application/json");
        PrintWriter printer = resp.getWriter();
        if (type.equals("latest")) {
            List notifications = NotificationManager.getInstance().getToasts(username);
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            String result = gson.toJson((Object)notifications);
            printer.write(result);
            return;
        }
        if (type.equals("list")) {
            int start = Integer.valueOf(req.getParameter("start"));
            int limit = Integer.valueOf(req.getParameter("limit"));
            List list = NotificationManager.getInstance().getNotifications(username, start, limit);
            int count = NotificationManager.getInstance().getCountAllNotifsForUser(username);
            HashMap<String, Object> totalResult = new HashMap<String, Object>();
            totalResult.put("totalCount", count);
            totalResult.put("records", list);
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            String result = gson.toJson(totalResult);
            printer.write(result);
            return;
        }
        if (type.equals("unconfirmed")) {
            HashMap<String, Comparable<Boolean>> totalResult = new HashMap<String, Comparable<Boolean>>();
            int count = NotificationManager.getInstance().getCountUnconfirmed(username);
            if (count > 0) {
                totalResult.put("failure", Boolean.valueOf(NotificationManager.getInstance().isUnconfirmedFailure(username)));
            }
            totalResult.put("count", Integer.valueOf(count));
            log.info((Object)("Unconfirmed: " + count));
            Gson gson = GsonFactory.getGson();
            String result = gson.toJson(totalResult);
            printer.write(result);
            return;
        }
        if (type.equals("confirm")) {
            int id = Integer.valueOf(req.getParameter("id"));
            NotificationManager.getInstance().confirm(id, username);
        } else if (type.equals("add")) {
            if (Helpers.isNotificationsEnabled()) {
                String messageJSON = req.getParameter("message");
                JsonParser parser = new JsonParser();
                JsonObject object = (JsonObject)parser.parse(messageJSON);
                Notification notification = new Notification();
                notification.setMessage(object.get("message").getAsString());
                if (object.has("sender")) {
                    notification.setSender(object.get("sender").getAsString());
                } else {
                    notification.setSender(username);
                }
                if (object.has("failure")) {
                    notification.setFailure(Boolean.valueOf(object.get("failure").getAsBoolean()));
                }
                String receiverName = null;
                if (object.has("receiverName")) {
                    receiverName = object.get("receiverName").getAsString();
                }
                NotificationReceiverType notifType = NotificationReceiverType.getForString((String)object.get("receiverType").getAsString());
                NotificationReceiver receiver = new NotificationReceiver(notifType, receiverName);
                NotificationManager.add((Notification)notification, (NotificationReceiver)receiver);
            }
            return;
        }
    }
}

