/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.database.variableSet.VariableSetManager;
import com.plusmpm.i18n.I18N;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.form.dynamictable.DynamicTableManager;
import com.plusmpm.util.json.extjs.CustomUtils;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import com.plusmpm.util.workflowData.ActivityData;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class VariableSetOperationsServlet
extends HttpServlet {
    private static final long serialVersionUID = 5168859250645549575L;
    public static final Logger log = Logger.getLogger(VariableSetOperationsServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.trace((Object)"****************************** VariableSetOperationsServlet.doGet ******************************");
        super.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.trace((Object)"****************************** VariableSetOperationsServlet.doPost ******************************");
        try (PrintWriter printWriter = null;){
            GsonCustomUtils gsonCustomUtils;
            I18N i18n = new I18N(req);
            I18Nxpdl xpdl = new I18Nxpdl(req);
            Map mParameters = req.getParameterMap();
            String sXaction = req.getParameter("xaction");
            String sRoot = req.getParameter("records");
            String sProcessId = req.getParameter("processId");
            String sActivityId = req.getParameter("activityId");
            String sSetId = req.getParameter("setId");
            String[] sWorkflowVariables = (String[])mParameters.get("workflowVariables");
            JsonStore jsonStore = new JsonStore();
            try {
                if (sXaction.compareTo("read") == 0) {
                    String sNoMetaChange = req.getParameter("bNoMetaChange");
                    boolean bNoMetaChange = Boolean.parseBoolean(sNoMetaChange);
                    if (!bNoMetaChange) {
                        Boolean isLocal = Boolean.valueOf(Shark.getInstance().getProperties().getProperty("DT_LOCAL", "false"));
                        jsonStore = JsonStore.getInstance((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables, (int)0, (I18Nxpdl)xpdl, (boolean)isLocal);
                        VariableSetManager.deleteVariableSetValues((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables);
                    }
                    Map mColumns = ActivityData.getVariableSetValues((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables);
                    DynamicTableManager dynamicTableManager = new DynamicTableManager(mColumns, req);
                    List lRecords = dynamicTableManager.getColumnsAsRecords();
                    jsonStore.setRecords(lRecords);
                    jsonStore.setTotal(Integer.valueOf(lRecords.size()));
                    jsonStore.setSuccess(Boolean.valueOf(true));
                    jsonStore.setMessage(i18n.getString("Dane_tabelki_odczytano_prawidlowo") + ".");
                } else if (sXaction.compareTo("create") == 0) {
                    gsonCustomUtils = new GsonCustomUtils();
                    List lmNewRecords = gsonCustomUtils.getMapDataForExtJsonStore(sRoot);
                    WorkflowProcess workflowProcess = SharkFunctions.getWorkflowProcessById((String)sProcessId);
                    Map mColumns = ActivityData.getVariableSetValues((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables);
                    CustomUtils customUtils = new CustomUtils();
                    for (Map mNewRecord : lmNewRecords) {
                        customUtils.convertDatesFromJSONToSystem(workflowProcess, mNewRecord);
                        customUtils.convertAmountsFromJSONToSystem(workflowProcess, mNewRecord);
                    }
                    DynamicTableManager dynamicTableManager = new DynamicTableManager(mColumns, req);
                    Collections.reverse(lmNewRecords);
                    List lmAddedRecords = dynamicTableManager.addRecords(lmNewRecords);
                    VariableSetManager.changeVariableSetValues((String)sProcessId, (String)sActivityId, (Map)dynamicTableManager.getLastModifiedColumnsAsActivityContext());
                    Collections.reverse(lmAddedRecords);
                    jsonStore.setRecords(lmAddedRecords);
                    jsonStore.setSuccess(Boolean.valueOf(true));
                    jsonStore.setMessage(i18n.getString("Prawidlowo_dodano_wiersz_tabelki") + ".");
                } else if (sXaction.compareTo("update") == 0) {
                    gsonCustomUtils = new GsonCustomUtils();
                    List lmRecords = gsonCustomUtils.getMapDataForExtJsonStore(sRoot);
                    WorkflowProcess workflowProcess = SharkFunctions.getWorkflowProcessById((String)sProcessId);
                    Map mColumns = ActivityData.getVariableSetValues((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables);
                    CustomUtils customUtils = new CustomUtils();
                    for (Map mRecord : lmRecords) {
                        customUtils.convertDatesFromJSONToSystem(workflowProcess, mRecord);
                        customUtils.convertAmountsFromJSONToSystem(workflowProcess, mRecord);
                    }
                    DynamicTableManager dynamicTableManager = new DynamicTableManager(mColumns, req);
                    List lmModifiedRecords = dynamicTableManager.modifyRecords(lmRecords);
                    VariableSetManager.changeVariableSetValues((String)sProcessId, (String)sActivityId, (Map)dynamicTableManager.getLastModifiedColumnsAsActivityContext());
                    jsonStore.setRecords(lmModifiedRecords);
                    jsonStore.setSuccess(Boolean.valueOf(true));
                    jsonStore.setMessage(i18n.getString("Prawidlowo_zmieniono_wiersz_tabelki") + ".");
                } else if (sXaction.compareTo("destroy") == 0) {
                    gsonCustomUtils = new GsonCustomUtils();
                    List lRowNumbers = gsonCustomUtils.getArrayIntegerData(sRoot);
                    HashSet setRowNumbers = new HashSet(lRowNumbers);
                    Map mColumns = ActivityData.getVariableSetValues((String)sProcessId, (String)sActivityId, (String[])sWorkflowVariables);
                    DynamicTableManager dynamicTableManager = new DynamicTableManager(mColumns, req);
                    dynamicTableManager.removeRecords(setRowNumbers);
                    VariableSetManager.changeVariableSetValues((String)sProcessId, (String)sActivityId, (Map)dynamicTableManager.getLastModifiedColumnsAsActivityContext());
                    jsonStore.setRecords(new ArrayList(0));
                    jsonStore.setSuccess(Boolean.valueOf(true));
                    jsonStore.setMessage(i18n.getString("Prawidlowo_usunieto_wiersz_tabelki") + ".");
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                jsonStore.setRecords(new ArrayList(1));
                jsonStore.getRecords().add(new HashMap(1));
                jsonStore.setSuccess(Boolean.valueOf(false));
                jsonStore.setMessage(e.getClass().getName() + ": " + e.getMessage());
            }
            gsonCustomUtils = new GsonCustomUtils();
            String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            printWriter = resp.getWriter();
            printWriter.print(sJsonData);
        }
    }
}

