/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.classLoader.PlusClassLoader;
import com.plusmpm.util.dcValidator.CacheValidator.DataChooserCache;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.Field;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import com.plusmpm.util.json.extjs.objects.MetaData;
import com.plusmpm.util.json.extjs.objects.SortInfo;
import com.plusmpm.util.json.extjs.types.FieldType;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserEvaluator;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.declaration.DataChooserReader;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import com.suncode.pwfl.workflow.variable.type.ExtAttrUtils;
import com.suncode.pwfl.xpdl.PackageCacheService;
import com.suncode.pwfl.xpdl.exception.PackageCacheExpiredException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;

public class GetDataChooserContentServlet
extends HttpServlet {
    public static Logger log = Logger.getLogger(GetDataChooserContentServlet.class);
    private static final long serialVersionUID = 7888655918110954625L;
    public static final String S_QUERY_CRITERIA_KEY = "GetDataChooserContentServlet_parameter_query";
    public static final String ROW_INDEX_IN_TABLE = "rowIndexInTable";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> contextRef = new TypeReference<Map<String, String>>(){};
    private final VariableFactory variableFactory = (VariableFactory)SpringContext.getBean(VariableFactory.class);
    private final ActivityService activityService = (ActivityService)SpringContext.getBean(ActivityService.class);
    private final DataChooserEvaluator evaluator = (DataChooserEvaluator)SpringContext.getBean(DataChooserEvaluator.class);
    private final DataChooserReader dataChooserReader = (DataChooserReader)SpringContext.getBean(DataChooserReader.class);
    private final PackageCacheService packageCacheService = (PackageCacheService)SpringContext.getBean(PackageCacheService.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info((Object)"****************************** GetDataChooserContentServlet.doPost ********************");
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GetDataChooserContentServlet.log.info((Object)"****************************** GetDataChooserContentServlet.doGet ********************");
        printWriter = null;
        try {
            mParameters = request.getParameterMap();
            sDataChooserId = ((String[])mParameters.get("sDataChooserId"))[0];
            sActivityId = ((String[])mParameters.get("sActivityId"))[0];
            rowIndex = request.getParameter("rowIndexInTable");
            sChooserElementIds = (String[])mParameters.get("sChooserElementIds");
            pagination = this.readPagination(mParameters, sChooserElementIds[0]);
            sQueryTab = (String[])mParameters.get("query");
            query = null;
            if (sQueryTab != null && sQueryTab.length > 0) {
                query = sQueryTab[0];
            }
            filters = this.readFilters(mParameters);
            isPreview = Boolean.parseBoolean(request.getParameter("isPreview"));
            componentId = request.getParameter("componentId");
            if (StringUtils.isNotBlank((CharSequence)componentId)) {
                sProcessId = ((String[])mParameters.get("sProcessId"))[0];
                extAttrs = null;
                if (isPreview.booleanValue()) {
                    uuidString = request.getParameter("packageUuid");
                    processDefId = request.getParameter("processDefId");
                    sProcessId = StringUtils.isBlank((CharSequence)sProcessId) != false ? uuidString : sProcessId;
                    sActivityId = StringUtils.isBlank((CharSequence)sActivityId) != false ? uuidString : sActivityId;
                    extAttrs = this.getCachedExtendedAttributes(sDataChooserId, uuidString, processDefId);
                    if (extAttrs == null) {
                        GetDataChooserContentServlet.log.error((Object)"Form's datachooser expired");
                        throw new PackageCacheExpiredException(UUID.fromString(uuidString), processDefId);
                    }
                } else {
                    extAttrs = SharkFunctions.getWorkflowProcessById((String)sProcessId).getDataField(sDataChooserId).getExtendedAttributes();
                }
                definitionJson = ExtAttrUtils.getExtAttrValue((ExtendedAttributes)extAttrs, (String)"DATA_CHOOSER_DEFINITION");
                declaration = this.dataChooserReader.readDataChooser(definitionJson);
                if (StringUtils.isNotBlank((CharSequence)rowIndex)) {
                    declaration.fromVariableSet(Integer.valueOf(rowIndex));
                }
                dcResult = new DataChooserResult(pagination);
                DataChooserContext.activate((String)sProcessId, (String)sActivityId, (ComponentQueryData)new ComponentQueryData(pagination, query, filters), (DataChooserResult)dcResult, declaration.getMappings().values());
                try {
                    contextMap = this.contextMap(request);
                    this.evaluator.call(declaration, this.contextMap(request));
                    records = dcResult.getData();
                    nTotal = dcResult.getTotal();
                    if (isPreview.booleanValue()) ** GOTO lbl86
                    DataChooserCache.get().put(sDataChooserId, declaration, contextMap, records);
                }
                finally {
                    DataChooserContext.deactivate();
                }
            } else {
                sCriteriaReal_Ids = (String[])mParameters.get("sCriteriaReal_Ids");
                sCriteriaReal_Values = (String[])mParameters.get("sCriteriaReal_Values");
                sCustomKeys_Keys = (String[])mParameters.get("sCustomKeys_Keys");
                sCustomKeys_Values = (String[])mParameters.get("sCustomKeys_Values");
                mCriteria = new HashMap<String, String>();
                mCriteria.put("rowIndexInTable", rowIndex != null ? rowIndex : "");
                if (query != null) {
                    mCriteria.put("GetDataChooserContentServlet_parameter_query", query);
                }
                if (sCriteriaReal_Ids != null && sCriteriaReal_Values != null && sCriteriaReal_Ids.length == sCriteriaReal_Values.length) {
                    for (i = 0; i < sCriteriaReal_Ids.length; ++i) {
                        sId = sCriteriaReal_Ids[i];
                        sValue = sCriteriaReal_Values[i];
                        mCriteria.put(sId, sValue);
                    }
                }
                mCriteria.putAll(filters);
                mCustomKeys = new HashMap<String, String>();
                if (sCustomKeys_Keys != null && sCustomKeys_Values != null && sCustomKeys_Keys.length == sCustomKeys_Values.length) {
                    for (i = 0; i < sCustomKeys_Keys.length; ++i) {
                        sKey = sCustomKeys_Keys[i];
                        sValue = sCustomKeys_Values[i];
                        mCustomKeys.put(sKey, URLDecoder.decode(sValue, "UTF8"));
                    }
                }
                oMethodArgs = new Object[]{pagination.getStart(), pagination.getLimit(), pagination.getSorter().getProperty(), pagination.getSorter().getDirection().name(), Maps.newHashMap(mCriteria), Maps.newHashMap(mCustomKeys)};
                cMethodArgs = new Class[]{Integer.TYPE, Integer.TYPE, String.class, String.class, Map.class, Map.class};
                sClassFullName = ((String[])mParameters.get("sClassFullName"))[0];
                plusClassLoader = new PlusClassLoader();
                records = (List)plusClassLoader.executeClassMethod(sClassFullName, "getDataChooserResult", oMethodArgs, cMethodArgs);
                if (!isPreview.booleanValue()) {
                    DataChooserCache.get().put(sDataChooserId, sActivityId, mCriteria, mCustomKeys, records);
                }
                oMethodArgs = new Object[]{mCriteria, mCustomKeys};
                cMethodArgs = new Class[]{Map.class, Map.class};
                nTotal = (Integer)plusClassLoader.executeClassMethod(sClassFullName, "getDataChooserResultSize", oMethodArgs, cMethodArgs);
            }
lbl86:
            // 3 sources

            fields = new Field[sChooserElementIds.length];
            for (j = 0; j < sChooserElementIds.length; ++j) {
                fields[j] = new Field(sChooserElementIds[j], FieldType.STRING, null, null, null, null);
            }
            sortInfo = new SortInfo(pagination.getSorter().getProperty(), pagination.getSorter().getDirection().name());
            metaData = new MetaData(sortInfo, fields, "__internal_id");
            jsonStore = new JsonStore();
            jsonStore.setTotal(Integer.valueOf(nTotal));
            jsonStore.setMetaData(metaData);
            jsonStore.setRecords(records);
            gsonCustomUtils = new GsonCustomUtils();
            sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            printWriter = response.getWriter();
            printWriter.print(sJsonData);
        }
        catch (Exception e) {
            GetDataChooserContentServlet.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private ExtendedAttributes getCachedExtendedAttributes(String sDataChooserId, String uuidString, String processDefId) {
        UUID uuid = UUID.fromString(uuidString);
        Package pack = this.packageCacheService.get(uuid);
        if (pack != null) {
            DataField dataField = pack.getWorkflowProcess(processDefId).getDataField(sDataChooserId);
            return dataField.getExtendedAttributes();
        }
        return null;
    }

    private Pagination readPagination(Map<String, String[]> requestParameters, String defaultOrderProperty) {
        String sStart = requestParameters.get("start")[0];
        String sLimit = requestParameters.get("limit")[0];
        String[] sOrderPropertyTab = requestParameters.get("sort");
        String sOrderProperty = null;
        sOrderProperty = sOrderPropertyTab != null && sOrderPropertyTab.length > 0 ? sOrderPropertyTab[0] : defaultOrderProperty;
        String[] sOrderTab = requestParameters.get("dir");
        String sOrder = null;
        sOrder = sOrderTab != null && sOrderTab.length > 0 ? sOrderTab[0] : "ASC";
        return Pagination.create((Sorter)new Sorter(sOrderProperty, SortDirection.valueOf((String)sOrder)), (Integer)Integer.parseInt(sStart), (Integer)Integer.parseInt(sLimit));
    }

    private Map<String, String> readFilters(Map<String, String[]> parameters) {
        HashMap filters = Maps.newHashMap();
        for (String sKey : parameters.keySet()) {
            if (!sKey.startsWith("filter[")) continue;
            String sFilter = sKey.substring(0, sKey.indexOf("]") + 1);
            String[] sFilterField = parameters.get(sFilter.concat("[field]"));
            String[] sFilterDataValue = parameters.get(sFilter.concat("[data][value]"));
            filters.put(sFilterField[0], sFilterDataValue[0]);
        }
        return filters;
    }

    private ActivityContextMap contextMap(HttpServletRequest request) throws Exception {
        Boolean isPreview = Boolean.parseBoolean(request.getParameter("isPreview"));
        DataChooserContext dataChooserContext = DataChooserContext.current();
        String processId = dataChooserContext.getProcessId();
        String activityId = dataChooserContext.getActivityId();
        Map variables = null;
        if (isPreview.booleanValue()) {
            UUID uuid = UUID.fromString(request.getParameter("packageUuid"));
            String processDefId = request.getParameter("processDefId");
            String activityDefId = request.getParameter("activityDefId");
            Package pack = this.packageCacheService.get(uuid);
            variables = this.variableFactory.createImmutableVariables(pack, processDefId, activityDefId, this.readContext(request, processId, activityId), false);
        } else {
            variables = this.variableFactory.createImmutableVariables(processId, activityId, this.readContext(request, processId, activityId), false);
        }
        return new ActivityContextMap(processId, activityId, variables);
    }

    private Map<String, Object> readContext(HttpServletRequest request, String processId, String activityId) throws Exception {
        Boolean isPreview = Boolean.parseBoolean(request.getParameter("isPreview"));
        HashMap context = Maps.newHashMap();
        String contextJson = request.getParameter("context");
        Map formContext = (Map)mapper.readValue(contextJson, contextRef);
        if (isPreview.booleanValue()) {
            context.putAll(formContext);
        } else {
            Map activityContext = this.activityService.getActivityContext(processId, activityId);
            for (String id : activityContext.keySet()) {
                Object value = activityContext.get(id);
                Object sValue = formContext.get(id);
                if (sValue == null && value != null & value instanceof Date) {
                    LocalDateTime date = new LocalDateTime(value);
                    sValue = date.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                }
                context.put(id, sValue == null ? value : sValue);
            }
        }
        return context;
    }
}

