/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.dcValidator.DataChooserToValidate;
import com.plusmpm.util.dcValidator.DataChooserValidator;
import com.plusmpm.util.dcValidator.DcValidationError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;

public class DataChooserValidatorServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(DataChooserValidatorServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object message = "";
        boolean check = false;
        I18N oMessage = new I18N(req);
        JsonParser parser = new JsonParser();
        try {
            DataChooserToValidate dataChooserToValidate;
            JsonElement jo;
            String variables = req.getParameter("variables");
            JsonElement obj = parser.parse(variables);
            JsonArray jsArray = (JsonArray)obj;
            ArrayList<DataChooserToValidate> DCs = new ArrayList<DataChooserToValidate>();
            JsonArray singleDCs = new JsonArray();
            if (jsArray.get(0) != null) {
                jo = jsArray.get(0);
                if (!jo.isJsonNull()) {
                    singleDCs = (JsonArray)jo;
                }
                for (JsonElement DC : singleDCs) {
                    dataChooserToValidate = new DataChooserToValidate((JsonObject)DC);
                    DCs.add(dataChooserToValidate);
                }
            }
            if (jsArray.get(1) != null) {
                jo = jsArray.get(1);
                if (!jo.isJsonNull()) {
                    singleDCs = (JsonArray)jo;
                }
                for (JsonElement DC : singleDCs) {
                    dataChooserToValidate = new DataChooserToValidate((JsonObject)DC);
                    DCs.add(dataChooserToValidate);
                }
            }
            DataChooserValidator dcval = null;
            check = true;
            String procDefId = null;
            for (DataChooserToValidate dc : DCs) {
                if (procDefId == null) {
                    procDefId = SharkFunctions.getProcessDefId((String)dc.getProcessId());
                }
                if (dcval == null) {
                    Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(procDefId);
                    dcval = new DataChooserValidator(dc.getProcessId(), dc.getActivityId(), pack.getDataFields());
                }
                log.info((Object)("Waliduje DC o nazwie: " + dc.getName()));
                check = dcval.validateDataChooser(dc);
                if (check) continue;
                DcValidationError error = dcval.getValidationError();
                if (error != null) {
                    message = dc.isVariableSetDC() ? error.getVariableSetMessage(procDefId, dc.getVariableSetTitle(), dc.getRowNr()) : error.getMessage(procDefId);
                }
                break;
            }
        }
        catch (Exception e) {
            check = false;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = oMessage.getString("Lista_rozwijana") + " " + oMessage.getString("posiada_nieprawidlowa_wartosc") + "!";
        }
        PrintWriter pw = resp.getWriter();
        if (check) {
            pw.print("_OK_");
        } else {
            pw.print((String)message);
        }
    }
}

