/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.services;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.ldap.LDAPManager;
import com.plusmpm.services.IReleaseService;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.DocumentUpload;
import com.plusmpm.util.locale.ProcessLocale;
import com.suncode.PlusWorkflowSecrets;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.NDC;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.NotEnabled;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Condition;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReleaseServiceImpl
implements IReleaseService {
    public static final Logger log = LoggerFactory.getLogger(ReleaseServiceImpl.class);
    private final String DEFAULT_PWFL_DOMAIN = "plusworkflow";

    @Override
    public boolean LoginInSystem(String userName, String password) {
        boolean validateSuccess;
        Boolean isCaseSensitive = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CASE_SENSITIVE_LOGIN);
        if (userName != null && !isCaseSensitive.booleanValue()) {
            userName = userName.toLowerCase();
        }
        if ((validateSuccess = Shark.getInstance().validateUser(userName, password)) && this.isUserActive(userName)) {
            log.info("Autoryzacja u\u017cytkownika: " + userName + " powiod\u0142a si\u0119.");
        } else {
            validateSuccess = false;
            log.warn("Autoryzacja u\u017cytkownika: " + userName + " nie powiod\u0142a si\u0119.");
        }
        return validateSuccess;
    }

    private boolean isUserActive(String fullUserName) {
        return ServiceFactory.getUserService().isActive(fullUserName);
    }

    private boolean isUserActive(String domain, String userName) {
        if (domain.compareTo("plusworkflow") == 0) {
            return this.isUserActive(userName);
        }
        return this.isUserActive(domain + "/" + userName);
    }

    @Override
    public boolean LoginInSystemWithDomain(String userName, String password, String domain) {
        Boolean isCaseSensitive = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.CASE_SENSITIVE_LOGIN);
        if (userName != null && !isCaseSensitive.booleanValue()) {
            userName = userName.toLowerCase();
        }
        boolean validateSuccess = false;
        if (domain == null || domain.compareToIgnoreCase("Plus Workflow") == 0 || domain.compareToIgnoreCase("") == 0) {
            domain = "plusworkflow";
        }
        if (domain.compareTo("plusworkflow") == 0) {
            validateSuccess = Shark.getInstance().validateUser(userName, password);
        } else {
            DBManagement dbm = new DBManagement();
            LDAPManager ldap = new LDAPManager();
            DomainTable domainObj = dbm.getDomainByName(domain);
            validateSuccess = ldap.AuthorizeUserInDomain(userName, password, domainObj.getId().toString());
        }
        if (validateSuccess && this.isUserActive(domain, userName)) {
            log.info("Autoryzacja u\u017cytkownika: " + userName + " w domenie: " + domain + " powiod\u0142a si\u0119.");
        } else {
            validateSuccess = false;
            log.warn("Autoryzacja u\u017cytkownika: " + userName + " w domenie: " + domain + " nie powiod\u0142a si\u0119.");
        }
        return validateSuccess;
    }

    @Override
    public String[] GetAllDomains() {
        log.info("GetAllDomains:");
        DBManagement dbm = new DBManagement();
        ArrayList alDomains = dbm.GetAllDomains();
        HashMap<String, String> hmDomain = new HashMap<String, String>();
        ArrayList<DomainTable> alNewDomain = new ArrayList<DomainTable>();
        for (int i = 0; i < alDomains.size(); ++i) {
            DomainTable domain = (DomainTable)alDomains.get(i);
            if (hmDomain.containsKey(domain.getDomainName())) continue;
            alNewDomain.add(domain);
            hmDomain.put(domain.getDomainName(), "true");
        }
        Object[] objDomains = hmDomain.keySet().toArray();
        String[] asDomains = new String[objDomains.length];
        for (int i = 0; i < objDomains.length; ++i) {
            asDomains[i] = (String)objDomains[i];
        }
        return asDomains;
    }

    @Override
    public String[] GetArchiveDocClass(String userName) {
        log.info("GetArchiveDocClass:" + userName);
        List documentClasses = ServiceFactory.getDocumentClassService().getDocumentClassesForUser(userName, false);
        return (String[])documentClasses.stream().map(documentClass -> documentClass.getId() + ";" + documentClass.getName()).toArray(String[]::new);
    }

    @Override
    public String[] GetArchiveDocClassIndecies(String userName, String docClassId) {
        Date dt = new Date();
        NDC.push((String)("GetArchiveDocClassIndecies_" + dt.toLocaleString()));
        log.info("GetArchiveDocClassIndecies:" + userName + ":" + docClassId);
        ArrayList alArchiveDocClassIndecies = null;
        String[] docClassesIndecies = null;
        DBManagement dbm = new DBManagement();
        alArchiveDocClassIndecies = DBManagement.GetAllIndecies((String)docClassId);
        if (alArchiveDocClassIndecies != null) {
            docClassesIndecies = new String[alArchiveDocClassIndecies.size()];
            for (int i = 0; i < alArchiveDocClassIndecies.size(); ++i) {
                IndexTable indexTable = (IndexTable)alArchiveDocClassIndecies.get(i);
                docClassesIndecies[i] = indexTable.getId() + ";" + indexTable.getIndexName();
            }
        }
        if (docClassesIndecies != null) {
            log.info("docClassesIndecies:" + docClassesIndecies + ":" + docClassesIndecies.length);
        } else {
            log.info("docClassesIndecies null");
        }
        log.info("GetArchiveDocClassIndecies OK");
        NDC.pop();
        NDC.remove();
        return docClassesIndecies;
    }

    @Override
    public int SaveIndeciesInArchive(String userName, String docClassId, String fileId, String[] asIndicies) {
        return this.SaveIndeciesInArchive(userName, docClassId, fileId, asIndicies, true);
    }

    @Override
    public int SaveIndeciesInArchiveVersion(String userName, String docClassId, String fileId, String[] asIndicies, String sNewVersionIfPossible) {
        return this.SaveIndeciesInArchive(userName, docClassId, fileId, asIndicies, Boolean.valueOf(sNewVersionIfPossible));
    }

    @Override
    public int SaveIndeciesInArchive(String userName, String docClassId, String fileId, String[] asIndicies, boolean asNewVersionIfPossible) {
        HashMap<Long, Object> documentFormIdxs = new HashMap<Long, Object>();
        log.info("SaveIndeciesInArchive");
        try {
            log.info("Saving indecies for file [{}] in document class [{}] with new version parameter as [{}].", new Object[]{fileId, docClassId, asNewVersionIfPossible});
            if (asIndicies != null) {
                for (int i = 0; i < asIndicies.length; ++i) {
                    String sIndex = asIndicies[i];
                    String[] sSet = sIndex.split(";");
                    String sIndexId = sSet[0];
                    String sIndexValue = "";
                    if (sIndex.contains(";")) {
                        sIndexValue = sIndex.substring(sIndex.indexOf(";") + 1);
                    }
                    documentFormIdxs.put(Long.valueOf(sIndexId), sIndexValue);
                }
            }
            log.info("Indecies - {}", (Object)this.getIndeciesInfo(documentFormIdxs));
            FileService fs = ServiceFactory.getFileService();
            Long fId = Long.valueOf(fileId);
            boolean savedAsNewVersion = fs.changeFileIndexesWithResult(fId, documentFormIdxs, asNewVersionIfPossible);
            DocumentService ds = ServiceFactory.getDocumentService();
            WfDocument doc = ds.getDocument(fId);
            DocumentClass dc = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)doc.getDocumentClassId());
            DocumentUpload.setFullIndexSearch((long)fId, (long)doc.getId(), (DocumentClass)dc);
            try {
                ServiceFactory.getDocumentClassActionService().executeArchiveActions(doc, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, Boolean.valueOf(savedAsNewVersion));
            }
            catch (ServiceException e) {
                ServiceFactory.getDocumentService().deleteDocument(doc);
                throw e;
            }
            log.info("Indecies for file [{}] was saved.", (Object)fileId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return -1;
        }
        return 0;
    }

    private String getIndeciesInfo(Map<Long, Object> documentFormIdxs) {
        ArrayList indexes = new ArrayList();
        documentFormIdxs.forEach((key, value) -> indexes.add(key + ": " + value));
        return StringUtils.collectionToDelimitedString(indexes, (String)" | ");
    }

    @Override
    public int SaveIndeciesInArchiveOCR(String userName, String docClassId, String fileId, String[] asIndicies, String sOCRContent) {
        return this.SaveIndeciesInArchiveOCRVersion(userName, docClassId, fileId, asIndicies, sOCRContent, false);
    }

    @Override
    public int SaveIndeciesInArchiveOCRVersion(String userName, String docClassId, String fileId, String[] asIndicies, String sOCRContent, boolean asNewVersionIfPossible) {
        HashMap<Long, Object> documentFormIdxs = new HashMap<Long, Object>();
        log.info("SaveIndeciesInArchiveOCR");
        try {
            log.info("Saving indecies for file [{}] in document class [{}] with new version parameter as [{}].", new Object[]{fileId, docClassId, asNewVersionIfPossible});
            if (asIndicies != null) {
                for (int i = 0; i < asIndicies.length; ++i) {
                    String sIndex = asIndicies[i];
                    String[] sSet = sIndex.split(";");
                    String sIndexId = sSet[0];
                    String sIndexValue = "";
                    if (sIndex.contains(";")) {
                        sIndexValue = sIndex.substring(sIndex.indexOf(";") + 1);
                    }
                    documentFormIdxs.put(Long.valueOf(sIndexId), sIndexValue);
                }
            }
            log.info("Indecies - {}", (Object)this.getIndeciesInfo(documentFormIdxs));
            FileService fs = ServiceFactory.getFileService();
            Long fId = Long.valueOf(fileId);
            boolean savedAsNewVersion = fs.changeFileIndexesWithResult(fId, documentFormIdxs, asNewVersionIfPossible);
            DocumentService ds = ServiceFactory.getDocumentService();
            WfDocument doc = ds.getDocument(fId);
            DocumentClass dc = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)doc.getDocumentClassId());
            DocumentUpload.setFullIndexSearchWithOCR((long)fId, (long)doc.getId(), (DocumentClass)dc, (String)sOCRContent, documentFormIdxs);
            try {
                ServiceFactory.getDocumentClassActionService().executeArchiveActions(doc, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, Boolean.valueOf(savedAsNewVersion));
            }
            catch (ServiceException e) {
                ServiceFactory.getDocumentService().deleteDocument(doc);
                throw e;
            }
            log.info("Indecies for file [{}] was saved.", (Object)fileId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return -1;
        }
        return 0;
    }

    @Override
    public int SaveDocumentInArchive(String userName, String docClassId, String sFilePath, String sSize, String sPageCount, String sDescription, String sOCRContent, byte[] abFile) {
        Long lFileId = new Long(-1L);
        log.info("SaveDocumentInArchive");
        try {
            String sFileName = sFilePath.substring(Math.max(sFilePath.lastIndexOf(47), sFilePath.lastIndexOf(92)) + 1);
            log.info("Saving file [{}] with size [{} KB] in document class [{}]", new Object[]{sFileName, abFile.length / 1024, docClassId});
            ByteArrayInputStream is = new ByteArrayInputStream(abFile);
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            FileSaver saver = fs.getFileSaver();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(new Long(docClassId));
            fd.setFileName(sFileName);
            fd.setDescription(sDescription);
            fd.setUserName(userName);
            fd.setInputStream((InputStream)is);
            lFileId = saver.addFile(fd).getId();
            log.info("File was saved with id [{}]", (Object)lFileId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lFileId.intValue();
    }

    @Override
    public int SaveDocumentInArchiveShort(String userName, String docClassId, String sFilePath, String sSize, String sPageCount, String sDescription, String sOCRContent, short[] abFile) {
        int iFileId = -1;
        log.info("SaveDocumentInArchiveShort");
        try {
            byte[] bytes = new byte[abFile.length];
            for (int i = 0; i < abFile.length; ++i) {
                bytes[i] = (byte)abFile[i];
            }
            iFileId = this.SaveDocumentInArchive(userName, docClassId, sFilePath, sSize, sPageCount, sDescription, sOCRContent, bytes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return iFileId;
    }

    @Override
    public int SaveDocumentInArchiveBase64(String userName, String docClassId, String sFilePath, String sSize, String sPageCount, String sDescription, String sOCRContent, String base64File) {
        int iFileId = -1;
        log.info("SaveDocumentInArchiveBase64");
        try {
            byte[] bytes = Base64.getDecoder().decode(base64File.getBytes(StandardCharsets.UTF_8));
            iFileId = this.SaveDocumentInArchive(userName, docClassId, sFilePath, sSize, sPageCount, sDescription, sOCRContent, bytes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return iFileId;
    }

    @Override
    public int SaveDocumentInArchiveBase64Part(String sFileId, String base64File) {
        log.info("SaveDocumentInArchiveBase64Part");
        byte[] bytes = Base64.getDecoder().decode(base64File.getBytes(StandardCharsets.UTF_8));
        return this.SaveDocumentInArchivePart(sFileId, bytes);
    }

    @Override
    public int SaveDocumentInArchiveShortPart(String sFileId, short[] abFile) {
        log.info("SaveDocumentInArchiveShortPart");
        byte[] bytes = new byte[abFile.length];
        for (int i = 0; i < abFile.length; ++i) {
            bytes[i] = (byte)abFile[i];
        }
        return this.SaveDocumentInArchivePart(sFileId, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int SaveDocumentInArchivePart(String sFileId, byte[] abFile) {
        ByteArrayInputStream is = null;
        InputStream fis = null;
        FileOutputStream fos = null;
        File tempFile = null;
        try {
            log.info("Saving next parts of file [{}] with size [{} KB]", (Object)sFileId, (Object)(abFile.length / 1024));
            is = new ByteArrayInputStream(abFile);
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            WfFile wfFile = fs.getFile(Long.valueOf(sFileId), new String[]{"documentClass"});
            File file = new File(wfFile.getFullPath());
            fis = new FileInputStream(file);
            fis = ZipArchiverManager.uncompress((InputStream)fis, (WfFile)wfFile);
            fis = CipherManager.decryptFile((InputStream)fis, (WfFile)wfFile);
            tempFile = new File(wfFile.getFullPath() + "temp");
            fos = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
            fis.close();
            ((OutputStream)fos).close();
            fos = new FileOutputStream(tempFile, true);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            ((OutputStream)fos).close();
            fis = new FileInputStream(tempFile);
            fis = CipherManager.encryptFile((InputStream)fis, (DocumentClass)wfFile.getDocumentClass(), (WfFile)wfFile);
            fis = ZipArchiverManager.compress((InputStream)fis, (DocumentClass)wfFile.getDocumentClass(), (WfFile)wfFile);
            fos = new FileOutputStream(file);
            wfFile.setSize(Long.valueOf(fis.available()).longValue());
            fs.updateFile(wfFile);
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
            log.info("Next parts of file [{}] was saved", (Object)sFileId);
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(is);
                FileUtils.deleteQuietly(tempFile);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly((InputStream)is);
            FileUtils.deleteQuietly(tempFile);
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((InputStream)is);
        FileUtils.deleteQuietly((File)tempFile);
        return Integer.valueOf(sFileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] GetTasksForUser(String userName) {
        log.info("GetTasksForUser:" + userName);
        ArrayList<CallSite> alTasks = new ArrayList<CallSite>();
        String sQuerry = "select processes.id as procid, processes.name as procname, processes.description as procdescr, assignmentstable.activityid as activid, activities.name as actname, activities.activated as actstarttime ,assignmentstable.activityprocessid, assignmentstable.resourceid, assignmentstable.isaccepted from processes, assignmentstable, activities where processes.id = assignmentstable.activityprocessid and activities.id = assignmentstable.activityid and assignmentstable.resourceid = '" + userName + "' ORDER BY actstarttime";
        Connection con = null;
        Statement st = null;
        try {
            con = DBManagement.ConnectToDB();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sQuerry);
            log.info(sQuerry);
            while (rs.next()) {
                String assgid = rs.getString("activid");
                String procid = rs.getString("procid");
                String procname = rs.getString("procname");
                String actname = rs.getString("actname");
                log.info("assgid:" + assgid + "    procid:" + procid);
                String sTask = procid + ";" + assgid + ";" + procname + ";" + actname;
                alTasks.add((CallSite)((Object)sTask));
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sqle) {
                    log.error(sqle.getMessage(), (Throwable)sqle);
                }
            }
            DBManagement.CloseConnection((Connection)con);
        }
        String[] asTasks = new String[alTasks.size()];
        for (int i = 0; i < alTasks.size(); ++i) {
            String sTask;
            asTasks[i] = sTask = (String)alTasks.get(i);
        }
        return asTasks;
    }

    @Override
    public String GetPackageId(String processDefinitionId) {
        try {
            String packageId = SharkFunctions.getPackageManager().getPackageIdByProcessDefinitionId(processDefinitionId);
            return packageId;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] GetTaskDefsForUser(String userName, String procDefId) {
        Package pack = null;
        HashMap<String, String> hmActInfo = null;
        UsersManagement usersManagement = null;
        try {
            pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(procDefId);
            if (pack == null) {
                throw new Exception("Pakiet pusty!");
            }
            hmActInfo = new HashMap<String, String>();
            usersManagement = new UsersManagement(pack.getId());
            WorkflowProcess wp = pack.getWorkflowProcess(procDefId);
            Activities activities = wp.getActivities();
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                String packageId = pack.getId();
                String roleId = activity.getPerformer();
                Role role = ServiceFactory.getRoleService().getRole(packageId, procDefId, roleId);
                ArrayList allUsersForRole = usersManagement.GetAllUsersForRole(role.getId());
                if (!allUsersForRole.contains(userName) && userName.compareToIgnoreCase("admin") != 0) continue;
                hmActInfo.put(activity.getId(), activity.getName());
            }
            String[] result = new String[hmActInfo.size() * 2];
            Set ksActIds = hmActInfo.keySet();
            Iterator itrActIds = ksActIds.iterator();
            int i = 0;
            while (itrActIds.hasNext()) {
                result[i] = (String)itrActIds.next();
                result[++i] = (String)hmActInfo.get(result[i - 1]);
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] GetProcessDefsForUser(String userName) {
        Object pack = null;
        HashMap<String, String> hmProcInfo = null;
        UsersManagement usersManagement = null;
        Object con = null;
        Object st = null;
        try {
            usersManagement = new UsersManagement();
            hmProcInfo = new HashMap<String, String>();
            List processes = SharkFunctions.getPackageManager().getAllWorkflowProcesses();
            for (WorkflowProcess wp : processes) {
                ArrayList allUsersForProcess = usersManagement.GetAllUsersForProcess(wp.getId());
                if (!allUsersForProcess.contains(userName) && userName.compareToIgnoreCase("admin") != 0) continue;
                hmProcInfo.put(wp.getId(), wp.getName());
            }
            String[] result = new String[hmProcInfo.size() * 2];
            Set ksProcIds = hmProcInfo.keySet();
            Iterator itrProcIds = ksProcIds.iterator();
            int i = 0;
            while (itrProcIds.hasNext()) {
                result[i] = (String)itrProcIds.next();
                result[++i] = (String)hmProcInfo.get(result[i - 1]);
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public ElementData[] GetTaskDef(String userName, String procDefId, String actDefId) {
        Package pack = null;
        WorkflowProcess workflowProcess = null;
        Activity activity = null;
        DataFields dataFields = null;
        ExtendedAttributes extendedAttributes = null;
        UsersManagement usersManagement = null;
        DBManagement dbManagement = null;
        UserGroupAdministration userGroupAdministration = null;
        ArrayList<ElementData> alElementData = null;
        ElementData[] tabElementData = null;
        int variableSetId = 0;
        try {
            pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(procDefId);
            if (pack == null) {
                throw new Exception("Pakiet pusty!");
            }
            usersManagement = new UsersManagement(pack.getId());
            dbManagement = new DBManagement();
            userGroupAdministration = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            workflowProcess = pack.getWorkflowProcess(procDefId);
            activity = workflowProcess.getActivity(actDefId);
            String packageId = pack.getId();
            String roleId = activity.getPerformer();
            Role role = ServiceFactory.getRoleService().getRole(packageId, procDefId, roleId);
            ArrayList allUsersForRole = usersManagement.GetAllUsersForRole(role.getId());
            if (!allUsersForRole.contains(userName) && userName.compareToIgnoreCase("admin") != 0) {
                throw new Exception("Uzytkownik: " + userName + " nie moze pobrac definicji zadania: " + actDefId);
            }
            alElementData = new ArrayList<ElementData>();
            dataFields = workflowProcess.getDataFields();
            extendedAttributes = activity.getExtendedAttributes();
            if (extendedAttributes != null && extendedAttributes.size() > 0) {
                for (int i = 0; i < extendedAttributes.size(); ++i) {
                    ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributes.get(i);
                    String extendedAttributeName = extendedAttribute.getName();
                    String extendedAttributeValue = extendedAttribute.getVValue();
                    if (extendedAttributeName.compareToIgnoreCase("VariableToProcess_VIEW") != 0 && extendedAttributeName.compareToIgnoreCase("VariableToProcess_UPDATE") != 0 && extendedAttributeName.compareToIgnoreCase("VariableToProcess_HIDDEN") != 0 && extendedAttributeName.compareToIgnoreCase("VARIABLE_SET") != 0 && extendedAttributeName.compareToIgnoreCase("VARIABLE_SET_VIEW") != 0) continue;
                    String[] extendedAttributeValueTab = extendedAttributeValue.split("\n");
                    ArrayList<String> alVariableNames = new ArrayList<String>();
                    HashMap<String, String> hmCheckIndex = new HashMap<String, String>();
                    if (extendedAttributeName.compareToIgnoreCase("VARIABLE_SET") == 0 || extendedAttributeName.compareToIgnoreCase("VARIABLE_SET_VIEW") == 0) {
                        ++variableSetId;
                        String sCheck = "CHECKINDEX";
                        String sOnAddNewSet = "ONADDNEWSET";
                        String sVerification = "VERIFICATION";
                        for (int eav = 0; eav < extendedAttributeValueTab.length; ++eav) {
                            if (extendedAttributeValueTab[eav].startsWith(sCheck)) {
                                String checkIndexTMP = extendedAttributeValueTab[eav].substring(sCheck.length() + 1);
                                String[] checkIndexTabTMP = checkIndexTMP.split("=>");
                                hmCheckIndex.put(checkIndexTabTMP[1], checkIndexTabTMP[0]);
                                continue;
                            }
                            if (extendedAttributeValueTab[eav].startsWith(sOnAddNewSet) || extendedAttributeValueTab[eav].startsWith(sVerification)) continue;
                            alVariableNames.add(extendedAttributeValueTab[eav]);
                        }
                    } else {
                        alVariableNames.add(extendedAttributeValueTab[0]);
                    }
                    for (int varNum = 0; varNum < alVariableNames.size(); ++varNum) {
                        ExtendedAttributes dataFieldExtendedAttributes;
                        DataField dataField = dataFields.getDataField((String)alVariableNames.get(varNum));
                        if (dataField == null) continue;
                        ElementData elementData = new ElementData();
                        elementData.setId(dataField.getId());
                        elementData.setName(dataField.getName());
                        elementData.setDescription(dataField.getDescription());
                        elementData.setType(dataField.getDataType().getDataTypes().getBasicType().getType());
                        if (extendedAttributeName.compareToIgnoreCase("VariableToProcess_VIEW") == 0 || extendedAttributeName.compareToIgnoreCase("VARIABLE_SET_VIEW") == 0) {
                            elementData.setReadOnly(true);
                        }
                        if (extendedAttributeName.compareToIgnoreCase("VariableToProcess_HIDDEN") == 0) {
                            elementData.setHidden(true);
                        }
                        if (extendedAttributeName.compareToIgnoreCase("VARIABLE_SET") == 0 || extendedAttributeName.compareToIgnoreCase("VARIABLE_SET_VIEW") == 0) {
                            elementData.setVariableSet(true);
                            elementData.setVariableSetId(variableSetId);
                            if (hmCheckIndex.containsKey(elementData.getId())) {
                                elementData.setCheckIndexParent((String)hmCheckIndex.get(elementData.getId()));
                            }
                        }
                        if ((dataFieldExtendedAttributes = dataField.getExtendedAttributes()) != null && dataFieldExtendedAttributes.size() > 0) {
                            ExtendedAttribute dataFieldExtendedAttribute;
                            if (dataFieldExtendedAttributes.containsElement("SUBTYPE")) {
                                dataFieldExtendedAttribute = dataFieldExtendedAttributes.getFirstExtendedAttributeForName("SUBTYPE");
                                String sSubType = dataFieldExtendedAttribute.getVValue();
                                elementData.setSubType(sSubType);
                            }
                            if (dataFieldExtendedAttributes.containsElement("READONLY")) {
                                dataFieldExtendedAttribute = dataFieldExtendedAttributes.getFirstExtendedAttributeForName("READONLY");
                                String sReadOnly = dataFieldExtendedAttribute.getVValue();
                                if (sReadOnly.compareToIgnoreCase("true") == 0 || sReadOnly.compareToIgnoreCase("yes") == 0) {
                                    elementData.setReadOnly(true);
                                } else {
                                    elementData.setReadOnly(false);
                                }
                            }
                            if (dataFieldExtendedAttributes.containsElement("REQUIREMENT")) {
                                dataFieldExtendedAttribute = dataFieldExtendedAttributes.getFirstExtendedAttributeForName("REQUIREMENT");
                                String sRequirement = dataFieldExtendedAttribute.getVValue();
                                if (sRequirement.compareToIgnoreCase("true") == 0 || sRequirement.compareToIgnoreCase("yes") == 0) {
                                    elementData.setRequirement(true);
                                } else {
                                    elementData.setRequirement(false);
                                }
                            }
                            if (dataFieldExtendedAttributes.containsElement("REG_EXPRESSION")) {
                                dataFieldExtendedAttribute = dataFieldExtendedAttributes.getFirstExtendedAttributeForName("REG_EXPRESSION");
                                String sRegExpression = dataFieldExtendedAttribute.getVValue();
                                elementData.setRegExpression(sRegExpression);
                            }
                            if (dataFieldExtendedAttributes.containsElement("VALUES")) {
                                dataFieldExtendedAttribute = dataFieldExtendedAttributes.getFirstExtendedAttributeForName("VALUES");
                                String sValues = dataFieldExtendedAttribute.getVValue();
                                if (sValues.compareToIgnoreCase("ROLEUSERS") == 0 && extendedAttributeName.compareToIgnoreCase("VARIABLE_SET") != 0 && extendedAttributeName.compareToIgnoreCase("VARIABLE_SET_VIEW") != 0) {
                                    ArrayList<String> alUserIds = new ArrayList<String>();
                                    for (int z = 1; z < extendedAttributeValueTab.length; ++z) {
                                        String[] sExtAttrValTMP = extendedAttributeValueTab[z].split("=");
                                        if (sExtAttrValTMP[0].compareToIgnoreCase("role") == 0) {
                                            roleId = sExtAttrValTMP[1];
                                            role = ServiceFactory.getRoleService().getRole(packageId, procDefId, roleId);
                                            ArrayList alRoleUsers = usersManagement.GetAllUsersForRole(role.getId());
                                            for (int ru = 0; ru < alRoleUsers.size(); ++ru) {
                                                if (alUserIds.contains(alRoleUsers.get(ru))) continue;
                                                alUserIds.add((String)alRoleUsers.get(ru));
                                            }
                                            continue;
                                        }
                                        if (sExtAttrValTMP[0].compareToIgnoreCase("group") == 0) {
                                            String groupId = sExtAttrValTMP[1];
                                            ArrayList alGroupUsers = usersManagement.GetAllUsersForGroup(groupId);
                                            for (int gu = 0; gu < alGroupUsers.size(); ++gu) {
                                                if (alUserIds.contains(alGroupUsers.get(gu))) continue;
                                                alUserIds.add((String)alGroupUsers.get(gu));
                                            }
                                            continue;
                                        }
                                        if (sExtAttrValTMP[0].compareToIgnoreCase("ou") != 0) continue;
                                        String organizationalUnitId = sExtAttrValTMP[1];
                                        ArrayList<String> positionOrganizationalUnitIds = new ArrayList<String>();
                                        positionOrganizationalUnitIds.add(organizationalUnitId);
                                        PositionFinder ps = FinderFactory.getPositionFinder();
                                        DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
                                        dc.createAlias("organizationalUnit", "ou");
                                        dc.setFetchMode("user", FetchMode.JOIN);
                                        dc.add((Criterion)Restrictions.eq((String)"ou.id", (Object)organizationalUnitId));
                                        List positions = ps.findByCriteria(dc);
                                        for (Position p : positions) {
                                            if (p.getUser() == null || alUserIds.contains(p.getUser().getUserName())) continue;
                                            alUserIds.add(p.getUser().getUserName());
                                        }
                                    }
                                    if (elementData.subType.compareToIgnoreCase("ADVANCELISTBOX") == 0) {
                                        tabValuesTMP = new String[alUserIds.size()];
                                        for (int alb = 0; alb < alUserIds.size(); ++alb) {
                                            tabValuesTMP[alb] = (String)alUserIds.get(alb) + "\n" + userGroupAdministration.getUserRealName((String)alUserIds.get(alb));
                                        }
                                        elementData.setValues(tabValuesTMP);
                                    } else {
                                        tabValuesTMP = new String[alUserIds.size()];
                                        for (int lb = 0; lb < alUserIds.size(); ++lb) {
                                            tabValuesTMP[lb] = (String)alUserIds.get(lb);
                                        }
                                        elementData.setValues(tabValuesTMP);
                                    }
                                } else if (sValues.startsWith("<") && sValues.endsWith(">")) {
                                    elementData.setValueFromFile(true);
                                } else {
                                    String[] tabValuesTMP = sValues.split("\n");
                                    elementData.setValues(tabValuesTMP);
                                }
                            }
                        } else {
                            elementData.setReadOnly(false);
                            elementData.setRequirement(false);
                            elementData.setRegExpression("");
                            elementData.setSubType("");
                            elementData.setValues(null);
                        }
                        alElementData.add(elementData);
                    }
                }
            }
            tabElementData = new ElementData[alElementData.size()];
            for (int k = 0; k < alElementData.size(); ++k) {
                tabElementData[k] = (ElementData)alElementData.get(k);
            }
            return tabElementData;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public int CreateProcess(String sUserName, String sPackageId, String sProcessDefId, String[] hmVariables) {
        int iRet;
        block29: {
            iRet = 0;
            WfProcess shProcess = null;
            String sProcNameMask = "";
            Package pack = SharkFunctions.getPackageManager().getPackage(sPackageId);
            if (pack == null) {
                pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
            }
            log.info("ok");
            SharkConnection shConn = Shark.getInstance().getSharkConnection();
            String sProcName = "";
            log.info("Creating process......" + sPackageId + " " + sProcessDefId);
            try {
                shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
                shProcess = shConn.createProcess(sPackageId, sProcessDefId);
                log.info("Creating process OK ..." + sPackageId + " " + sProcessDefId);
                WorkflowProcess wp = pack.getWorkflowProcess(sProcessDefId);
                if (wp == null) break block29;
                Tools tool = new Tools();
                HashMap hmIndecies = tool.GetMappingForStringArray(hmVariables);
                Tools.SetDefaultVariablesForCreateProcess((String)sUserName, (WfProcess)shProcess, (String)sProcessDefId, (Package)pack);
                Map processContextMap = shProcess.process_context();
                Iterator iterProcessVariable = processContextMap.keySet().iterator();
                log.info("processContextMap.keySet():" + processContextMap.keySet().size());
                log.info("Uzupe\u0142nienie danych dla procesu :" + sProcName + "......");
                while (iterProcessVariable.hasNext()) {
                    String sVariableValue = "";
                    String sVariableName = (String)iterProcessVariable.next();
                    String sIndexId = (String)hmIndecies.get(sVariableName);
                    if (sIndexId != null && sIndexId.compareTo("") != 0) {
                        Object c;
                        block30: {
                            sVariableValue = sIndexId;
                            log.info("sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            log.info("Odczyt zmiennej dla procesu :" + sProcName + "| sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            c = processContextMap.get(sVariableName);
                            if (c instanceof Double) {
                                try {
                                    log.info("double1:" + sVariableValue);
                                    sVariableValue = sVariableValue.replaceAll("[\\\\]", "");
                                    sVariableValue = sVariableValue.replaceAll("[,]", ".");
                                    sVariableValue = sVariableValue.replaceAll("[ ]", "");
                                    log.info("double2:" + sVariableValue);
                                    Double d = new Double(sVariableValue);
                                    log.info("double:" + d);
                                    if (d == null) {
                                        Double.valueOf("0");
                                    }
                                    c = d;
                                }
                                catch (Exception e) {
                                    Double d = new Double("0");
                                    c = Double.valueOf("0");
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            } else if (c instanceof Float) {
                                c = Float.valueOf(sVariableValue);
                            } else if (c instanceof Long) {
                                c = new Long(sVariableValue);
                            } else if (c instanceof Boolean) {
                                if (sVariableValue == null) {
                                    sVariableValue = "NIE";
                                }
                                c = sVariableValue.compareToIgnoreCase("TAK") == 0 || sVariableValue.compareToIgnoreCase("on") == 0 ? Boolean.valueOf("true") : Boolean.valueOf("false");
                            } else if (c instanceof Date) {
                                try {
                                    Date dt;
                                    if (sVariableValue == null || sVariableValue.compareToIgnoreCase("") == 0) {
                                        dt = new Date(0L);
                                        c = dt;
                                        break block30;
                                    }
                                    dt = new Date(Date.parse(sVariableValue));
                                    c = dt;
                                }
                                catch (Exception e) {
                                    Date dt = new Date(0L);
                                    c = dt;
                                    log.info("ERROR:" + e.getMessage());
                                }
                            } else {
                                c = sVariableValue;
                            }
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName);
                        try {
                            processContextMap.put(sVariableName, c);
                        }
                        catch (Exception e) {
                            log.info("ERROR:" + e.getMessage());
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName + "  OK");
                    }
                    log.info("sVariableName: " + sVariableName + " sVariableValue:" + sVariableValue);
                }
                shProcess.set_process_context(processContextMap);
                log.info("Ustawienie contextu zmiennej DocIds dla procesu :" + sProcName + "    OK");
                DBManagement dbm = new DBManagement();
                dbm.SaveVariableValuesToDB(pack, shProcess, processContextMap);
                ProcessLocale.createProcessLocale((String)shProcess.key(), (String)shProcess.name(), (String)sProcessDefId);
                log.info("Starting process:" + sProcName);
                shProcess.start();
                log.info("Starting process:" + sProcName + " successful");
                shConn.disconnect();
            }
            catch (BaseException e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotConnected e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotEnabled e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidData e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (UpdateNotAllowed e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.info("Error in Creating process:" + e.getMessage() + " :" + sProcName);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int CreateProcess(String sUserName, String sPackageId, String sProcessDefId, String[] hmVariables, boolean bCompliteFirstActivity) {
        int iRet;
        block45: {
            iRet = 0;
            WfProcess shProcess = null;
            String sProcNameMask = "";
            Package pack = SharkFunctions.getPackageManager().getPackage(sPackageId);
            if (pack == null) {
                pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
            }
            log.info("ok");
            SharkConnection shConn = Shark.getInstance().getSharkConnection();
            String sProcName = "";
            log.info("Creating process......" + sPackageId + " " + sProcessDefId);
            try {
                shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
                shProcess = shConn.createProcess(sPackageId, sProcessDefId);
                log.info("Creating process OK ..." + sPackageId + " " + sProcessDefId);
                WorkflowProcess wp = pack.getWorkflowProcess(sProcessDefId);
                if (wp == null) break block45;
                Tools tool = new Tools();
                HashMap hmIndecies = tool.GetMappingForStringArray(hmVariables);
                Tools.SetDefaultVariablesForCreateProcess((String)sUserName, (WfProcess)shProcess, (String)sProcessDefId, (Package)pack);
                Map processContextMap = shProcess.process_context();
                Iterator iterProcessVariable = processContextMap.keySet().iterator();
                log.info("processContextMap.keySet():" + processContextMap.keySet().size());
                log.info("Uzupe\u0142nienie danych dla procesu :" + sProcName + "......");
                while (iterProcessVariable.hasNext()) {
                    String sVariableValue = "";
                    String sVariableName = (String)iterProcessVariable.next();
                    String sIndexId = (String)hmIndecies.get(sVariableName);
                    if (sIndexId != null && sIndexId.compareTo("") != 0) {
                        Object c;
                        block46: {
                            sVariableValue = sIndexId;
                            log.info("sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            log.info("Odczyt zmiennej dla procesu :" + sProcName + "| sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            c = processContextMap.get(sVariableName);
                            if (c instanceof Double) {
                                try {
                                    log.info("double1:" + sVariableValue);
                                    sVariableValue = sVariableValue.replaceAll("[\\\\]", "");
                                    sVariableValue = sVariableValue.replaceAll("[,]", ".");
                                    sVariableValue = sVariableValue.replaceAll("[ ]", "");
                                    log.info("double2:" + sVariableValue);
                                    Double d = new Double(sVariableValue);
                                    log.info("double:" + d);
                                    if (d == null) {
                                        Double.valueOf("0");
                                    }
                                    c = d;
                                }
                                catch (Exception e) {
                                    Double d = new Double("0");
                                    c = Double.valueOf("0");
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            } else if (c instanceof Float) {
                                c = Float.valueOf(sVariableValue);
                            } else if (c instanceof Long) {
                                c = new Long(sVariableValue);
                            } else if (c instanceof Boolean) {
                                if (sVariableValue == null) {
                                    sVariableValue = "NIE";
                                }
                                c = sVariableValue.compareToIgnoreCase("TAK") == 0 || sVariableValue.compareToIgnoreCase("on") == 0 ? Boolean.valueOf("true") : Boolean.valueOf("false");
                            } else if (c instanceof Date) {
                                try {
                                    Date dt;
                                    if (sVariableValue == null || sVariableValue.compareToIgnoreCase("") == 0) {
                                        dt = new Date(0L);
                                        c = dt;
                                        break block46;
                                    }
                                    dt = new Date(Date.parse(sVariableValue));
                                    c = dt;
                                }
                                catch (Exception e) {
                                    Date dt = new Date(0L);
                                    c = dt;
                                    log.info("ERROR:" + e.getMessage());
                                }
                            } else {
                                c = sVariableValue;
                            }
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName);
                        try {
                            processContextMap.put(sVariableName, c);
                        }
                        catch (Exception e) {
                            log.info("ERROR:" + e.getMessage());
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName + "  OK");
                    }
                    log.info("sVariableName: " + sVariableName + " sVariableValue:" + sVariableValue);
                }
                shProcess.set_process_context(processContextMap);
                log.info("Ustawienie contextu zmiennej DocIds dla procesu :" + sProcName + "    OK");
                DBManagement dbm = new DBManagement();
                dbm.SaveVariableValuesToDB(pack, shProcess, processContextMap);
                ProcessLocale.createProcessLocale((String)shProcess.key(), (String)shProcess.name(), (String)sProcessDefId);
                log.info("Starting process:" + sProcName);
                shProcess.start();
                log.info("Starting process:" + sProcName + " successful");
                if (!bCompliteFirstActivity) break block45;
                log.info("Zakonczenie uruchomionych zadan");
                WfActivityIterator oActivityIterator = shProcess.get_activities_in_state("open.not_running.not_started");
                WfActivity oActivity = null;
                int nActivity = oActivityIterator.how_many();
                log.info("Liczba zadan do zakonczenia:" + nActivity);
                Connection con = null;
                try {
                    con = DBManagement.ConnectToDB();
                    for (int i = 0; i < nActivity; ++i) {
                        oActivity = oActivityIterator.get_next_object();
                        log.info("Zakonczenie zadania: " + oActivity.key());
                        String sQuerry = "update activities set state = 1000001 where id = '" + oActivity.key() + "'";
                        Statement st = null;
                        try {
                            st = con.createStatement();
                            log.info(sQuerry);
                            int nResult = st.executeUpdate(sQuerry);
                            log.info("Zmienionych rekord\u00f3w: " + nResult);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (SQLException sqle) {
                                    log.error(sqle.getMessage(), (Throwable)sqle);
                                }
                            }
                        }
                        oActivity.complete();
                    }
                }
                finally {
                    DBManagement.CloseConnection((Connection)con);
                }
            }
            catch (BaseException e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotConnected e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotEnabled e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidData e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (UpdateNotAllowed e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.info("Error in Creating process:" + e.getMessage() + " :" + sProcName);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return iRet;
    }

    @Override
    public String testingCreateProcess(String sUserName, String sPackageId, String sProcessDefId, String[] hmVariables) {
        String sRet;
        block29: {
            sRet = "";
            WfProcess shProcess = null;
            String sProcNameMask = "";
            Package pack = SharkFunctions.getPackageManager().getPackage(sPackageId);
            if (pack == null) {
                pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
            }
            log.info("ok");
            SharkConnection shConn = Shark.getInstance().getSharkConnection();
            String sProcName = "";
            log.info("Creating process......" + sPackageId + " " + sProcessDefId);
            try {
                shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
                shProcess = shConn.createProcess(sPackageId, sProcessDefId);
                log.info("Process ID " + shProcess.key());
                sRet = shProcess.key();
                log.info("Creating process OK ..." + sPackageId + " " + sProcessDefId);
                WorkflowProcess wp = pack.getWorkflowProcess(sProcessDefId);
                if (wp == null) break block29;
                Tools tool = new Tools();
                HashMap hmIndecies = tool.GetMappingForStringArray(hmVariables);
                Tools.SetDefaultVariablesForCreateProcess((String)sUserName, (WfProcess)shProcess, (String)sProcessDefId, (Package)pack);
                Map processContextMap = shProcess.process_context();
                Iterator iterProcessVariable = processContextMap.keySet().iterator();
                log.info("processContextMap.keySet():" + processContextMap.keySet().size());
                log.info("Uzupe\u0142nienie danych dla procesu :" + sProcName + "......");
                while (iterProcessVariable.hasNext()) {
                    String sVariableValue = "";
                    String sVariableName = (String)iterProcessVariable.next();
                    String sIndexId = (String)hmIndecies.get(sVariableName);
                    if (sIndexId != null && sIndexId.compareTo("") != 0) {
                        Object c;
                        block30: {
                            sVariableValue = sIndexId;
                            log.info("sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            log.info("Odczyt zmiennej dla procesu :" + sProcName + "| sVariableName:" + sVariableName + " sVariableValue:" + sVariableValue);
                            c = processContextMap.get(sVariableName);
                            if (c instanceof Double) {
                                try {
                                    log.info("double1:" + sVariableValue);
                                    sVariableValue = sVariableValue.replaceAll("[\\\\]", "");
                                    sVariableValue = sVariableValue.replaceAll("[,]", ".");
                                    sVariableValue = sVariableValue.replaceAll("[ ]", "");
                                    log.info("double2:" + sVariableValue);
                                    Double d = new Double(sVariableValue);
                                    log.info("double:" + d);
                                    if (d == null) {
                                        Double.valueOf("0");
                                    }
                                    c = d;
                                }
                                catch (Exception e) {
                                    Double d = new Double("0");
                                    c = Double.valueOf("0");
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            } else if (c instanceof Float) {
                                c = Float.valueOf(sVariableValue);
                            } else if (c instanceof Long) {
                                c = new Long(sVariableValue);
                            } else if (c instanceof Boolean) {
                                if (sVariableValue == null) {
                                    sVariableValue = "NIE";
                                }
                                c = sVariableValue.compareToIgnoreCase("TAK") == 0 || sVariableValue.compareToIgnoreCase("on") == 0 ? Boolean.valueOf("true") : Boolean.valueOf("false");
                            } else if (c instanceof Date) {
                                try {
                                    Date dt;
                                    if (sVariableValue == null || sVariableValue.compareToIgnoreCase("") == 0) {
                                        dt = new Date(0L);
                                        c = dt;
                                        break block30;
                                    }
                                    dt = new Date(Date.parse(sVariableValue));
                                    c = dt;
                                }
                                catch (Exception e) {
                                    Date dt = new Date(0L);
                                    c = dt;
                                    log.info("ERROR:" + e.getMessage());
                                }
                            } else {
                                c = sVariableValue;
                            }
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName);
                        try {
                            processContextMap.put(sVariableName, c);
                        }
                        catch (Exception e) {
                            log.info("ERROR:" + e.getMessage());
                        }
                        log.info("Ustawienie contextu dla procesu :" + sProcName + "  OK");
                    }
                    log.info("sVariableName: " + sVariableName + " sVariableValue:" + sVariableValue);
                }
                shProcess.set_process_context(processContextMap);
                log.info("Ustawienie contextu zmiennej DocIds dla procesu :" + sProcName + "    OK");
                DBManagement dbm = new DBManagement();
                dbm.SaveVariableValuesToDB(pack, shProcess, processContextMap);
                ProcessLocale.createProcessLocale((String)shProcess.key(), (String)shProcess.name(), (String)sProcessDefId);
                log.info("Starting process:" + sProcName);
                shProcess.start();
                log.info("Starting process:" + sProcName + " successful");
                shConn.disconnect();
            }
            catch (BaseException e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotConnected e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotEnabled e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (InvalidData e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (UpdateNotAllowed e) {
                log.info("Error in Creating process" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.info("Error in Creating process:" + e.getMessage() + " :" + sProcName);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return sRet;
    }

    @Override
    public String testingGetActivityID(String sUserName, String sPackageId, String sProcId) {
        WfProcess shProcess = null;
        SharkConnection shConn = Shark.getInstance().getSharkConnection();
        try {
            shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ea.connect(username, password, "KlientTestowy", null);
            shProcess = ea.getProcess(sProcId);
            WfActivity oActivity = null;
            WfActivityIterator oActivityIterator = shProcess.get_activities_in_state("open.not_running.not_started");
            oActivity = null;
            log.info("STATE_OPEN_NOT_RUNNING_NOT_STARTED: " + oActivityIterator.how_many() + " zostana wystartowane");
            int iCnt = oActivityIterator.how_many();
            for (int z = 0; z < iCnt; ++z) {
                oActivity = oActivityIterator.get_next_object();
                log.info("uruchamiam zadanie: " + oActivity.key());
                oActivity.change_state("open.running");
            }
            oActivityIterator = shProcess.get_activities_in_state("open.running");
            log.info("STATE_OPEN_RUNNING:" + oActivityIterator.how_many());
            iCnt = oActivityIterator.how_many();
            Object sRet = "";
            for (int z = 0; z < iCnt; ++z) {
                oActivity = oActivityIterator.get_next_object();
                log.info("zadanie: " + oActivity.key());
                sRet = (String)sRet + oActivity.key().toString() + " ";
            }
            return sRet;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return "";
        }
    }

    @Override
    public String testingGetConditions(String sUserName, String sPackageId, String sProcessDefId) {
        Object sRet = "";
        Object shProcess = null;
        Package pack = SharkFunctions.getPackageManager().getPackage(sPackageId);
        if (pack == null) {
            pack = SharkFunctions.getPackageManager().getPackage(sProcessDefId);
        }
        SharkConnection shConn = Shark.getInstance().getSharkConnection();
        try {
            shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ea.connect(username, password, "KlientTestowy", null);
            WorkflowProcess wp = pack.getWorkflowProcess(sProcessDefId);
            Transitions transitions = wp.getTransitions();
            for (int i = 0; i < transitions.size(); ++i) {
                Transition trans = (Transition)transitions.get(i);
                Condition cCond = trans.getCondition();
                sRet = (String)sRet + trans.getFrom() + ";" + trans.getTo() + ";" + cCond.toValue() + ";EOL;";
            }
            return sRet;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return "";
        }
    }

    @Override
    public int testingAcceptActivity(String userName, String packageId, String processDefId, String processId, String activityId, String[] ssVariables) {
        SharkConnection shConn = Shark.getInstance().getSharkConnection();
        try {
            shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ea.connect(username, password, "KlientTestowy", null);
            WfAssignment wfAssignment = ea.getAssignment(processId, activityId, userName);
            WfActivity wfActivity = wfAssignment.activity();
            Map processContextMap = wfActivity.process_context();
            Map activityDBContextMap = new HashMap();
            activityDBContextMap = wfActivity.process_context();
            for (int i = 0; i < ssVariables.length; ++i) {
                String sName = ssVariables[i].substring(0, ssVariables[i].indexOf("="));
                String sValue = ssVariables[i].substring(ssVariables[i].indexOf("=") + 1);
                log.info("parametr " + sName + " = " + sValue);
                Object c = processContextMap.get(sName);
                c = Tools.SetObjectValue(c, (String)sValue);
                processContextMap.put(sName, c);
            }
            wfActivity.set_result(processContextMap);
            wfActivity.complete();
            return 0;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return 1;
        }
    }

    @Override
    public String testingGetActivityState(String sUserName, String sPackageId, String sProcessId, String sActivityId) {
        SharkConnection shConn = Shark.getInstance().getSharkConnection();
        try {
            shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ea.connect(username, password, "KlientTestowy", null);
            WfAssignment wfAssignment = ea.getAssignment(sProcessId, sActivityId, sUserName);
            WfActivity wfActivity = wfAssignment.activity();
            return wfActivity.state();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return null;
        }
    }

    @Override
    public String testingGetProcessState(String sUserName, String sPackageId, String sProcessId) {
        SharkConnection shConn = Shark.getInstance().getSharkConnection();
        try {
            shConn.connect("admin", PlusWorkflowSecrets.DEFAULT_ADMIN_PASSWORD, "KlientTestowy", "");
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            WfProcess shProcess = null;
            ea.connect(username, password, "KlientTestowy", null);
            shProcess = ea.getProcess(sProcessId);
            return shProcess.state();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return null;
        }
    }

    @Override
    public String[] GetIndexesMetaData() {
        DBManagement dbm = new DBManagement();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DocumentClassService dcs = ServiceFactory.getDocumentClassService();
        List docClasses = dcs.getAll(new String[0]);
        for (DocumentClass docClassTable : docClasses) {
            ArrayList indexes = DBManagement.GetAllIndecies((String)docClassTable.getId().toString());
            for (IndexTable indexTable : indexes) {
                String name = indexTable.getIndexName();
                Object type = indexTable.getIndexType();
                if (((String)type).compareToIgnoreCase("list") == 0) {
                    type = (String)type + ":";
                    for (String val : indexTable.getValues()) {
                        type = (String)type + val + ":";
                    }
                }
                if (map.containsKey(name) && !((String)type).equals(map.get(name))) {
                    type = (String)map.get(name) + ";" + docClassTable.getId() + ":" + (String)type;
                }
                map.put(name, type);
            }
        }
        ArrayList<CallSite> result = new ArrayList<CallSite>(map.size());
        for (String name : map.keySet()) {
            result.add((CallSite)((Object)(name + ";" + (String)map.get(name))));
        }
        return result.toArray(new String[docClasses.size()]);
    }

    public class ElementData {
        private String id;
        private String name;
        private String description;
        private int variableSetId;
        private boolean variableSet;
        private String checkIndexParent;
        private String type;
        private String subType;
        private boolean readOnly;
        private boolean requirement;
        private boolean hidden;
        private boolean valueFromFile;
        private String regExpression;
        private String[] values;

        ElementData() {
        }

        public boolean isValueFromFile() {
            return this.valueFromFile;
        }

        public void setValueFromFile(boolean valueFromFile) {
            this.valueFromFile = valueFromFile;
        }

        public String getCheckIndexParent() {
            return this.checkIndexParent;
        }

        public void setCheckIndexParent(String checkIndexParent) {
            this.checkIndexParent = checkIndexParent;
        }

        public int getVariableSetId() {
            return this.variableSetId;
        }

        public void setVariableSetId(int variableSetId) {
            this.variableSetId = variableSetId;
        }

        public boolean isVariableSet() {
            return this.variableSet;
        }

        public void setVariableSet(boolean variableSet) {
            this.variableSet = variableSet;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean isRequirement() {
            return this.requirement;
        }

        public void setRequirement(boolean requirement) {
            this.requirement = requirement;
        }

        public String getRegExpression() {
            return this.regExpression;
        }

        public void setRegExpression(String regExpression) {
            this.regExpression = regExpression;
        }

        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

