/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.filter;

import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.ModuleAccessor;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.LicenseData;
import com.suncode.pwfl.license.trial.TrialLicense;
import com.suncode.pwfl.license.trial.service.TrialService;
import com.suncode.pwfl.plugin.modules.UnauthorizedUrl;
import com.suncode.pwfl.util.Exceptions;
import com.suncode.pwfl.util.SpringContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public class ActiveSessionFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(ActiveSessionFilter.class);
    private final String mdcRequestIdKey = "requestId";
    private static final List<String> anonymousAccessLoginPaths = new LinkedList<String>(Arrays.asList("/Login.do", "/LoginManual.do", "/Logout.do", "/googleOauth2/callback", "/CustomPage.do", "/com.plusmpm.servlet.authorization.GetDomainListServlet.customServlet", "/com.plusmpm.servlet.authorization.UserAuthorizationServlet.customServlet", "/api/authentication/login", "/api/authentication/logout", "/api/authentication/domains", "/api/authentication/sso/login", "/api/authentication/sso/logout", "/api/csrf/token", "/sso/login", "/sso/perform", "/ChangePassword.do", "/api/password/expired", "/api/captcha", "/api/password/policy/profile", "/api/password/available", "/api/password/change", "/api/password/recovery", "/PasswordRecovery.do", "/LdapChangePassword.do", "/api/password/ldap/change", "/api/authentication/login/redirect", "/SelfPasswordAssign.do", "/api/password/self/assign", "/api/autoLogin", "/api/translation/bundle/cached/plusworkflow", "/api/system/version", "/api/swagger/plusworkflow", "/api/health"));
    private static final List<String> excludes = new LinkedList<String>(Arrays.asList("/api/init/database/embedded", "/api/init/database/standalone", "/api/users/unblock", "/api/mobile/version", "/api/csrf/token", "/api/authentication/login/redirect", "/api/calendar/user/share/link", "/api/calendar/default/share/link", "/api/calendar/view/share/link", "/api/calendar/process/share/link", "/api/calendar/external/share/link", "/api/calendar/set/share/link"));
    private static final List<Pattern> excludeRegexp = new LinkedList<Pattern>(Arrays.asList(Pattern.compile("/plugin/[a-zA-Z0-9.-]+/resources/public/.*")));
    private static List<String> licenseExcludes = new LinkedList<String>(Arrays.asList("/License.do", "/com.suncode.pwfl.servlet.LicenseLoad.customServlet", "/com.suncode.pwfl.servlet.LicensePreview.customServlet", "/com.suncode.pwfl.servlet.LicenseRestrictions.customServlet", "/Login.do", "/LoginManual.do", "/Logout.do", "/com.plusmpm.struts.action.LogoutAction", "/api/trial", "/api/users/avatar", "/api/csrf/token"));
    private static final List<String> fileExcludes = new LinkedList<String>(Arrays.asList("/Goto.do", "/ShowDocumentFromArchive.do", "/com.plusmpm.servlet.ShowFileServlet.customServlet", "/ShowFile.do", "/com.plusmpm.servlet.DocumentInformationServlet.customServlet", "/api/documents/get"));
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private final TrialService trialService = (TrialService)SpringContext.getBean(TrialService.class);
    public static final String LAST_HEARTBEAT_ATTR = "com.suncode.pwfl.web.controller.api.HeartbeatController.LAST";

    public void init(FilterConfig config) throws ServletException {
        String excludesParam = config.getInitParameter("excludes");
        if (excludesParam != null) {
            String[] urls = excludesParam.split(",");
            excludes.addAll(Arrays.asList(urls));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        MDC.put((String)"requestId", (String)UUID.randomUUID().toString().toUpperCase().replace("-", ""));
        if (this.isOptionsMethodCall(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession();
        String username = (String)session.getAttribute("username");
        String requestUrl = this.pathHelper.getPathWithinApplication(request);
        boolean isXhr = this.isXHR(request);
        boolean isApiCall = this.isApiCall(request);
        boolean isUserLogged = this.isUserLogged(username);
        String logMessage = "Method: " + request.getMethod() + " SessionId: " + session.getId().hashCode() + (String)(isUserLogged ? " Logged user: " + username : " User not logged in") + " Called URL: " + requestUrl;
        if (requestUrl.equals("/api/heartbeat")) {
            log.debug(logMessage);
        } else {
            log.info(logMessage);
        }
        try {
            this.processUserContextActivation(session, username, isUserLogged);
            if (this.isExcluded(anonymousAccessLoginPaths, requestUrl)) {
                request.setAttribute("PWFL.LOGIN_REQUIRED_RESOURCE", (Object)true);
                ActiveSessionFilter.logAnonymousAccessAttempt(isUserLogged, requestUrl);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (this.isExcluded(requestUrl)) {
                ActiveSessionFilter.logAnonymousAccessAttempt(isUserLogged, requestUrl);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (!isUserLogged) {
                if (isXhr || isApiCall) {
                    this.sendUnauthorized(response);
                } else {
                    this.forwardToLogin(request, response, requestUrl);
                }
            } else {
                if (this.isLicenseInvalid()) {
                    log.debug("License is invalid");
                    boolean isAdmin = username.equals("admin");
                    if (!isAdmin) {
                        this.forwardTo(request, response, "Logout.do");
                        return;
                    }
                    if (!this.isLicenseExcluded(requestUrl)) {
                        this.forwardTo(request, response, "License.do");
                        return;
                    }
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            this.processUserContextDeactivation(isUserLogged);
            MDC.remove((String)"requestId");
        }
    }

    private static void logAnonymousAccessAttempt(boolean isUserLogged, String requestUrl) {
        if (!isUserLogged) {
            log.info("Granting anonymous access to URL {} because it is excluded", (Object)requestUrl);
        }
    }

    private void processUserContextDeactivation(boolean isUserLogged) {
        if (isUserLogged) {
            UserContext.deactivate();
        }
    }

    private void processUserContextActivation(HttpSession session, String username, boolean isUserLogged) {
        if (isUserLogged) {
            UserContext.activate((UserInfo)UserInfoCache.get().get(username));
            session.setAttribute(LAST_HEARTBEAT_ATTR, (Object)System.currentTimeMillis());
        }
    }

    private boolean isOptionsMethodCall(HttpServletRequest request) {
        return request.getMethod().equals("OPTIONS");
    }

    private void forwardTo(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isLicenseInvalid() {
        TrialLicense trialLicense = this.trialService.readLicense();
        LicenseData license = LicenseAccessor.getInstance();
        return trialLicense.isValid() == false && license.isAllBlocked();
    }

    private void forwardToLogin(HttpServletRequest request, HttpServletResponse response, String requestUrl) throws ServletException, IOException {
        Map parameterMap = request.getParameterMap();
        requestUrl = (String)requestUrl + this.getUrlFromParameterMap(parameterMap);
        request.setAttribute("redirectUrl", requestUrl);
        this.forwardTo(request, response, "/Login.do");
    }

    private void sendUnauthorized(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(401);
        httpServletResponse.getWriter().write("User is not logged in!");
    }

    private boolean isUserLogged(String username) {
        return StringUtils.isNotEmpty((String)username);
    }

    private boolean isApiCall(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().contains("/api");
    }

    private String getUrlFromParameterMap(Map<String, String[]> parameterMap) {
        StringBuilder builder = new StringBuilder("?");
        for (Map.Entry<String, String[]> parameter : parameterMap.entrySet()) {
            String parameterName = parameter.getKey();
            String[] parameterValue = parameter.getValue();
            String encodedParameterValue = (String)Exceptions.silent(() -> URLEncoder.encode(parameterValue[0], "UTF-8"), () -> parameterValue[0]);
            builder.append(parameterName).append("=").append(encodedParameterValue).append("&");
        }
        return builder.substring(0, builder.length() - 1);
    }

    private boolean isXHR(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return header != null && "XMLHttpRequest".equals(header);
    }

    private boolean isExcluded(List<String> excludedPathPrefixes, String path) {
        for (String exclude : excludedPathPrefixes) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String path) {
        if (this.isExcluded(this.getExcludedUrls(), path)) {
            return true;
        }
        for (Pattern exclude : excludeRegexp) {
            if (!exclude.matcher(path).matches()) continue;
            return true;
        }
        ModuleAccessor moduleAccessor = (ModuleAccessor)SpringContext.getBean(ModuleAccessor.class);
        for (Module module : moduleAccessor.getModules(UnauthorizedUrl.class)) {
            if (!path.startsWith(((UnauthorizedUrl)module.getObject()).getUnauthorizedUrl())) continue;
            return true;
        }
        return false;
    }

    private List<String> getExcludedUrls() {
        String excludedUrlsSystemParam;
        LinkedList<String> exludedUrls = new LinkedList<String>(excludes);
        Boolean authorizeUserForFile = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.AUTHORIZE_USER_FOR_FILE);
        if (!authorizeUserForFile.booleanValue()) {
            exludedUrls.addAll(fileExcludes);
        }
        if ((excludedUrlsSystemParam = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.EXCLUDE_AUTH_PATH_LIST)) != null) {
            List<String> validExcludedUrlsFromSystemParameter = Stream.of(excludedUrlsSystemParam.split(",")).filter(excludedUrl -> excludedUrl.length() > 4).toList();
            exludedUrls.addAll(validExcludedUrlsFromSystemParameter);
        }
        return exludedUrls;
    }

    private boolean isLicenseExcluded(String path) {
        for (String exclude : licenseExcludes) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }
}

