/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui.section;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.framework.web.support.Section;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import com.suncode.pwfl.web.util.SessionUtils;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provides
@Component
public class SectionHolder {
    private final PlusWorkflowCache<String, Section> sections;

    @Autowired
    public SectionHolder(CacheFactory cacheFactory) {
        InMemoryCacheConfig cacheConfig = InMemoryCacheConfig.builder().maximumSize(Long.valueOf(5000L)).expireAfterWrite(Duration.ofMinutes(30L)).build();
        this.sections = cacheFactory.createInMemoryCache(SystemCacheId.WEB_SECTIONS_CACHE, cacheConfig);
    }

    public void save(Section section, String searchId) {
        String key = searchId + "#" + section.getKey();
        this.sections.put((Object)key, (Object)section);
    }

    public void save(Section section) {
        String key = SessionUtils.getLoggedUserName() + "#" + section.getKey();
        this.sections.put((Object)key, (Object)section);
    }

    public <T extends Section> T get(String section, String searchId) {
        String key = searchId + "#" + section;
        Section instance = (Section)this.sections.getIfPresent((Object)key);
        this.sections.invalidate((Object)key);
        return (T)instance;
    }

    public <T extends Section> T get(String section) {
        String key = SessionUtils.getLoggedUserName() + "#" + section;
        Section instance = (Section)this.sections.getIfPresent((Object)key);
        this.sections.invalidate((Object)key);
        return (T)instance;
    }
}

