/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration;

import com.suncode.pwfl.administration.configuration.Category;
import com.suncode.pwfl.web.dto.administration.SystemParameterExportDto;
import java.util.List;
import java.util.stream.Collectors;

public class CategoryExportDto
implements Comparable<CategoryExportDto> {
    private String key;
    private List<SystemParameterExportDto> parameters;

    public static CategoryExportDto create(Category category) {
        List<SystemParameterExportDto> parametersDto = category.getSystemParameters().stream().map(parameter -> SystemParameterExportDto.convert(parameter)).collect(Collectors.toList());
        CategoryExportDto categoryDto = new CategoryExportDto();
        categoryDto.setKey(category.getKey());
        categoryDto.setParameters(parametersDto);
        return categoryDto;
    }

    @Override
    public int compareTo(CategoryExportDto toCompare) {
        String key1 = this.key;
        String key2 = toCompare.getKey();
        return key1.compareToIgnoreCase(key2);
    }

    public String getKey() {
        return this.key;
    }

    public List<SystemParameterExportDto> getParameters() {
        return this.parameters;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParameters(List<SystemParameterExportDto> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryExportDto)) {
            return false;
        }
        CategoryExportDto other = (CategoryExportDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<SystemParameterExportDto> this$parameters = this.getParameters();
        List<SystemParameterExportDto> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryExportDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<SystemParameterExportDto> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "CategoryExportDto(key=" + this.getKey() + ", parameters=" + this.getParameters() + ")";
    }
}

