/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.security.service.BlockedUserService;
import com.suncode.pwfl.administration.user.security.service.SelfUnblockUserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"users"})
@Api(value="User Blocking Administration", tags={"users"})
public class BlockUserController {
    private static final Logger log = LoggerFactory.getLogger(BlockUserController.class);
    private final SelfUnblockUserService selfUnblockUserService;
    private final BlockedUserService blockedUserService;
    private final UserService userService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"unblock/{token}"})
    public void selfUnblock(@PathVariable(value="token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        try {
            this.selfUnblockUserService.unblock(token);
            session.setAttribute("message", (Object)this.messageHelper.getMessage("Konto_zostalo_odblokowane"));
            session.setAttribute("messageSuccess", (Object)true);
        }
        catch (Exception ex) {
            log.info(ex.getMessage());
            session.setAttribute("message", (Object)this.messageHelper.getMessage("Konto_nie_zostalo_odblokowane"));
            session.setAttribute("messageSuccess", (Object)false);
        }
        response.sendRedirect(request.getContextPath());
    }

    @ApiOperation(value="", hidden=true)
    @Transactional
    @ResponseBody
    @GetMapping(value={"blocked/{userId}"})
    public Map<String, Boolean> isBlocked(@PathVariable Long userId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        User user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        boolean isBlocked = this.blockedUserService.isUserBlocked(user);
        return ImmutableMap.of((Object)"isBlocked", (Object)isBlocked);
    }

    @ApiOperation(value="(Admin) Unblocking user", notes="Unblocks user with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"unblock/{userId}"})
    public void unblockUser(HttpServletRequest request, @ApiParam(value="Id of the user to unblock", required=true) @PathVariable Long userId) {
        User user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UNLOCK_USER_BY_ADMIN).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> builder.buildFailure(request));
        try {
            if (!this.blockedUserService.isUserBlocked(user)) {
                throw new RuntimeException("User " + user.getUserName() + " is not blocked");
            }
            this.blockedUserService.unblockUser(user);
            builder.buildSuccess(request);
        }
        catch (Exception ex) {
            builder.buildFailure(request);
            throw ex;
        }
    }

    @ApiOperation(value="(Admin) Blocking user", notes="Blocks user with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"block/{userId}"})
    public void blockUser(HttpServletRequest request, @ApiParam(value="Id of the user to block", required=true) @PathVariable Long userId) {
        User user = Optional.ofNullable(this.userService.getUser(userId, new String[]{"groups"})).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Uzytkownik_o_podanym_id_nie_istnieje", new Object[]{userId})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_BLOCK_USER_BY_ADMIN).params((Map)ImmutableMap.of((Object)"userId", (Object)user.getUserName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> builder.buildFailure(request));
        try {
            boolean isBlocked = this.blockedUserService.isUserBlocked(user);
            if (isBlocked) {
                throw new RuntimeException("User " + user.getUserName() + " is already blocked");
            }
            this.blockedUserService.blockUserByAdmin(user);
            builder.buildSuccess(request);
        }
        catch (Exception ex) {
            builder.buildFailure(request);
            throw ex;
        }
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"selfUnblockUserService", "blockedUserService", "userService", "authorizationHelper", "messageHelper"})
    @Autowired
    public BlockUserController(SelfUnblockUserService selfUnblockUserService, BlockedUserService blockedUserService, UserService userService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.selfUnblockUserService = selfUnblockUserService;
        this.blockedUserService = blockedUserService;
        this.userService = userService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

