/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.castor.core.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activation"})
@Api(value="User Activation", tags={"users"})
public class UserActivationController {
    private static final Logger log = LoggerFactory.getLogger(UserActivationController.class);
    private final AuthorizationHelper authorizationHelper;
    private final UserService userService;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="(Admin) Activating user", notes="Activates user")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping
    public void activate(HttpServletRequest request, @ApiParam(value="Username of the user to be activated", required=true) @RequestParam String username, @ApiParam(value="Name of the group", required=true) @RequestParam String groupNameToAttach) {
        Assert.notEmpty((String)username, (String)this.messageHelper.getMessage("Nie_podano_loginu_uzytkownika"));
        Assert.notEmpty((String)groupNameToAttach, (String)this.messageHelper.getMessage("Nie_podano_nazwy_grupy"));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ACTIVATE_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)username, (Object)"groupToAttach", (Object)groupNameToAttach));
        this.authorizationHelper.assertFullAdministrationRights(() -> builder.buildFailure(request));
        try {
            this.userService.activateUser(username);
            this.userService.addUserToGroup(username, groupNameToAttach);
            builder.buildSuccess(request);
        }
        catch (Exception ex) {
            builder.buildFailure(request);
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    @ExceptionHandler(value={ServiceException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"authorizationHelper", "userService", "messageHelper"})
    @Autowired
    public UserActivationController(AuthorizationHelper authorizationHelper, UserService userService, MessageHelperBean messageHelper) {
        this.authorizationHelper = authorizationHelper;
        this.userService = userService;
        this.messageHelper = messageHelper;
    }
}

