/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.application.plusproxy;

import com.suncode.pwfl.administration.application.plusproxy.EditPlusProxyApplicationDto;
import com.suncode.pwfl.administration.application.plusproxy.PlusProxyApplicationDto;
import com.suncode.pwfl.administration.application.plusproxy.PlusProxyApplicationException;
import com.suncode.pwfl.administration.application.plusproxy.PlusProxyApplicationNotFoundException;
import com.suncode.pwfl.administration.application.plusproxy.PlusProxyApplicationService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/applicationManagement/plusproxy"})
public class PlusProxyApplicationController {
    private static final Logger log = LoggerFactory.getLogger(PlusProxyApplicationController.class);
    private final PlusProxyApplicationService plusProxyApplicationService;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    private List<PlusProxyApplicationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.plusProxyApplicationService.getAll().stream().sorted(Comparator.comparing(applicationDto -> StringUtils.lowerCase((String)applicationDto.name()))).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    private PlusProxyApplicationDto getById(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return (PlusProxyApplicationDto)this.plusProxyApplicationService.findById(id).orElseThrow(() -> new PlusProxyApplicationNotFoundException(id));
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    private PlusProxyApplicationDto create(@RequestBody PlusProxyApplicationDto newApplicationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PLUS_PROXY_APPLICATION).params(new AuditParamsBuilder().param("id", (Object)newApplicationDto.id()).param("name", (Object)newApplicationDto.name()).param("url", (Object)newApplicationDto.url()).param("defaultConfiguration", (Object)newApplicationDto.defaultConfiguration()).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            PlusProxyApplicationDto createdApplication = this.plusProxyApplicationService.create(newApplicationDto);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return createdApplication;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    private PlusProxyApplicationDto update(@PathVariable String id, @RequestBody EditPlusProxyApplicationDto applicationDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_PLUS_PROXY_APPLICATION).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            PlusProxyApplicationDto applicationBeforeUpdate = (PlusProxyApplicationDto)this.plusProxyApplicationService.findById(id).orElseThrow(() -> new PlusProxyApplicationNotFoundException(id));
            auditParamsBuilder.param("name", (Object)this.paramChange(applicationBeforeUpdate.name(), applicationDto.name())).param("url", (Object)this.paramChange(applicationBeforeUpdate.url(), applicationDto.url())).param("defaultConfiguration", (Object)this.paramChange(applicationBeforeUpdate.defaultConfiguration(), applicationDto.defaultConfiguration()));
            auditBuilder.params(auditParamsBuilder.build());
            PlusProxyApplicationDto updatedPlusProxyApplication = this.plusProxyApplicationService.update(id, applicationDto);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return updatedPlusProxyApplication;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    private void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PLUS_PROXY_APPLICATION).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.plusProxyApplicationService.delete(id);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private String paramChange(Object oldValue, Object newValue) {
        return String.format("%s;%s", Objects.toString(oldValue, ""), Objects.toString(newValue, ""));
    }

    @ExceptionHandler(value={PlusProxyApplicationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleConfigurationException(PlusProxyApplicationException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={PlusProxyApplicationNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundConfigurationException(PlusProxyApplicationNotFoundException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"plusProxyApplicationService", "authorizationHelper"})
    @Autowired
    public PlusProxyApplicationController(PlusProxyApplicationService plusProxyApplicationService, AuthorizationHelper authorizationHelper) {
        this.plusProxyApplicationService = plusProxyApplicationService;
        this.authorizationHelper = authorizationHelper;
    }
}

