/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.util;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.object.ExportConfig;
import com.suncode.pwfl.audit.util.AuditExtractor;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.PdfTableHeaders;
import java.awt.Color;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class PdfAuditExtractor
extends AuditExtractor {
    private List<Audit> audits;
    private long count;
    private OutputStream outputStream;
    private String title;
    private Document document;
    private PdfWriter writer;
    private BaseFont baseFont;
    private Font font;
    private Paragraph paragraph;
    private Table table;
    private Cell cell;
    private SimpleDateFormat sdf;

    public PdfAuditExtractor(ExportConfig config) {
        super(config);
        this.audits = config.getAudits();
        this.count = config.getCount();
        this.outputStream = config.getOutputStream();
    }

    @Override
    public void extract() throws Exception {
        this.document = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
        this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outputStream);
        this.baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1250", (boolean)true);
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.title = this.getTextTranslation("Elementy_audytowe_systemu_Plus_Workflow");
        this.initPdf();
        if (this.count > 0L) {
            this.addAllAuditsInfo();
            this.addTable();
        } else {
            this.addNoAuditText();
        }
    }

    @Override
    public void close() {
        if (this.document != null) {
            this.document.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void initPdf() throws Exception {
        this.document.open();
        this.document.addAuthor("Plus Workflow");
        this.document.addTitle(this.title);
        this.document.addCreationDate();
        this.font = new Font(this.baseFont, 20.0f, 1, new Color(0, 0, 153));
        this.paragraph = new Paragraph(this.title, this.font);
        this.paragraph.setAlignment(1);
        this.paragraph.setSpacingAfter(30.0f);
        this.document.add((Element)this.paragraph);
    }

    private void addAllAuditsInfo() throws Exception {
        this.font = new Font(this.baseFont, 12.0f, 0, new Color(0, 0, 0));
        this.paragraph = new Paragraph(this.getTextTranslation("Ilosc_audytow") + ": " + this.count, this.font);
        this.paragraph.setAlignment(0);
        this.paragraph.setSpacingAfter(20.0f);
        this.document.add((Element)this.paragraph);
    }

    private void addNoAuditText() throws Exception {
        this.font = new Font(this.baseFont, 20.0f, 1, new Color(0, 0, 0));
        this.paragraph = new Paragraph(this.getTextTranslation("Brak_audytow"), this.font);
        this.paragraph.setAlignment(1);
        this.document.add((Element)this.paragraph);
    }

    private void addTable() throws Exception {
        this.setTableHeaders();
        this.fillTable();
        this.document.add((Element)this.table);
    }

    private void setTableHeaders() throws Exception {
        PdfTableHeaders[] pdfTableHeaders = PdfTableHeaders.values();
        this.table = new Table(pdfTableHeaders.length);
        this.table.setBorderWidth(1.0f);
        this.table.setWidth(100.0f);
        this.table.setBorderColor(new Color(0, 0, 0));
        this.table.setAlignment(1);
        this.table.setPadding(4.0f);
        this.table.setCellsFitPage(true);
        this.font = new Font(this.baseFont, 12.0f, 0, new Color(255, 255, 255));
        for (int i = 0; i < pdfTableHeaders.length; ++i) {
            this.cell = new Cell((Element)new Phrase(this.getTextTranslation(pdfTableHeaders[i].toString()), this.font));
            this.cell.setHeader(true);
            this.cell.setHorizontalAlignment(1);
            this.cell.setVerticalAlignment(5);
            this.cell.setBackgroundColor(new Color(0, 0, 153));
            this.table.addCell(this.cell);
        }
        this.table.endHeaders();
    }

    private void fillTable() throws Exception {
        for (Audit audit : this.audits) {
            this.font = audit.isAuditSuccess() ? new Font(this.baseFont, 10.0f, 0, new Color(0, 0, 0)) : new Font(this.baseFont, 10.0f, 0, new Color(255, 0, 0));
            this.addCell(audit.getUserId());
            this.addCell(this.getAuditTypeTranslation(audit.getAuditType()));
            this.addCell(this.sdf.format(new Date(audit.getAuditStarted())));
            this.addCell(this.sdf.format(new Date(audit.getAuditStopped())));
            this.addCell(AuditTools.getDurationValue(audit.getAuditDuration()));
        }
    }

    private void addCell(String cellValue) throws Exception {
        this.cell = new Cell((Element)new Phrase(cellValue, this.font));
        this.cell.setHorizontalAlignment(1);
        this.table.addCell(this.cell);
    }
}

