/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ProcessDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertDocClassActionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertDocClassActionFormatter.class);
    private final String docclassIdKey = "docclassId";
    private final String nameKey = "actionName";
    private final String sourceKey = "actionSource";
    private final String typeKey = "actionType";
    private final String processOrlUrlKey = "actionProcess";
    private final String runScriptType = "runScript";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String docclassId = map.get("docclassId");
            String name = map.get("actionName");
            String source = map.get("actionSource");
            String type = map.get("actionType");
            String processOrlUrl = map.get("actionProcess");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            DocumentClass documentClass = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)Long.valueOf(docclassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), docclassId);
            }
            formattedMap.put(AuditParamsNames.DOC_CLASS_ACTION_NAME.toString(), name);
            formattedMap.put(AuditParamsNames.DOC_CLASS_ACTION_SOURCE.toString(), this.translateSource(source, locale));
            formattedMap.put(AuditParamsNames.DOC_CLASS_ACTION_TYPE.toString(), this.translateType(type, locale));
            if (StringUtils.equalsIgnoreCase((String)type, (String)"runScript")) {
                formattedMap.put(AuditParamsNames.URL_ADDRESS.toString(), processOrlUrl);
            } else {
                formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), StringUtils.isBlank((String)processOrlUrl) ? "" : this.getProcessName(processOrlUrl));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String translateSource(String source, Locale locale) {
        if (StringUtils.equals((String)source, (String)"newDocumentInProcess")) {
            return MessageHelper.getMessage((String)"Dodanie_nowego_dokumentu_z_poziomu_procesu", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"newDocumentInArchive")) {
            return MessageHelper.getMessage((String)"Dodanie_nowego_dokumentu_z_poziomu_archiwum", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"changeProcessData")) {
            return MessageHelper.getMessage((String)"Zmiana_danych_w_procesie", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"attachDocument")) {
            return MessageHelper.getMessage((String)"Podlaczenie_dokumentu_z_archiwum", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"dettachDocument")) {
            return MessageHelper.getMessage((String)"Odlaczenie_dokumentu", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"deleteDocumentFromArchive")) {
            return MessageHelper.getMessage((String)"Usuniecie_dokumentu", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)source, (String)"expireDocument")) {
            return MessageHelper.getMessage((String)"Wygasniecie_dokumentu", (Locale)locale, (Object[])new Object[0]);
        }
        return source;
    }

    private String translateType(String type, Locale locale) {
        if (StringUtils.equals((String)type, (String)"createNewProcess")) {
            return MessageHelper.getMessage((String)"Utworzenie_nowego_procesu", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)type, (String)"rewriteIdxFromProcessToDoc")) {
            return MessageHelper.getMessage((String)"Przepisanie_indeksow_z_procesu_do_dokumentu", (Locale)locale, (Object[])new Object[0]);
        }
        if (StringUtils.equals((String)type, (String)"runScript")) {
            return MessageHelper.getMessage((String)"Uruchomienie_skryptu", (Locale)locale, (Object[])new Object[0]);
        }
        return type;
    }

    private String getProcessName(String processDefId) {
        ProcessDef processDef = new ProcessDef(processDefId);
        return processDef.getProcessName();
    }
}

