/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.google.common.cache.Cache;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.dynamic.ProcessSearchView;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewService;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewType;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.support.form.cache.SearchFormCachedItem;
import com.suncode.pwfl.web.support.form.cache.SearchResultActions;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ProcessSearchViewAction
extends Action {
    private static final ProcessSearchViewService processSearchViewService = (ProcessSearchViewService)SpringContext.getBean(ProcessSearchViewService.class);
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String processDefId = request.getParameter("processDefId");
        String viewType = request.getParameter("viewType");
        if (StringUtils.isBlank((CharSequence)processDefId) || StringUtils.isBlank((CharSequence)viewType)) {
            throw new IllegalArgumentException(MessageHelper.getMessage((String)"Niepoprawne_kryteria_wyszukiwania_widoku_dynamicznego"));
        }
        ProcessSearchViewType processSearchViewType = ProcessSearchViewType.valueOf((String)viewType);
        Optional processSearchView = processSearchViewService.findViewForProcessDefIdAndType(processDefId, processSearchViewType);
        if (!processSearchView.isPresent()) {
            throw new RuntimeException();
        }
        String encodedSearchFormModel = processSearchViewService.encodeSearchFormModel((ProcessSearchView)processSearchView.get());
        Cache<String, SearchFormCachedItem> cache = searchFormCache.getCache(request.getSession(false));
        ConcurrentMap sessionCache = cache.asMap();
        String searchId = UUID.randomUUID().toString();
        sessionCache.put(searchId, new SearchFormCachedItem(encodedSearchFormModel, Collections.emptyList(), new SearchResultActions(false, false, false)));
        return new ActionForward(String.format("NewAdvanceProcessSearch.do?searchId=%s&searchFormModel", searchId, encodedSearchFormModel), true);
    }
}

