/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.files.FileVersionsManager;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionCallbackWithoutResult;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.springframework.transaction.TransactionStatus;

public class CheckAppendicesServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(CheckAppendicesServlet.class);
    private static final long serialVersionUID = 68439232322321326L;

    public void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        SharkTransactionTemplate transaction = new SharkTransactionTemplate();
        try {
            transaction.execute((SharkTransactionCallback)new SharkTransactionCallbackWithoutResult(){

                public void doInSharkTransactionWithoutResult(SharkTransaction transaction, TransactionStatus status) throws Exception {
                    CheckAppendicesServlet.this.doCheckAppendices(req, resp, transaction);
                }
            });
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doCheckAppendices(HttpServletRequest req, HttpServletResponse resp, SharkTransaction transaction) throws Exception {
        String processId = req.getParameter("processId");
        String activityId = req.getParameter("activityId");
        String username = req.getSession().getAttribute("username").toString();
        log.info((Object)("Rozpoczynam sprawdzanie pod\u0142\u0105czonych za\u0142\u0105cznik\u00f3w do zadania: " + activityId + " w procesie: " + processId));
        WfActivity activity = SharkFunctions.getWfActivity((SharkTransaction)transaction, (String)processId, (String)activityId);
        Map activityContext = SharkFunctions.GetActivityContext((SharkTransaction)transaction, (WfActivity)activity);
        List<String> reqClasses = this.getRequiredClasses(processId, activityId, transaction);
        List<String> attachedDocs = this.getAttachedDocs(activityContext);
        List<String> missesDocClasses = this.doMagic(reqClasses, attachedDocs, username);
        log.info((Object)("Brakuje za\u0142\u0105cznik\u00f3w z klas: " + missesDocClasses));
        PrintWriter writer = resp.getWriter();
        writer.write(GsonFactory.getGson().toJson(missesDocClasses));
    }

    private List<String> getAttachedDocs(Map<String, Object> map) {
        log.info((Object)"Pobieram liste za\u0142\u0105czonych dokument\u00f3w do zadania");
        String docs = (String)map.get("DocIds");
        if (docs == null || docs.equals("")) {
            return new ArrayList<String>();
        }
        String[] splittedDocs = docs.split(",");
        ArrayList<String> docsList = new ArrayList<String>();
        for (String string : splittedDocs) {
            docsList.add(string);
        }
        log.info((Object)("Znaleziono: " + docsList));
        return docsList;
    }

    private List<String> getRequiredClasses(String processId, String activityId, SharkTransaction tx) throws BaseException {
        log.info((Object)("Poszukuj\u0119 wymaganych klas za\u0142\u0105cznik\u00f3w dla zadania: " + activityId));
        AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
        String[][] extAttr = adminMisc.getActivitiesExtendedAttributeNameValuePairs(tx, processId, activityId);
        ArrayList<String> result = new ArrayList<String>();
        for (String[] attrArray : extAttr) {
            String[] requiredClasses;
            if (!attrArray[0].equals("CHECK_APPENDICES")) continue;
            for (String docClass : requiredClasses = attrArray[1].split("\n")) {
                result.add(docClass);
            }
        }
        log.info((Object)("Znaleziono: " + result));
        return result;
    }

    private List<String> doMagic(List<String> classes, List<String> documents, String username) {
        ArrayList<String> missedClasses = new ArrayList<String>();
        FilesManager fileManager = new FilesManager();
        block0: for (String docClass : classes) {
            DBManagement dbm = new DBManagement();
            DocClassTable docClassTable = dbm.getDocClassByName(docClass);
            for (String doc : documents) {
                FileVersionsManager fvm;
                DocumentData documentData;
                log.info((Object)("Pobieram info o pliku o ID:" + doc));
                Files file = fileManager.GetFile(new Long(doc));
                if (file == null || (documentData = DBManagement.GetDocumentByFileId((String)docClassTable.getId().toString(), (String)doc)) == null && (documentData = (fvm = new FileVersionsManager()).findNewestVersion(file.getId(), username, String.valueOf(docClassTable.getId()))) == null) continue;
                continue block0;
            }
            missedClasses.add(docClass);
        }
        return missedClasses;
    }
}

