/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.structure.organizationalUnit;

import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.form.stereotype.Setter;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.OrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import java.beans.ConstructorProperties;
import java.util.Optional;

@Setter
public class StructureOrganizationalUnitDto {
    private Long id;
    private String name;
    private String translatedName;
    private String symbol;
    private OrganizationalUnitDto higherOrganizationalUnit;
    private PositionDto director;

    public static StructureOrganizationalUnitDto from(OrganizationalUnit organizationalUnit) {
        StructureService structureService = ServiceFactory.getStructureService();
        return StructureOrganizationalUnitDto.builder().id(organizationalUnit.getId()).name(organizationalUnit.getName()).translatedName(structureService.getOrganizationalUnitTranslation(organizationalUnit.getId(), TranslatedFieldType.NAME)).symbol(organizationalUnit.getSymbol()).higherOrganizationalUnit(Optional.ofNullable(organizationalUnit.getHigherOrganizationalUnit()).map(OrganizationalUnitDto::from).orElse(null)).director(Optional.ofNullable(organizationalUnit.getDirectorPosition()).map(PositionDto::fromDomain).orElse(null)).build();
    }

    @ConstructorProperties(value={"id", "name", "translatedName", "symbol", "higherOrganizationalUnit", "director"})
    StructureOrganizationalUnitDto(Long id, String name, String translatedName, String symbol, OrganizationalUnitDto higherOrganizationalUnit, PositionDto director) {
        this.id = id;
        this.name = name;
        this.translatedName = translatedName;
        this.symbol = symbol;
        this.higherOrganizationalUnit = higherOrganizationalUnit;
        this.director = director;
    }

    public static StructureOrganizationalUnitDtoBuilder builder() {
        return new StructureOrganizationalUnitDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public OrganizationalUnitDto getHigherOrganizationalUnit() {
        return this.higherOrganizationalUnit;
    }

    public PositionDto getDirector() {
        return this.director;
    }

    public static class StructureOrganizationalUnitDtoBuilder {
        private Long id;
        private String name;
        private String translatedName;
        private String symbol;
        private OrganizationalUnitDto higherOrganizationalUnit;
        private PositionDto director;

        StructureOrganizationalUnitDtoBuilder() {
        }

        public StructureOrganizationalUnitDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StructureOrganizationalUnitDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StructureOrganizationalUnitDtoBuilder translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public StructureOrganizationalUnitDtoBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public StructureOrganizationalUnitDtoBuilder higherOrganizationalUnit(OrganizationalUnitDto higherOrganizationalUnit) {
            this.higherOrganizationalUnit = higherOrganizationalUnit;
            return this;
        }

        public StructureOrganizationalUnitDtoBuilder director(PositionDto director) {
            this.director = director;
            return this;
        }

        public StructureOrganizationalUnitDto build() {
            return new StructureOrganizationalUnitDto(this.id, this.name, this.translatedName, this.symbol, this.higherOrganizationalUnit, this.director);
        }

        public String toString() {
            return "StructureOrganizationalUnitDto.StructureOrganizationalUnitDtoBuilder(id=" + this.id + ", name=" + this.name + ", translatedName=" + this.translatedName + ", symbol=" + this.symbol + ", higherOrganizationalUnit=" + this.higherOrganizationalUnit + ", director=" + this.director + ")";
        }
    }
}

