/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.gadget.mostUsed;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.entities.MostUsed;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.entities.MostUsedBanned;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.service.MostUsedBannedService;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.service.MostUsedService;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.tile.MostUsedTileDto;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.tile.MostUsedToTileConverterService;
import com.suncode.pwfl.dashboard.internal.gadget.mostUsed.tile.TileConversionException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mostUsed"})
public class MostUsedController {
    private static final Logger log = LoggerFactory.getLogger(MostUsedController.class);
    @Autowired
    private MostUsedService mostUsedService;
    @Autowired
    private MostUsedBannedService mostUsedBannedService;
    @Autowired
    private MostUsedToTileConverterService mostUsedToTileConverterService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public List<MostUsedTileDto> getMostUsed(@RequestParam(required=false) Integer limit) {
        List mostUsedList = this.mostUsedService.getMostUsedByUser(UserContext.current().getUser().getUserName(), Integer.valueOf(0), limit);
        return mostUsedList.stream().map(mostUsed -> {
            try {
                return this.mostUsedToTileConverterService.convert(mostUsed);
            }
            catch (TileConversionException e) {
                log.warn("B\u0142\u0105d podczas konwersji kafelka: " + e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/ban/{id}"})
    public void banMostUsed(@PathVariable Long id) {
        MostUsed mostUsed = (MostUsed)this.mostUsedService.get((Serializable)id);
        MostUsedBanned mostUsedBanned = MostUsedBanned.builder().userId(mostUsed.getUserId()).type(mostUsed.getType()).param(mostUsed.getParam()).build();
        this.mostUsedBannedService.saveIfNotExists(mostUsedBanned);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/ban/reset"})
    public void resetBanned() {
        String userId = UserContext.current().getUser().getUserName();
        this.mostUsedBannedService.resetForUser(userId);
    }
}

