/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates;

import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Maps;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.certificates.dto.CertificateDto;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertificateControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(CertificateControllerHelper.class);
    @Autowired
    private ExportService exportService;
    final char[] EXPORT_KEYSTORE_PASSWORD = "changeit".toCharArray();

    CountedResult<CertificateDto> getExtended(Map<String, Certificate> certificates, Integer start, Integer limit, String orderBy, SortDirection orderDirection) {
        List certificateDtos = certificates.entrySet().stream().map(Maps.entryFold(CertificateDto::new)).sorted(DtoComparator.of(CertificateDto.class, (String)orderBy, (SortDirection)orderDirection)).collect(Collectors.toList());
        return Paginator.forAll(certificateDtos).viewPageByOffset(start, limit);
    }

    void exportCertificatesDto(HttpServletResponse response, String extension, String title, CountedResult<CertificateDto> result) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa_aliasu")).data(result.getData()).by(CertificateDto::getAlias).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Nazwa_domeny")).data(result.getData()).by(CertificateDto::getSubjectDN).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Wydawca_domeny")).data(result.getData()).by(CertificateDto::getIssuerDN).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Data_utworzenia")).data(result.getData()).by(CertificateDto::formatFromDateField).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Data_wygasniecia")).data(result.getData()).by(CertificateDto::formatToDateField).build(), ExportColumnBuilder.create().name(MessageHelper.getMessage((String)"Sygnatura_certyfikatu")).data(result.getData()).by(CertificateDto::getSignature).build());
        ExportModel model = ExportModel.builder().title(title).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }
}

