/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.ProcessCalendar;
import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.event.CreateProcessCalendarEvent;
import com.suncode.pwfl.calendar.event.ModifyProcessCalendarEvent;
import com.suncode.pwfl.calendar.process.api.ProcessCalendarService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.ProcessCalendarDto;
import com.suncode.pwfl.web.dto.calendar.ProcessEventResult;
import com.suncode.pwfl.web.dto.calendar.event.ProcessCalendarEventDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import com.suncode.pwfl.web.support.form.cache.MissingSearchCriteriaException;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.workflow.form.validator.error.ValidationException;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"calendar/process"})
@Api(hidden=true)
public class ProcessCalendarController {
    private static final Logger log = LoggerFactory.getLogger(ProcessCalendarController.class);
    private final CalendarFacade calendarFacade;
    private final UserService userService;
    private final CalendarMapper calendarMapper;
    private final ProcessCalendarService processCalendarService;
    private final SearchFormCache searchFormCache;
    private final MessageHelperBean messageHelperBean;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarDto createProcessCalendar(@RequestBody ProcessCalendarDto calendarDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS_CALENDAR);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendar processCalendar = this.calendarMapper.toProcessCalendar(calendarDto);
            processCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromProcessCalendar(processCalendar));
            ProcessCalendar createdCalendar = (ProcessCalendar)this.calendarFacade.createCalendar((Calendar)processCalendar);
            auditParamsBuilder.params(this.paramsFromProcessCalendar(createdCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)createdCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public CalendarDto updateProcessCalendar(@PathVariable Long id, @RequestBody ProcessCalendarDto calendarDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_PROCESS_CALENDAR);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendar processCalendar = this.calendarMapper.toProcessCalendar(calendarDto);
            processCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromProcessCalendar(processCalendar));
            ProcessCalendar oldProcessCalendar = (ProcessCalendar)this.processCalendarService.getCalendar(id, user);
            ProcessCalendar updatedCalendar = (ProcessCalendar)this.calendarFacade.updateCalendar(id.longValue(), (Calendar)processCalendar);
            auditParamsBuilder.params(this.paramsFromProcessCalendar(oldProcessCalendar, updatedCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)updatedCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteProcessCalendar(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR).params(new AuditParamsBuilder().param("id", (Object)id).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            ProcessCalendar processCalendar = new ProcessCalendar(id);
            this.calendarFacade.deleteCalendar((Calendar)processCalendar, user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"{calendarId}/events"})
    public List<ProcessCalendarEventDto> getEventsForProcessCalendar(@PathVariable Long calendarId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime, @RequestParam(required=false) String searchId, @RequestParam(name="timeZone", required=false, defaultValue="UTC") String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        ProcessCalendar calendar = new ProcessCalendar(calendarId);
        SearchFormModelDto searchFormModel = searchId == null ? null : this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelperBean.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        return this.processCalendarService.getEventsForCalendarByInterval(calendar.getId(), user, fromDateTime, toDateTime, searchFormModel, timeZone).stream().map(this.calendarMapper::toProcessCalendarEventDto).toList();
    }

    @PostMapping(value={"{calendarId}/events"})
    public CreateProcessResult createProcessCalendarEvent(@PathVariable Long calendarId, @RequestBody CreateProcessCalendarEvent createProcessCalendarEvent) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.processCalendarService.createProcessCalendarEvent(calendarId.longValue(), user, createProcessCalendarEvent);
    }

    @PatchMapping(value={"{calendarId}/events"})
    public ProcessEventResult updateProcessCalendarEvent(@PathVariable Long calendarId, @RequestBody ModifyProcessCalendarEvent modifyProcessCalendarEvent) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        this.processCalendarService.updateProcessCalendarEvent(calendarId.longValue(), user, modifyProcessCalendarEvent);
        return new ProcessEventResult(true);
    }

    @Nullable
    @GetMapping(value={"{calendarId}/share/link"})
    public String getCalendarShareLink(@PathVariable Long calendarId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Calendar calendar = this.calendarFacade.getCalendarForUser((Calendar)new ProcessCalendar(calendarId), user);
        return calendar.getShareLinkId() != null ? this.buildShareCalendarUrl(calendar.getShareLinkId()) : null;
    }

    @GetMapping(value={"{calendarId}/share/link/generate"})
    public String generateCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_GENERATE_PROCESS_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendar processCalendar = (ProcessCalendar)this.processCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("name", (Object)processCalendar.getName());
            String shareLinkId = this.calendarFacade.generateCalendarShareLink((Calendar)new ProcessCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.buildShareCalendarUrl(shareLinkId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarId}/share/link"})
    public RestResult deleteCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PROCESS_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ProcessCalendar processCalendar = (ProcessCalendar)this.processCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("name", (Object)processCalendar.getName());
            this.calendarFacade.deleteCalendarShareLink((Calendar)new ProcessCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"share/link/{shareLinkId}"})
    public ResponseEntity<byte[]> getCalendarIcalResource(@PathVariable String shareLinkId) {
        net.fortuna.ical4j.model.Calendar icalCalendar = this.calendarFacade.buildIcalCalendar((Calendar)new ProcessCalendar(shareLinkId));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(icalCalendar, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Error on creating ICS file for resource " + shareLinkId, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        byte[] icalBytes = byteArrayOutputStream.toByteArray();
        String fileFormat = ".ics";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"text/calendar"));
        headers.setContentDispositionFormData("attachment", shareLinkId + ".ics");
        return new ResponseEntity((Object)icalBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String buildShareCalendarUrl(String shareLinkId) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/calendar/process/share/link/{shareLinkId}").buildAndExpand(new Object[]{shareLinkId}).toUriString();
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ProcessEventResult handleValidationException(ValidationException e) {
        log.info(e.getMessage(), (Throwable)e);
        return new ProcessEventResult(false, null, e.getErrors());
    }

    private Map<String, Object> paramsFromProcessCalendar(ProcessCalendar processCalendar) {
        return new AuditParamsBuilder().param("name", (Object)StringUtils.defaultString((String)processCalendar.getName())).param("color", (Object)StringUtils.defaultString((String)processCalendar.getColor())).param("processDefId", (Object)StringUtils.defaultString((String)processCalendar.getProcessDefId())).param("variableIdStartDateTime", (Object)StringUtils.defaultString((String)processCalendar.getVariableIdStartDateTime())).param("variableIdEndDateTime", (Object)StringUtils.defaultString((String)processCalendar.getVariableIdEndDateTime())).param("durationMinutes", (Object)Optional.ofNullable(processCalendar.getDurationMinutes()).map(String::valueOf).orElse("")).param("allDay", (Object)processCalendar.isAllDay()).param("nameTemplate", (Object)StringUtils.defaultString((String)processCalendar.getNameTemplate())).param("nameTemplateMonth", (Object)StringUtils.defaultString((String)processCalendar.getNameTemplateMonth())).param("nameTemplateWeek", (Object)StringUtils.defaultString((String)processCalendar.getNameTemplateWeek())).param("nameTemplateDay", (Object)StringUtils.defaultString((String)processCalendar.getNameTemplateDay())).param("descriptionTemplate", (Object)StringUtils.defaultString((String)processCalendar.getDescriptionTemplate())).param("allowWorkdays", (Object)processCalendar.getProcessCreateRestriction().allowWorkdays()).param("allowSaturdays", (Object)processCalendar.getProcessCreateRestriction().allowSaturdays()).param("allowHolidays", (Object)processCalendar.getProcessCreateRestriction().allowHolidays()).param("processCreateType", (Object)Optional.ofNullable(processCalendar.getProcessCreateType()).map(Enum::name).orElse("")).param("criteria", (Object)StringUtils.defaultString((String)this.getCriteria(processCalendar))).build();
    }

    private Map<String, Object> paramsFromProcessCalendar(ProcessCalendar oldProcessCalendar, ProcessCalendar newProcessCalendar) {
        return new AuditParamsBuilder().param("name", (Object)StringUtils.defaultString((String)oldProcessCalendar.getName()), (Object)StringUtils.defaultString((String)newProcessCalendar.getName())).param("color", (Object)StringUtils.defaultString((String)oldProcessCalendar.getColor()), (Object)StringUtils.defaultString((String)newProcessCalendar.getColor())).param("processDefId", (Object)StringUtils.defaultString((String)oldProcessCalendar.getProcessDefId()), (Object)StringUtils.defaultString((String)newProcessCalendar.getProcessDefId())).param("variableIdStartDateTime", (Object)StringUtils.defaultString((String)oldProcessCalendar.getVariableIdStartDateTime()), (Object)StringUtils.defaultString((String)newProcessCalendar.getVariableIdStartDateTime())).param("variableIdEndDateTime", (Object)StringUtils.defaultString((String)oldProcessCalendar.getVariableIdEndDateTime()), (Object)StringUtils.defaultString((String)newProcessCalendar.getVariableIdEndDateTime())).param("durationMinutes", (Object)Optional.ofNullable(oldProcessCalendar.getDurationMinutes()).map(String::valueOf).orElse(""), (Object)Optional.ofNullable(newProcessCalendar.getDurationMinutes()).map(String::valueOf).orElse("")).param("allDay", (Object)oldProcessCalendar.isAllDay(), (Object)newProcessCalendar.isAllDay()).param("nameTemplate", (Object)StringUtils.defaultString((String)oldProcessCalendar.getNameTemplate()), (Object)StringUtils.defaultString((String)newProcessCalendar.getNameTemplate())).param("nameTemplateMonth", (Object)StringUtils.defaultString((String)oldProcessCalendar.getNameTemplateMonth()), (Object)StringUtils.defaultString((String)newProcessCalendar.getNameTemplateMonth())).param("nameTemplateWeek", (Object)StringUtils.defaultString((String)oldProcessCalendar.getNameTemplateWeek()), (Object)StringUtils.defaultString((String)newProcessCalendar.getNameTemplateWeek())).param("nameTemplateDay", (Object)StringUtils.defaultString((String)oldProcessCalendar.getNameTemplateDay()), (Object)StringUtils.defaultString((String)newProcessCalendar.getNameTemplateDay())).param("descriptionTemplate", (Object)StringUtils.defaultString((String)oldProcessCalendar.getDescriptionTemplate()), (Object)StringUtils.defaultString((String)newProcessCalendar.getDescriptionTemplate())).param("allowWorkdays", (Object)oldProcessCalendar.getProcessCreateRestriction().allowWorkdays(), (Object)newProcessCalendar.getProcessCreateRestriction().allowWorkdays()).param("allowSaturdays", (Object)oldProcessCalendar.getProcessCreateRestriction().allowSaturdays(), (Object)newProcessCalendar.getProcessCreateRestriction().allowSaturdays()).param("allowHolidays", (Object)oldProcessCalendar.getProcessCreateRestriction().allowHolidays(), (Object)newProcessCalendar.getProcessCreateRestriction().allowHolidays()).param("processCreateType", (Object)Optional.ofNullable(oldProcessCalendar.getProcessCreateType()).map(Enum::name).orElse(""), (Object)Optional.ofNullable(newProcessCalendar.getProcessCreateType()).map(Enum::name).orElse("")).param("criteria", (Object)StringUtils.defaultString((String)this.getCriteria(oldProcessCalendar)), (Object)StringUtils.defaultString((String)this.getCriteria(newProcessCalendar))).build();
    }

    private String getCriteria(ProcessCalendar processCalendar) {
        return Optional.ofNullable(processCalendar.getCriteria()).stream().flatMap(Collection::stream).map(critter -> critter.getType().name() + " " + critter.getVariableId() + " " + critter.getOperator().name() + " " + critter.getValue()).collect(Collectors.joining("\n"));
    }

    @ConstructorProperties(value={"calendarFacade", "userService", "calendarMapper", "processCalendarService", "searchFormCache", "messageHelperBean"})
    @Autowired
    public ProcessCalendarController(CalendarFacade calendarFacade, UserService userService, CalendarMapper calendarMapper, ProcessCalendarService processCalendarService, SearchFormCache searchFormCache, MessageHelperBean messageHelperBean) {
        this.calendarFacade = calendarFacade;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
        this.processCalendarService = processCalendarService;
        this.searchFormCache = searchFormCache;
        this.messageHelperBean = messageHelperBean;
    }
}

