/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.suncode.plugin.framework.Module;
import com.suncode.plugin.framework.ModuleAccessor;
import com.suncode.plugin.framework.defaultView.DefaultView;
import com.suncode.plugin.framework.web.DefaultViewModule;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.view.ViewService;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class UserSettingsHelper {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsHelper.class);
    private static final String DOC_CLASS_PREFIX = "docclass_";
    private static final String LINK_PREFIX = "link_";
    private static final String MY_VIEW_PREFIX = "myview_";
    private static final String DATA_VIEW_PREFIX = "data-view";
    private final ViewService viewService;
    private final DocumentClassService documentClassService;
    private final ModuleAccessor moduleAccessor;
    private final LinkService linkService;
    private final MessageHelperBean messageHelper;

    String getDefaultViewName(AtomicReference<String> defaultViewAtomic) {
        String defaultView = defaultViewAtomic.get();
        if (StringUtils.isNotBlank((String)defaultView)) {
            switch (defaultView) {
                case "dashboard": {
                    return this.messageHelper.getMessage("dashboard.label");
                }
                case "admin": {
                    return this.messageHelper.getMessage("Administracja");
                }
                case "task": {
                    return this.messageHelper.getMessage("Skrzynka_zadan");
                }
                case "createprocess": {
                    return this.messageHelper.getMessage("Nowy_proces");
                }
                case "archive": {
                    return this.messageHelper.getMessage("Archiwum_dokumentow");
                }
                case "docclasses": {
                    return this.messageHelper.getMessage("Klasy_dokumentow");
                }
                case "links": {
                    return this.messageHelper.getMessage("Zestawy_dokumentow");
                }
                case "calendar": {
                    return this.messageHelper.getMessage("Moj_kalendarz");
                }
                case "searchprocess": {
                    return this.messageHelper.getMessage("Znajdz_proces");
                }
                case "stats": {
                    return this.messageHelper.getMessage("Statystyki");
                }
                case "myviews": {
                    return this.messageHelper.getMessage("Moje_widoki");
                }
            }
            if (defaultView.startsWith(DOC_CLASS_PREFIX)) {
                return this.getDefaultViewNameForDocClass(defaultView, defaultViewAtomic);
            }
            if (defaultView.startsWith(LINK_PREFIX)) {
                return this.getDefaultViewNameForLink(defaultView, defaultViewAtomic);
            }
            if (defaultView.startsWith(MY_VIEW_PREFIX)) {
                return this.getDefaultViewNameForMyView(defaultView, defaultViewAtomic);
            }
            if (defaultView.startsWith(DATA_VIEW_PREFIX)) {
                return this.getDefaultViewNameForDataView(defaultView);
            }
            return this.getDefaultViewNameFromPlugin(defaultView);
        }
        return "";
    }

    private String getDefaultViewNameForDocClass(String defaultView, AtomicReference<String> defaultViewAtomic) {
        String[] sId = defaultView.split("_");
        if (sId.length == 0) {
            return "";
        }
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(Long.parseLong(sId[1])));
        if (documentClass == null) {
            log.info("Nie znaleziono klasy dokument\u00f3w o id: " + sId[1]);
            defaultViewAtomic.set("");
            return "";
        }
        return this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME);
    }

    private String getDefaultViewNameForLink(String defaultView, AtomicReference<String> defaultViewAtomic) {
        String[] sId = defaultView.split("_");
        if (sId.length == 0) {
            return "";
        }
        Link link = this.linkService.getLink(Long.valueOf(sId[1]), new String[0]);
        if (link == null) {
            log.info("Nie znaleziono zestawu dokument\u00f3w o id: " + sId[1]);
            defaultViewAtomic.set("");
            return "";
        }
        return this.linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME);
    }

    private String getDefaultViewNameForMyView(String defaultView, AtomicReference<String> defaultViewAtomic) {
        String[] sId = defaultView.split("_");
        if (sId.length == 0) {
            return "";
        }
        UserSearchViewTable userView = new DBManagement().getUserSearchView(sId[1]);
        if (userView == null) {
            log.info("Nie znaleziono widoku o id: " + sId[1]);
            defaultViewAtomic.set("");
            return "";
        }
        return this.viewService.getViewTranslation(userView.getId(), TranslatedFieldType.NAME);
    }

    private String getDefaultViewNameForDataView(String defaultViewId) {
        if (StringUtils.isEmpty((String)defaultViewId)) {
            return "";
        }
        Module module = this.moduleAccessor.getModule("com.suncode.plugin-data-viewer:default-view", DefaultView.class);
        if (module == null) {
            return "";
        }
        if (module.getObject() != null) {
            return ((DefaultView)module.getObject()).name();
        }
        DefaultViewModule defaultViewModule = (DefaultViewModule)module;
        return defaultViewModule.getDefaultViewProvider().getDefaultViewsForUser(UserContext.current().getUser().getUserName()).stream().filter(defaultView -> defaultView.id().equals(defaultViewId)).findFirst().map(DefaultView::name).orElse("");
    }

    private String getDefaultViewNameFromPlugin(String defaultView) {
        if (StringUtils.isEmpty((String)defaultView)) {
            return "";
        }
        Module module = this.moduleAccessor.getModule(defaultView, DefaultView.class);
        if (module == null || module.getObject() == null) {
            return "";
        }
        return ((DefaultView)module.getObject()).name();
    }

    @ConstructorProperties(value={"viewService", "documentClassService", "moduleAccessor", "linkService", "messageHelper"})
    public UserSettingsHelper(ViewService viewService, DocumentClassService documentClassService, ModuleAccessor moduleAccessor, LinkService linkService, MessageHelperBean messageHelper) {
        this.viewService = viewService;
        this.documentClassService = documentClassService;
        this.moduleAccessor = moduleAccessor;
        this.linkService = linkService;
        this.messageHelper = messageHelper;
    }
}

