/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processVariables;

import com.suncode.pwfl.administration.processVariables.ProcessVariableDto;
import com.suncode.pwfl.administration.processVariables.ProcessVariablesService;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processVariables"})
public class ProcessVariablesController {
    private static final Logger log = LoggerFactory.getLogger(ProcessVariablesController.class);
    private final ProcessVariablesService processVariablesService;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public CountedResult<ProcessVariableDto> getProcessVariables(@RequestParam String processDefId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List variableDtos = this.processVariablesService.getProcessVariables(processDefId).stream().sorted(DtoComparator.of(ProcessVariableDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(variableDtos).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    @ResponseBody
    public void exportProcessVariables(HttpServletResponse response, @PathVariable String extension, @RequestParam String processDefId, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<ProcessVariableDto> variableDtos = this.processVariablesService.getProcessVariables(processDefId).stream().sorted(DtoComparator.of(ProcessVariableDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn("Nazwa", variableDtos, ProcessVariableDto::getVariableName), this.buildExportColumn("Identyfikator", variableDtos, ProcessVariableDto::getVariableId), this.buildExportColumn("Typ", variableDtos, ProcessVariableDto::getType), this.buildExportColumn("Typ_tablicowy", variableDtos, variableDto -> this.messageHelper.getMessage(variableDto.getIsArray() != false ? "Tak" : "Nie")));
        ExportModel exportModel = ExportModel.builder().title(this.messageHelper.getMessage("Zmienne_procesu")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(exportModel, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<ProcessVariableDto> data, Function<ProcessVariableDto, String> supplier) {
        return ExportColumnBuilder.create().name(this.messageHelper.getMessage(name)).data(data).by(supplier).build();
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"processVariablesService", "exportService", "messageHelper", "authorizationHelper"})
    @Autowired
    public ProcessVariablesController(ProcessVariablesService processVariablesService, ExportService exportService, MessageHelperBean messageHelper, AuthorizationHelper authorizationHelper) {
        this.processVariablesService = processVariablesService;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.authorizationHelper = authorizationHelper;
    }
}

