/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.CollatorInstance;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.workflow.activity.ActivityStatusType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.displaytag.util.ParamEncoder;

public class ShowUserViewsAction
extends Action {
    public static final Logger LOG = Logger.getLogger(ShowUserViewsAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LOG.trace((Object)"******************** ShowUserViewsAction ********************");
        try {
            int rights;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String sUserName = (String)session.getAttribute("username");
            if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.OPTIONAL_VIEWS_RIGHT).booleanValue() && (rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().views().build(), (String)sUserName, (boolean)false, (boolean)false)) != 1 && rights != 0) {
                return mapping.findForward("welcome");
            }
            String type = request.getParameter("type");
            if (type == null) {
                request.setAttribute("ViewPrivate", (Object)"true");
                request.setAttribute("ViewPublic", (Object)"true");
                request.setAttribute("ViewAll", (Object)this.showAllViews(sUserName));
                request.setAttribute("activeTab", (Object)"WorkflowViews.do");
                AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OPEN_VIEWS);
                request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
                return mapping.findForward("showUserViews");
            }
            int pageSize = UsersManagement.getUserDefinedPageSize((String)sUserName);
            int totalCount = 0;
            if (type.compareToIgnoreCase("completed") == 0) {
                List statuses;
                ParamEncoder paramEncoder = new ParamEncoder("statusesTable");
                String pageNumber = request.getParameter(paramEncoder.encodeParameterName("p"));
                String orderProperty = request.getParameter(paramEncoder.encodeParameterName("o"));
                String sortProperty = request.getParameter(paramEncoder.encodeParameterName("s"));
                String statusType = request.getParameter("status_type");
                int firstResult = 0;
                if (!Tools.isNullOrEmpty((String)pageNumber)) {
                    firstResult = (Integer.parseInt(pageNumber) - 1) * pageSize;
                }
                boolean orderAscending = false;
                if (!Tools.isNullOrEmpty((String)orderProperty)) {
                    boolean bl = orderAscending = Integer.parseInt(orderProperty) == 2;
                }
                if (Tools.isNullOrEmpty((String)sortProperty)) {
                    sortProperty = "createDate";
                }
                if (Tools.isNullOrEmpty((String)statusType)) {
                    statuses = ActivityStatusManagerExtended.getAllActivitiesCurrentStatusWithNames((String)sUserName, (int)firstResult, (int)pageSize, (String)sortProperty, (boolean)orderAscending);
                    totalCount = ActivityStatusManagerExtended.countAllActivitiesCurrentStatus((String)sUserName).intValue();
                } else {
                    ActivityStatusType[] activityStatusTypes = new ActivityStatusType[]{ActivityStatusType.createActivityStatus((String)statusType)};
                    statuses = ActivityStatusManagerExtended.getActivitiesCurrentStatusWithNames((String)sUserName, (ActivityStatusType[])activityStatusTypes, (int)firstResult, (int)pageSize, (String)sortProperty, (boolean)orderAscending);
                    totalCount = ActivityStatusManagerExtended.countActivitiesCurrentStatus((String)sUserName, (ActivityStatusType[])activityStatusTypes).intValue();
                }
                request.setAttribute("completedTasksView", (Object)"true");
                request.setAttribute("status_type", (Object)statusType);
                request.setAttribute("statuses", (Object)statuses);
                request.setAttribute("pageSize", (Object)pageSize);
                request.setAttribute("totalCount", (Object)totalCount);
                request.setAttribute("firstResult", (Object)firstResult);
            } else {
                DBManagement dbManagement = new DBManagement(request);
                ArrayList alUserViews = null;
                if (type.compareToIgnoreCase("all") == 0) {
                    alUserViews = dbManagement.GetAllUserSearchViews();
                    request.setAttribute("showAllViews", (Object)true);
                } else {
                    alUserViews = dbManagement.GetAllUserSearchViewsForUserWithType(sUserName, type);
                    request.setAttribute("showAllViews", (Object)false);
                }
                if (alUserViews != null) {
                    totalCount = alUserViews.size();
                }
                ViewService viewService = ServiceFactory.getViewService();
                for (UserSearchViewTable userView : alUserViews) {
                    userView.setViewDescr(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.DESCRIPTION));
                    userView.setViewName(viewService.getViewTranslation(userView.getId(), TranslatedFieldType.NAME));
                }
                alUserViews.sort(Comparator.comparing(UserSearchViewTable::getViewName, CollatorInstance.get()));
                request.setAttribute("iMaxPageSize", (Object)String.valueOf(totalCount));
                request.setAttribute("iPageSize", (Object)String.valueOf(pageSize));
                request.setAttribute("alUserViews", (Object)alUserViews);
            }
            boolean tableRequest = Boolean.valueOf(request.getParameter("tableRequest"));
            request.setAttribute("activeTab", (Object)"WorkflowViews.do");
            if (tableRequest) {
                return mapping.findForward("showTypedUserViewsTable");
            }
            return mapping.findForward("showTypedUserViews");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return mapping.findForward("welcome");
        }
    }

    private String showAllViews(String sUserName) {
        String showAllViews = "false";
        try {
            int iRes = Authorization.checkRight((String)"System", (String)sUserName, (boolean)false, (boolean)false);
            if (iRes == 0) {
                showAllViews = "true";
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return showAllViews;
    }
}

