Ext4.define('Suncode.passwordpolicy.view.ProfileConfiguration', {
	extend: 'Ext.form.Panel',

	alias: 'widget.passwordpolicy-profileconfiguration',

	title: PW.t('Konfiguracja_profilu'),

	layout: 'form',

	frame: true,

	bodyPadding: '0 0 0 20',

	fieldDefaults: {
		labelWidth: 400,
		width: 580
	},

	initComponent: function () {
		Ext4.apply(this, {
			items: [{
				xtype: 'passwordpolicy-profileconfigurationform'
			}, {
				id: 'saveButton',
				xtype: 'button',
				text: PW.t('zapisz'),
				iconCls: 'dvnt-icon-save',
				// width: 150,
				scale: 'large',
				handler: this.saveProfile,
				scope: this
			}]
		});

		this.callParent(arguments);
		this.reset();
	},

	reset: function () {
		this.getForm().reset();
		this.setFieldsNotEditable(true);
		this.setFieldsDisabled(true);
		this.setSaveButtonDisabled(true);
	},

	loadProfileConfiguration: function (selectedConfiguration) {
		this.setFieldsDisabled(false);
		this.setFieldsNotEditable(selectedConfiguration.raw.defaultProfile);
		this.setSaveButtonDisabled(selectedConfiguration.raw.defaultProfile);

		var form = this.getForm();
		jQuery.each(selectedConfiguration.raw, function (key, value) {
			var field = form.findField(key);
			if (field) {
				field.setValue(value);
			}
		});

		this.profileId = selectedConfiguration.get('id');
	},

	setFieldsNotEditable: function (notEditable) {
		var fields = this.getForm().getFields();
		fields.items.forEach(function (field) {
			field.setReadOnly(notEditable);
		});
	},

	setFieldsDisabled: function (disabled) {
		var fields = this.getForm().getFields();
		fields.items.forEach(function (field) {
			field.setDisabled(disabled);
		});
	},

	setSaveButtonDisabled: function (disabled) {
		this.items.get('saveButton').setDisabled(disabled);
	},

	saveProfile: function () {
		var me = this;
		var form = this.getForm();

		if (form.isValid()) {
			var fields = form.getFields();
			var data = {
				id: me.profileId
			};

			fields.items.forEach(function (field) {
				var key = field.name;
				var value = field.getValue();
				data[key] = value;
			})

			var mask = new Ext4.LoadMask({
				target: me
			});
			mask.show();

			jQuery.ajax({
				url: 'api/password/policy/profile/update',
				method: 'POST',
				contentType: 'application/json',
				data: JSON.stringify(data),
				complete: function () {
					mask.destroy();
				},
				success: function () {
					me.fireEvent('profilesaved', data.id);
				},
				error: function (response) {
					if (response.responseJSON && response.responseJSON.errorMessage) {
						PW.ui.Message.error(response.responseJSON.errorMessage);
					}
					else {
						PW.ui.Message.error(PW.t('Wystapil_blad_podczas_zapisywania_profilu'));
					}
				}
			});
		}
	}
});
