Ext4.define( 'Suncode.license.view.UploadLicense', {
    extend: 'Ext4.form.Panel',
    alias: 'widget.upload',
    frame: true,
    initComponent: function() {
        this.items = [ {
            xtype: 'filefield',
            fieldLabel: PW.t('fileLicenseLabel'),
            name: 'license',
            buttonText: '',
            emptyText: PW.t('fileChooseLabel'),
            validator: this.validateFile,
            listeners: {
                scope: this,
                change: this.onFileSelected
            },
            // bez tego rozjezdza sie na IE forma
            padding: '0px 1px 0 0px'
        }, {
            xtype: 'container',
            cls: 'fileinfo',
            itemId: 'licenseInfoContainer',
            hidden: true,
            items: [ {
                xtype: 'fieldset',
                title: PW.t('fileInfo'),
                itemId: 'licenseinfo',
                collapsible: true,
                items: [ {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('fileName'),
                    itemId: 'name'
                }, {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('fileSize'),
                    itemId: 'size'
                } ]

            }, {
                height: 276,
                autoScroll: true,
                xtype: 'fieldset',
                title: PW.t('licenseInfo'),
                itemId: 'licensedata',
                collapsible: true,
                items: [ {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('expiredDate'),
                    labelWidth: 250,
                    itemId: 'date'
                }, {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('maxUsers'),
                    labelWidth: 250,
                    itemId: 'maxusers'
                }, {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('loggedUsers'),
                    labelWidth: 250,
                    itemId: 'loggedusers'
                }, {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('maxDefProc'),
                    labelWidth: 250,
                    itemId: 'processesdef'
                }, {
                    xtype: 'displayfield',
                    fieldLabel: PW.t('processesId'),
                    labelWidth: 250,
                    itemId: 'processesid'
                } ]
            }, {
                xtype: 'fieldset',
                itemId: 'lab',
                id: 'lab',
                items: [ {
                    xtype: 'label',
                    itemId: 'msg',
                    cls: 'msg-label'
                }, {
                    xtype: 'label',
                    itemId: 'msg-error',
                    cls: 'msg-label'
                } ]
            } ]
        } ],

        this.buttons = [ {
            text: PW.t('loadLicense'),
            iconCls: 'dvnt-icon-upload',
            handler: this.submitButtonHandler,
            itemId: 'install',
            disabled: true,
            scope: this
        } ],

        this.callParent();
    },

    title: PW.t('formTitle'),

    layout: 'fit',

    collapsible: true,
    defaults: {
        anchor: '90%'
    },

    validateFile: function( value ) {
        if ( value && value.indexOf( ".lic", value.length - 4 ) === -1 ) {
            return PW.t('wrongFile');
        }
        return true;
    },

    onFileSelected: function( field, value ) {
        if ( value ) {
            var form = this.getForm();
            if ( form.isValid() ) {
                form.submit( {
                    url: 'com.suncode.pwfl.servlet.LicensePreview.customServlet',
                    waitMsg: PW.t('processing'),
                    scope: this,
                    success: function( form, action ) {
                        this.updateLicenseInfo( field, action.result );
                    },
                    failure: function( form, action ) {
                        this.processFailure( field, action.result );
                    }
                } );
            } else {
                this.down( '#licenseInfoContainer' ).setVisible( false );
            }
        }
    },

    updateLicenseInfo: function( field, result ) {
        this.getForm().reset();
        this.down( '#lab' ).removeCls( [ 'can-be-loaded', 'cannot-be-loaded' ] );
        var licenseInfo = this.down( '#licenseinfo' );

        licenseInfo.down( '#name' ).setValue( result.data[0].filename );
        licenseInfo.down( '#size' ).setValue( result.data[1].filesize + ' B' );

        if ( result.badfile === false ) {

            var licenseData = this.down( '#licensedata' );

            licenseData.down( '#date' ).setValue( result.data[2].value );
            licenseData.down( '#maxusers' ).setValue( result.data[3].value );
            licenseData.down( '#loggedusers' ).setValue( result.data[4].value );
            licenseData.down( '#processesdef' ).setValue( result.data[5].value );
            licenseData.down( '#processesid' ).setValue( result.data[6].value );
        }
        if ( result.canBeLoaded === true ) {
            this.down( '#lab' ).down( '#msg' ).setText( PW.t('canBeLoaded') );
            this.down( '#lab' ).down( '#msg-error' ).setText( '' );
            this.down( '#lab' ).addCls( 'can-be-loaded' );
            this.down( '#install' ).setDisabled( false );
        } else {
            this.down( '#lab' ).down( '#msg' ).setText( PW.t('cannotBeLoaded') );
            this.down( '#lab' ).down( '#msg-error' ).setText( result.errortext );
            this.down( '#lab' ).addCls( 'cannot-be-loaded' );
            this.down( '#install' ).setDisabled( true );
        }
        this.down( '#licenseInfoContainer' ).setVisible( true );
        this.doLayout();
    },

    processFailure: function( field, result ) {
        this.down( '#install' ).setDisabled( true );
        this.down( '#licenseInfoContainer' ).setVisible( false );
    },

    submitButtonHandler: function( button, eventObject ) {
        this.onStart();

        Ext4.Ajax.request( {
            scope: this,
            url: 'com.suncode.pwfl.servlet.LicenseLoad.customServlet',
            waitMsg: PW.t('fileUploadWaitMsg'),
            success: function( form, action ) {
                this.onFinish();
                var data = Ext4.decode( form.responseText );
                if ( data.success === true ) {
                    Ext4.getCmp( 'restrictions' ).getStore().reload();
                    Ext4.Msg.show( {
                        title: PW.t('successText'),
                        msg: PW.t('successMsg'),
                        buttons: Ext4.Msg.OK,
                        icon: Ext4.MessageBox.INFO,
                        width: 450,
                        fn: function() {
                            window.location = 'Logout.do';
                        }
                    } );
                } else {
                    Ext4.Msg.show( {
                        title: PW.t('errorText'),
                        msg: PW.t('errorMsg'),
                        buttons: Ext4.Msg.OK,
                        icon: Ext4.MessageBox.ERROR
                    } );
                }
            },
            failure: function( form, action ) {
                this.onFinish();
                Ext4.Msg.show( {
                    title: PW.t('errorText'),
                    msg: PW.t('errorMsg'),
                    buttons: Ext4.Msg.OK,
                    icon: Ext4.MessageBox.ERROR
                } );
            }
        } );
    },

    onStart: function() {
        Ext4.MessageBox.wait( Ext4.String.format( PW.t('loadingLicense') ));
    },

    onFinish: function( success ) {
        this.getForm().reset();
        this.down( '#licenseInfoContainer' ).setVisible( false );
        this.down( '#install' ).setDisabled( true );
        Ext4.MessageBox.close();

    }
} );