Ext.namespace('Ext.ux.plusmpm');

/*-----------------------------------------------------------*/

Ext.ux.plusmpm.VariableSearchHelper = function(config){
	Ext.QuickTips.init();
	
	var fbarItems = new Array();
	if(config.helpText)
 	{
		fbarItems.push({
			text : this.helpText,
			enableToggle : true,
			toggleHandler : this.helpToggleHandler,
			ref : '../helpButton',
			scope : this
		});
		this.createHelpToolTip(config.helpText);
	}

		
	if (config.items.length == 2) 
	{
		fbarItems.push('->', 
		{
			text : this.clearText,
			handler : this.clearHandlerWithoutExit,
			scope : this
		}, 
		{
			text : PW.t('closeButtonLabel'),
			handler : this.confirmHandler,
			scope : this
		});
	} 
	else 
	{
		fbarItems.push('->', 
		{
			text : 'Ok',
			handler : this.confirmHandler,
			scope : this
		}, 
		{
			text : this.clearText,
			handler : this.clearHandler,
			scope : this
		});
	}
	
	config = Ext.apply({
		fbar: {
			 items: fbarItems
		},
		keys: { key: 13, stopEvent: true, handler: this.confirmHandler, scope: this},
		closeAction		: 'hide',
		layout			: 'form',
		bodyStyle		: 'padding: 5px;',
		buttonAlign		: 'left',
		frame: false,
		shadow: false
	}, config);

	
	Ext.ux.plusmpm.VariableSearchHelper.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpmVariableSearchHelper

Ext.extend(Ext.ux.plusmpm.VariableSearchHelper, Ext.Window, {

	//private
	target: null,
	
	//private
	targetInput: null,
	
	//private
	lastTarget: null,
	
	//public
	helpText: PW.t('helpText'),
	
	//public
	clearText: PW.t('clearText'),
	
	//private
	helpToolTip: null,
	
	modal: true,
	
    initComponent : function(){
    	Ext.ux.plusmpm.VariableSearchHelper.superclass.initComponent.call(this);
    	
    	this.addEvents(
    			'confirm'
    	);

    	this.on('hide', this.onHideHandler, this);
    	this.on('show', this.onShowHandler, this);

    },

    onHideHandler : function() {
    	this.el.un('mousedown', this.onWindowMouseDown, this);
    	if(this.helpToolTip && !this.helpToolTip.hidden)
    		this.helpToolTip.hide();
    },
    
    onShowHandler : function() {
    	this.el.on('mousedown', this.onWindowMouseDown, this);
    },
    
    changeTarget : function(trigger, input) {
    	var t = Ext.get(trigger);
    	if(t)
    	{
    		this.lastTarget = this.target;
        	this.target = t;
        	this.targetInput = Ext.get(input);
    	}
    },
    
    onWindowMouseDown : function(e) {
    	if(this.helpToolTip && !this.helpToolTip.hidden && !e.within(this.helpButton.el.dom, false))
    		this.helpToolTip.hide();
    },
    
    showAtTarget : function() { 	
    	this.setShowPosition();
		if(this.lastTarget != this.target)
		{	
	    	if(!this.hidden)
	    	{
	    		this.hide();
	    	}
	    	this.show();
		}
		else
		{
			if(this.hidden)
			{
				this.show();
			}
			else
				this.hide();
		}
    },
    
    setShowPosition : function() {
    	var xy = this.target.getAnchorXY('tr');
    	this.setPosition(xy[0], xy[1]);
    },

    confirmHandler : function() {
    	this.fireEvent('confirm', this);
    },
    
    clearHandler : function() {
    	this.clearHandlerWithoutExit();
    	this.hide();
    },
					    
    clearHandlerWithoutExit : function() {
    	if (this.targetInput) {
    		var inputId = this.targetInput.dom.id;
    		var inputText = jQuery('#' + inputId + '-selectized');
    		if (inputText.length > 0) {
    			inputText[0].value = "";
    		} else {
    			this.targetInput.dom.value = "";
    		}
    	}
	},
	
    helpToggleHandler : function(button, pressed) {
    	if(this.helpToolTip)
    	{
			if(pressed)
			{
				var elem = this.helpButton.getEl();
				var xy = elem.getAnchorXY('bl');
				this.helpToolTip.showAt(xy);
			}
			else
				this.helpToolTip.hide();
    	}
    },
    
	checkPosition: function() {
		//ustawiam pozycje okna, zeby miescilo sie w oknie przegladarki
		var browserWidth = Ext.getBody().dom.clientWidth;
		
		var xy = this.helpToolTip.getPosition();
		
		if((browserWidth > this.helpToolTip.getWidth()) && (xy[0] + this.helpToolTip.getWidth() > browserWidth))
		{
			this.helpToolTip.getEl().setLeftTop(browserWidth - this.helpToolTip.getWidth() - 10, xy[1]);
		}
	},
    
    closeHelp : function() {
    	if(this.helpToolTip)
    	{
	    	if(this.helpButton.pressed)
	    		this.helpButton.toggle(false, true);
    	}
    },
    
    createHelpToolTip : function(text) {
    	this.helpToolTip = new Ext.ToolTip({
    		html: text,
    		closable: true,
    		dismissDelay: 0,
    		maxWidth: 500,
    		listeners: {
    			hide: function() {
    				this.closeHelp();
    			},
    			move: function() {
    				this.checkPosition();
    			},
    			scope: this
    		}
    	});
    }
}); // end of Ext.extend

/*-----------------------------------------------------------*/

Ext.ux.plusmpm.DateVariableSearchHelper = function(config){
	var markers = [
                   [this.markerTypeValuesText[0], '<CURRENTYEAR>'],
                   [this.markerTypeValuesText[1], '<CURRENTMONTH>'],
                   [this.markerTypeValuesText[2], '<CURRENTDATE>'],
                   [this.markerTypeValuesText[3], '<CURRENTDATETIME>']
	           ];
	var markersUnit = [
                   [this.markerUnitValuesText[0], 'y'],
                   [this.markerUnitValuesText[1], 'm'],
                   [this.markerUnitValuesText[2], 'w'],
                   [this.markerUnitValuesText[3], 'd'],
                   [this.markerUnitValuesText[4], 'h']
	           ];
	
	var markerType = new Ext.form.ComboBox({
	    value			: markers[2][1],
	    ref				: 'typeField',
	    fieldLabel		: this.markerTypeLabelText,
	    labelStyle		: 'margin: 0; padding: 5px 0px 5px 5px',
	    width			: 160,
	    valueField		: 'value',
	    displayField	: 'name',
        forceSelection	: true,
        editable		: false,
        triggerAction	: "all",
	    mode			: 'local',
	    store			: new Ext.data.SimpleStore({
	        fields: [ 'name', 'value' ],
	        data   : markers
	    })
	});
	
	var markerUnit = new Ext.form.ComboBox({
	    value			: markersUnit[3][1],
	    ref				: 'unitField',
	    fieldLabel		: this.markerUnitLabelText,
	    labelStyle		: 'margin: 0; padding: 5px 0px 5px 5px',
	    width			: 160,
	    valueField		: 'value',
	    displayField	: 'name',
        forceSelection	: true,
        editable		: false,
        triggerAction	: "all",
	    mode			: 'local',
	    store			: new Ext.data.SimpleStore({
	        fields: [ 'name', 'value' ],
	        data   : markersUnit
	    })
	});
	
	var markerOffset = {
		    xtype			: 'numberfield',
		    ref				: 'offsetField',
		    fieldLabel		: this.markerOffsetLabelText,
		    labelStyle		: 'margin: 0; padding: 5px 0px 5px 5px', 
		    width			: 160,
            value			: 0,
            allowBlank 		: false,
            decimalPrecision: 0
	};
	
	config = Ext.apply({
		helpText : this.generateHelpText(),
		items: [markerType, markerOffset, markerUnit],
		width: 295
	}, config);

	
	Ext.ux.plusmpm.DateVariableSearchHelper.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.DateVariableSearchHelper

Ext.extend(Ext.ux.plusmpm.DateVariableSearchHelper, Ext.ux.plusmpm.VariableSearchHelper, {
	
	//public
	markerTypeLabelText: PW.t('markerTypeLabelText'),
	
	//public
	markerOffsetLabelText: PW.t('markerOffsetLabelText'),
	
	//public
	markerUnitLabelText: PW.t('markerUnitLabelText'),
	
	//public
	markerTypeValuesText: [PW.t('currentYear'), PW.t('currentMonth'), PW.t('currentDate'), PW.t('currentTime')],

	//public
	markerUnitValuesText: [PW.t('year'), PW.t('month'), PW.t('week'), PW.t('day'), PW.t('hour')],
	
	//public
	helpTooltipText: PW.t('helpTooltipText'),

	//public
	helpTooltipTypeText: PW.t('helpTooltipTypeText'),
	
	//public
	helpTooltipFOffsetText: PW.t('helpTooltipFOffsetText'),
	
	//public
	helpTooltipUnitText: PW.t('helpTooltipUnitText'),
	
	//public
	helpTooltipDescText: PW.t('helpTooltipDescText'),
    
    generateHelpText : function() {
    	var text = this.helpTooltipText;
    	text += '<BR><B>' + this.markerTypeLabelText + '</B> - ' + this.helpTooltipTypeText;
    	text += '<BR><B>' + this.markerOffsetLabelText + '</B> - ' + this.helpTooltipFOffsetText;
    	text += '<BR><B>' + this.markerUnitLabelText + '</B> - ' + this.helpTooltipUnitText;
    	
    	text += '<BR><BR>' + this.helpTooltipDescText + ':<BR>' ;
    	text += '<B>' + this.markerTypeLabelText + '</B>: ' + this.markerTypeValuesText[1] + ', ';
    	text += '<B>' + this.markerOffsetLabelText + '</B>: -1, ';
    	text += '<B>' + this.markerUnitLabelText + '</B>: ' + this.markerUnitValuesText[1] + '.';
    	return text;
    },

    onConfirm : function() {

		if(this.typeField.isValid())
		{
			var markerType = this.typeField.getValue();
			if(this.offsetField.isValid())
			{
				var markerOffset = parseInt(this.offsetField.getValue());
				if(markerOffset >= 0)
				{
					markerOffset = "+" + markerOffset;
				}
				
				if(this.unitField.isValid())
				{
					var markerUnit = this.unitField.getValue();
					if(this.targetInput)
					{
						this.targetInput.dom.value = markerType + markerOffset + markerUnit;
					}
					this.hide();
					return;
				}
			}
		}
    },
    
    onBeforeShowHandler : function (helper) {
    	
    	this.restoreDefaults();
    	
    	var input = Ext.get(this.targetInput);
    	if(input)
    	{
    		var text = input.dom.value;
    		if(text)
    		{
    			this.parseInput(text);
    		}
    	}
    },
   
    restoreDefaults : function() {
    	this.typeField.setValue(this.typeField.store.data.items[2].data.value);
		this.offsetField.setValue(0);
		this.unitField.setValue(this.unitField.store.data.items[3].data.value);
    },
    
    parseInput : function(text) {
    	var re = new RegExp('^<.{1,}>([+,-][0-9]{1,}.{1}){0,1}$');	
    	if(text.match(re))
    	{
    		var markerType = text.substring(0, text.indexOf('>')+1);
    		var markerOffset = text.substring(text.indexOf('>')+1, text.length-1);
    		var markerUnit = text.charAt(text.length-1);
    		
    		var typeFieldStore = this.typeField.getStore();
    		var valid = false;
    		for(var i=0; i<typeFieldStore.getCount(); i++)
    		{
    			if(markerType == typeFieldStore.getAt(i).data.value)
    			{
    				valid = true;
    				break;
    			}
    		}
    		
    		if(valid)
    		{	
    			this.typeField.setValue(markerType);
    			if(markerOffset.charAt(0) == '+')
    				markerOffset = markerOffset.substring(1); 			
    			
        		var unitFieldStore = this.unitField.getStore();
        		valid = false;
        		for(var i=0; i<unitFieldStore.getCount(); i++)
        		{
        			if(markerUnit == unitFieldStore.getAt(i).data.value)
        			{
        				valid = true;
        				break;
        			}
        		}
        		
        		if(valid)
        		{
        			this.offsetField.setValue(markerOffset);
        			this.unitField.setValue(markerUnit);
        		}
    		}	
    	}
    },
    
    initComponent : function() {
    	Ext.ux.plusmpm.DateVariableSearchHelper.superclass.initComponent.call(this);
    	
    	this.on('beforeshow', this.onBeforeShowHandler, this);
    	this.on('confirm', this.onConfirm, this);
    }
    
}); // end of Ext.extend


/*-----------------------------------------------------------*/

Ext.ux.plusmpm.TextVariableSearchHelper = function(config){
	
	var markers = [
        [this.markerTypeValuesText[0], '<USERNAME>'],
        [this.markerTypeValuesText[1], '<USEROUS>'],
        [this.markerTypeValuesText[2], '<USERSUBOUS>'],
        [this.markerTypeValuesText[3], '<USEROUSYMBOLS>'],
        [this.markerTypeValuesText[4], '<USERSUBOUSYMBOLS>']
   ];
	
	var markersUnit = [
        [this.markerUnitValuesText[1], '*'],
        [this.markerUnitValuesText[2], '?'],
        [this.markerUnitValuesText[3], '!'],
        [this.markerUnitValuesText[4], '*_*'],
        [this.markerUnitValuesText[5], '!*_*']
    ];
	
	var markerType = new Ext.form.ComboBox({
	    value			: markers[0][1],
	    ref				: 'typeField',
	    fieldLabel		: this.markerTypeLabelText,
	    labelStyle		: 'margin: 0; padding: 5px 0px 5px 5px',
	    width			: 250,
	    valueField		: 'value',
	    displayField	: 'name',
        forceSelection	: true,
        editable		: false,
        triggerAction	: "all",
	    mode			: 'local',
	    store			: new Ext.data.SimpleStore({
	        fields: [ 'name', 'value' ],
	        data   : markers
	    })
	});

	var markerUnit = new Ext.form.ComboBox({
		value : markersUnit[0][1],
		ref : 'unitField',
		fieldLabel : this.markerSpecialCharsLabelText,
		labelStyle : 'margin: 0; padding: 5px 0px 5px 5px',
		width : 250,
		valueField : 'value',
		displayField : 'name',
		forceSelection : true,
		editable : false,
		triggerAction : "all",
		mode : 'local',
		store : new Ext.data.SimpleStore({
			fields : [ 'name', 'value' ],
			data : markersUnit
		})
	});
	
	var unitFieldAddButton = new Ext.Button({
		text : PW.t('advanceProcessSearch.buttonName.add'),
	    width: 90,
	    handler: function(btn){
	    	if(btn.ownerCt.unitField.isValid())
	    	{
	    		var inputId = this.targetInput.dom.id;
	    		var inputS = jQuery('#'+inputId+'-selectized');
	    		if (inputS.length > 0){
		    		var sInputS = jQuery('#' + inputId)[0].selectize;
					sInputS.setTextboxValue(inputS.val() + btn.ownerCt.unitField.value);
					inputS.focus();
	    		}
	    		else{
	    			this.targetInput.dom.value += btn.ownerCt.unitField.value;
	    		}
	    	}
	    },
	    scope: this
	});
	
	var typeFieldAddButton = new Ext.Button({
		text : PW.t('advanceProcessSearch.buttonName.add'),
		width : 90,
		handler : function(btn) {
			if (btn.ownerCt.typeField.isValid()) {
				var inputId = this.targetInput.dom.id;
				var inputS = jQuery('#'+inputId+'-selectized');
				if (inputS.length > 0){
					var sInputS = jQuery('#' + inputId)[0].selectize;
					sInputS.setTextboxValue(inputS.val() + btn.ownerCt.typeField.value);
					inputS.focus();
				}
				else{
					this.targetInput.dom.value += btn.ownerCt.typeField.value;
				}
			}
		},
		scope : this
	});
	
	var typeRow = new Ext.form.CompositeField({
	    xtype: 'compositefield',
	    labelWidth: 120,
	    items: [markerType, typeFieldAddButton]
	});
	
	var signRow = new Ext.form.CompositeField({
	    xtype: 'compositefield',
	    labelWidth: 120,
	    items: [markerUnit, unitFieldAddButton]
	});
	
	config = Ext.apply({
		id : 'advanceSearchTextHelper',
		helpText : this.generateHelpText(),
		items: [typeRow, signRow],
		width: 465
	}, config);

	
	Ext.ux.plusmpm.TextVariableSearchHelper.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.TextVariableSearchHelper

Ext.extend(Ext.ux.plusmpm.TextVariableSearchHelper, Ext.ux.plusmpm.VariableSearchHelper, {
	
	hintText1: PW.t('hintText1'),
	
	hintText2: PW.t('hintText2'),
	
	hintText3: PW.t('hintText3'),
	
	hintText4: PW.t('advancesearch.texthelper.hintText4'),
	
	hintText5: PW.t('advancesearch.texthelper.hintText5'),
	
	hintText6: PW.t('advancesearch.texthelper.hintText6'),
	
	hintText7: PW.t('advancesearch.texthelper.hintText7'),
	
	hintText8: PW.t('advancesearch.texthelper.hintText8'),
	
	helpTextHeader: PW.t('helpTextHeader'),
	
	helpTextUsername: PW.t('helpTextUsername'),

	helpTextUserGroup : PW.t('helpTextUserGroup'),
	
	helpTextOU: PW.t('helpTextOU'),
	
	helpTextSubOU: PW.t('helpTextSubOU'),
	
	helpTextOUSymbol: PW.t('helpTextOUSymbol'),

	helpTextSubOUSymbol: PW.t('helpTextSubOUSymbol'),
	
	markerSpecialCharsLabelText: PW.t('advanceProcessSearch.specialChars'),
	
	//public
	markerTypeLabelText: PW.t('markerTypeLabelText'),
	

	// public
	markerTypeValuesText : 
	[
		PW.t('user'),
		PW.t('organizationUnit'),
		PW.t('subOrganizationUnit'),
		PW.t('organizationUnitSymbol'),
		PW.t('subOrganizationUnitSymbol') 
	],
				
	markerUnitValuesText :
	[
		PW.t('advanceProcessSearch.specialChar.valuesSeparation'),
		PW.t('advanceProcessSearch.specialChar.stringReplacement'),
		PW.t('advanceProcessSearch.specialChar.charReplacement'),
		PW.t('advanceProcessSearch.specialChar.valueNegation'),
		PW.t('advanceProcessSearch.specialChar.nonEmptyValue'),
		PW.t('advanceProcessSearch.specialChar.emptyValue') 
	],
	
    generateHelpText : function() {
    	var text = this.helpTextHeader + '<BR><BR>';
    	text += '<B>'+ this.markerTypeValuesText[0] + '</B> &lt;USERNAME&gt; - ' + this.helpTextUsername;
		text += '<BR><B>'+ this.markerTypeValuesText[1] + ' </B> &lt;USERGROUPS&gt; - ' + this.helpTextUserGroup;
		text += '<BR><B>'+ this.markerTypeValuesText[2] + '</B> &lt;USEROUS&gt; - ' + this.helpTextOU;
    	text += '<BR><B>'+ this.markerTypeValuesText[3] + '</B> &lt;USERSUBOUS&gt; - ' + this.helpTextSubOU;
    	text += '<BR><B>'+ this.markerTypeValuesText[4] + '</B> &lt;USEROUSYMBOLS&gt; - ' + this.helpTextOUSymbol;
    	text += '<BR><B>'+ this.markerTypeValuesText[5] + '</B> &lt;USERSUBOUSYMBOLS&gt; - ' + this.helpTextSubOUSymbol;
    	text += '<BR><BR><B>;</B> - ' + this.hintText1;
    	text += '<BR><B>*</B> - ' + this.hintText2;
    	text += '<BR><B>?</B> - ' + this.hintText3;
    	text += '<BR><B>!</B> - ' + this.hintText4;
    	text += '<BR><B>*_*</B> - ' + this.hintText5;
    	text += '<BR><B>!*_*</B> - ' + this.hintText6;
    	text += '<BR><B>"'+ '<I>' + this.hintText7 +'</I>' + '"</B> - ' + this.hintText8;
    	return text;
    },
	
	initComponent : function() {
		Ext.ux.plusmpm.TextVariableSearchHelper.superclass.initComponent.call(this);
    	this.on('confirm', this.onConfirm, this);
	},
	
     
    onConfirm : function() {
    	this.hide();
		return;
    }
}); // end of Ext.extend



