Ext.namespace( 'Ext.ux.plusmpm' );

// ----------------------------------------------------------------------------

Ext.ux.plusmpm.MainFormPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        contentEl: 'task_body_tab_div'
    }, config );

    Ext.ux.plusmpm.MainFormPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.MainFormPanel constructor

Ext.extend( Ext.ux.plusmpm.MainFormPanel, Ext.Panel, {} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String
 */
Ext.ux.plusmpm.CommentPanel = function( config ) {

    config = Ext.apply( {
        id: 'taskbodyCommentPanel',
        ref: '../../referenceCommentPanel',
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        processId: config.processId,
        activityId: config.activityId,
        autoLoad: {
            url: 'ShowComments.do?processId=' + config.processId + '&activityId=' + config.activityId,
            scripts: true,
            text: this.loadingText
        }
    }, config );

    Ext.ux.plusmpm.CommentPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.CommentPanel constructor

Ext.extend( Ext.ux.plusmpm.CommentPanel, Ext.Panel, {

    loadingText: PW.t('loadingText'),

    processId: null,

    activityId: null,

    tableBodyResizeTaskRunner: null,

    tableBodyLastHeight: 0,

    tableBodyResizeTaskRunnerRunning: false,

    onUpdateCompleted: function( element, responseObj ) {
        this.recalculateActivityFormHeights();
    },

    recalculateActivityFormHeights: function() {
        var panel = Ext.getCmp( 'activity_form_panel' );
        if ( panel ) {
            panel.recalculateHeights();
        }
    },

    onTableResize: function( e ) {
        var target = Ext.get( e.target );
        if ( target ) {
            var tParent = target.findParentNode( "span.pagelinks" );
            if ( tParent ) {
                if ( !this.tableBodyResizeTaskRunnerRunning ) {
                    if ( !this.tableBodyResizeTaskRunner ) {
                        this.tableBodyResizeTaskRunner = new Ext.util.TaskRunner();
                    }

                    this.tableBodyResizeTaskRunner.start( {
                        run: this.checkTableBodyResize,
                        interval: 100,
                        scope: this
                    } );
                    this.tableBodyResizeTaskRunnerRunning = true;
                }
            }
        }
    },

    checkTableBodyResize: function() {
        var commentsDiv = this.body.dom.children[1];
        if ( commentsDiv ) {
            var currHeight = commentsDiv.getHeight();
            if ( currHeight != this.tableBodyLastHeight ) {
                if ( this.tableBodyResizeTaskRunner )
                    this.tableBodyResizeTaskRunner.stopAll();
                this.tableBodyResizeTaskRunnerRunning = false;
                this.recalculateActivityFormHeights();
            }
        } else {
            if ( this.tableBodyResizeTaskRunner )
                this.tableBodyResizeTaskRunner.stopAll();
            this.tableBodyResizeTaskRunnerRunning = false;
        }
    },

    recalculateHeight: function() {
        var newHeight = 0;

        var commentsDiv = this.body.dom.children[1];
        if ( commentsDiv ) {
            var height = commentsDiv.getHeight();
            if ( height ) {
                newHeight += height;
                this.tableBodyLastHeight = height;
            }

        }

        var addCommentsDiv = this.body.dom.children[0];
        if ( addCommentsDiv ) {
            var addCommentsFrom = addCommentsDiv.children[0];
            if ( addCommentsFrom ) {
                var height = addCommentsFrom.getHeight();
                if ( height )
                    newHeight += height;
            }
        }

        if ( newHeight > 0 )
            this.setHeight( newHeight + 50 ); // dodajemy 50px na margines
    },

    addComment: function( comment ) {
        var u = this.getUpdater();
        var addUrl = 'AddComment.do?comment=' + comment + '&processId=' + processId + '&activityId=' + activityId;
        u.update( {
            url: addUrl,
            scripts: true,
            text: this.loadingText
        } );
    },

    updateComments: function( comment ) {
        var u = this.getUpdater();
        var addUrl = 'ShowComments.do?processId=' + processId + '&activityId=' + activityId;
        u.update( {
            url: addUrl,
            scripts: true,
            text: this.loadingText
        } );
    },

    deleteComment: function( id ) {
        var u = this.getUpdater();
        var addUrl = 'DeleteComment.do?commentId=' + id + '&processId=' + processId + '&activityId=' + activityId;
        u.update( {
            url: addUrl,
            scripts: true,
            text: this.loadingText
        } );
    },

    doAutoLoad: function() {
        this.body.on( 'click', this.onTableResize, this );
        // dodajemy listener do updatera
        var u = this.getUpdater();
        u.showLoadIndicator = null;
        u.addListener( 'update', this.onUpdateCompleted, this );
        Ext.ux.plusmpm.CommentPanel.superclass.doAutoLoad.call( this );
    },

    initComponent: function() {
        Ext.ux.plusmpm.CommentPanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String
 */
Ext.ux.plusmpm.ActivityPanel = function( config ) {

    var mainFormPanel = new Ext.ux.plusmpm.MainFormPanel( {} );

    var commentPanel = new Ext.ux.plusmpm.CommentPanel( {
        processId: config.processId,
        activityId: config.activityId
    } );

    config = Ext.apply( {
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        layout: 'anchor',
        items: [ mainFormPanel, commentPanel ]
    }, config );

    Ext.ux.plusmpm.ActivityPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.ActivityPanel constructor

Ext.extend( Ext.ux.plusmpm.ActivityPanel, Ext.Panel, {
    title: PW.t('activityTitle')
} ); // end of Ext.extend

// ----------------------------------------------------------------------------

Ext.ux.plusmpm.InfoPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        contentEl: 'task_body_info_tab_div'
    }, config );

    Ext.ux.plusmpm.InfoPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.InfoPanel constructor

Ext.extend( Ext.ux.plusmpm.InfoPanel, Ext.Panel, {
    title: PW.t('informationTitle')
} ); // end of Ext.extend

// ----------------------------------------------------------------------------

Ext.ux.plusmpm.DescriptionPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        contentEl: 'task_body_description_tab_div'
    }, config );

    Ext.ux.plusmpm.DescriptionPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.DescriptionPanel constructor

Ext.extend( Ext.ux.plusmpm.DescriptionPanel, Ext.Panel, {
    title: PW.t('descriptionTitle')
} ); // end of Ext.extend

// ----------------------------------------------------------------------------

Ext.ux.plusmpm.HistoryPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        contentEl: 'task_body_history_tab_div'
    }, config );

    Ext.ux.plusmpm.HistoryPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.HistoryPanel constructor

Ext.extend( Ext.ux.plusmpm.HistoryPanel, Ext.Panel, {
    title: PW.t('historyTitle')
} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String
 */
Ext.ux.plusmpm.DocumentsPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        autoLoad: {
            url: 'ShowDocuments.do?processId=' + config.processId + '&activityId=' + config.activityId,
            scripts: true,
            text: this.loadingText,
            timeout: 60000
        }
    }, config );

    Ext.ux.plusmpm.DocumentsPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.DocumentsPanel constructor

Ext.extend( Ext.ux.plusmpm.DocumentsPanel, Ext.Panel, {

    title: PW.t('processDocumentsTitle'),

    loadingText: PW.t('loadingText')

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String
 */
Ext.ux.plusmpm.ProcessMapPanel = function( config ) {

    config = Ext.apply( {
        autoScroll: true,
        cls: 'x-panel-body-PlusMPM',
        unstyled: true,
        ref: '../processMapPanel',
        layout: 'fit',
        autoLoad: {
            url: 'ShowMap.do?processId=' + config.processId + '&activityId=' + config.activityId + '&imageSize=900',
            scripts: true,
            text: this.loadingText
        }
    }, config );

    Ext.ux.plusmpm.ProcessMapPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.ProcessMapPanel constructor

Ext.extend( Ext.ux.plusmpm.ProcessMapPanel, Ext.Panel, {

    title: PW.t('processMapTitle'),

    loadingText: PW.t('loadingText')

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String
 */
Ext.ux.plusmpm.ActivityTabPanel = function( config ) {

    var activityPanel = new Ext.ux.plusmpm.ActivityPanel( {
        processId: config.processId,
        activityId: config.activityId
    } );
    var oItemsArray = [ activityPanel ];

    if ( config.taskTabVisibilityConfig.showDocumentsPanel == true ) {
        var documentsPanel = new Ext.ux.plusmpm.DocumentsPanel( {
            processId: config.processId,
            activityId: config.activityId
        } );
        oItemsArray.push( documentsPanel );
    }

    if ( config.taskTabVisibilityConfig.showInfoPanel == true ) {
        var infoPanel = new Ext.ux.plusmpm.InfoPanel( {} );
        oItemsArray.push( infoPanel );
    }

    if ( config.taskTabVisibilityConfig.showDescriptionPanel == true ) {
        var descriptionPanel = new Ext.ux.plusmpm.DescriptionPanel( {} );
        oItemsArray.push( descriptionPanel );
    }

    if ( config.taskTabVisibilityConfig.showHistoryPanel == true ) {
        var historyPanel = new Ext.ux.plusmpm.HistoryPanel( {} );
        oItemsArray.push( historyPanel );
    }

    if ( config.taskTabVisibilityConfig.showMapPanel == true ) {
        var mapPanel = new Ext.ux.plusmpm.ProcessMapPanel( {
            processId: config.processId,
            activityId: config.activityId
        } );
        oItemsArray.push( mapPanel );
    }

    config = Ext.apply( {
        ref: 'referenceActivityTabPanel',
        region: 'center',
        activeTab: 0,
        autoScroll: false,
        enableTabScroll: true,
        items: oItemsArray
    // items : [activityPanel, documentsPanel, infoPanel, descriptionPanel,
    // historyPanel, mapPanel]
    }, config );

    Ext.ux.plusmpm.ActivityTabPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.ActivityTabPanel constructor

Ext.extend( Ext.ux.plusmpm.ActivityTabPanel, Ext.TabPanel, {

    onBodyResizeEventHandler: function( panel, width, height ) {
        panel.ownerCt.recalculateTablesWidths( width );
        panel.ownerCt.recalculateHeights();
    },

    onTabChangeEventHandler: function( panel, tab ) {
        window.setTimeout( function() {
            panel.ownerCt.recalculateHeights();
        }, 0 );
    },

    initComponent: function() {
        this.on( 'bodyresize', this.onBodyResizeEventHandler );
        this.on( 'tabchange', this.onTabChangeEventHandler );
        Ext.ux.plusmpm.ActivityTabPanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.files : Array[{id, name, org_name,
 * link, html}]
 */
Ext.ux.plusmpm.DocumentsViewTabPanel = function( config ) {

    config = Ext.apply( {
        enableTabScroll: true,
        activeTab: 0,
        autoScroll: true,
        stateful: true,
        stateId: 'DocumentsViewTabPanel_stateId',
        items: []
    }, config );

    Ext.each( config.files, function( file, index, allFiles ) {
        config.items.push( {
            id: 'tab_id_' + index,
            title: file.description,
            html: file.html,
            tabTip: this.tabTipPrefix + ': ' + file.org_name,
            closable: true,
            cls: 'x-panel-body-PlusMPM',
            unstyled: true,
            fileId: file.id
        } );
    }, this );

    Ext.ux.plusmpm.DocumentsViewTabPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.DocumentsViewTabPanel constructor

Ext.extend( Ext.ux.plusmpm.DocumentsViewTabPanel, Ext.TabPanel, {

    tabTitlePrefix: PW.t('tabTitlePrefix'),

    tabTipPrefix: PW.t('tabTipPrefix'),

    files: [],

    getTabIndex: function( panel ) {
        return panel.id.substr( panel.id.lastIndexOf( '_' ) + 1 );
    },

    beforetabchangeEventHandler: function( thisTabPanel, newTab, currentTab ) {
        if ( currentTab ) {
            var nTabIndex = this.getTabIndex( currentTab );
            var tabIFrame = document.getElementById( 'iframe_id_' + nTabIndex );
            if ( tabIFrame ) {
                if ( Ext.isGecko3 )
                    tabIFrame.data = '';
                else
                    tabIFrame.src = '';
            }
        }
    },

    tabchangeEventHandler: function( thisTabPanel, newTab ) {
        var nTabIndex = this.getTabIndex( newTab );
        var tabIFrame = document.getElementById( 'iframe_id_' + nTabIndex );
        if ( tabIFrame ) {
            // jeżeli przeglądarka jest na silniku Gecko3 ( mozilla, iceweasel
            // etc. )
            if ( Ext.isGecko3 )
                tabIFrame.data = this.files[nTabIndex].link;
            else
                tabIFrame.src = this.files[nTabIndex].link;
        }
    },

    initComponent: function() {
        this.on( 'beforetabchange', this.beforetabchangeEventHandler, this );
        this.on( 'tabchange', this.tabchangeEventHandler, this );
        Ext.ux.plusmpm.DocumentsViewTabPanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.files : Array[{id, name, org_name,
 * link, html}]
 */
Ext.ux.plusmpm.DocumentsViewPanel = function( config ) {

    var documentsViewTabPanel = new Ext.ux.plusmpm.DocumentsViewTabPanel( {
        files: config.files
    } );

    config = Ext.apply( {
        id: 'documents_view_panel',
        region: 'east',
        split: true,
        collapsible: true,
        collapseMode: 'mini',
        hideMode: 'offsets',
        layout: 'fit',
        width: this.minimizedWidth,
        stateful: true,
        stateId: 'DocumentsViewPanel_stateId',
        items: documentsViewTabPanel,
        tools: [ {
            id: 'maximize',
            qtip: this.maximizeQTip,
            handler: this.maximizeToolHandler
        }, {
            id: 'minimize',
            qtip: this.minimizeQTip,
            handler: this.minimizeToolHandler
        } ]
    }, config );

    Ext.ux.plusmpm.DocumentsViewPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.DocumentsViewPanel constructor

Ext.extend( Ext.ux.plusmpm.DocumentsViewPanel, Ext.Panel, {

    maximizeQTip: PW.t('maximizeQTip'),

    minimizeQTip: PW.t('minimizeQTip'),

    maximized: false,

    minimizedWidth: 400,

    maximizeToolHandler: function( event, toolEl, panel ) {
        if ( false === panel.maximized ) {
            panel.maximized = true;
            panel.minimizedWidth = panel.getSize().width;
            panel.setWidth( '100%' );
            panel.ownerCt.doLayout();
        }
    },

    minimizeToolHandler: function( event, toolEl, panel ) {
        if ( true === panel.maximized ) {
            panel.maximized = false;
            panel.setWidth( panel.minimizedWidth );
            panel.ownerCt.doLayout();
        }
    },

    expandEventHandler: function( panel ) {
        var documentsViewTabPanel = panel.getComponent( 0 );
        documentsViewTabPanel.fireEvent( 'tabchange', documentsViewTabPanel, documentsViewTabPanel.getActiveTab() );
    },

    deleteDocument: function( fileId ) {
        var tabPanel = this.items.first();
        var item = tabPanel.items.find( function( item ) {
            if ( item.fileId == fileId )
                return item;
        } );

        if ( item ) {
            tabPanel.remove( item.id, true );
        }
    },

    initComponent: function() {
        if ( true === Ext.isIE ) {
            this.on( 'expand', this.expandEventHandler );
        }
        Ext.ux.plusmpm.DocumentsViewPanel.superclass.initComponent.call( this );
    }

} ); // end of Ext.extend

// ----------------------------------------------------------------------------

/**
 * Wymagane parametry konfiguracyjne: config.processId : String
 * config.activityId : String config.files : Array[{id, name, org_name, link,
 * description, html}] config.tablesDefinition : Array[{variableSetVariables,
 * variableSetEditorsConfig, targetDivId, sStateId, bReadOnly, jsonData}]
 * config.textareaIds : Array[textareaIds] config.previousAcceptanceFailed :
 * Boolean
 */
Ext.ux.plusmpm.ActivityFormPanel = function( config ) {

    var activityTabPanel = new Ext.ux.plusmpm.ActivityTabPanel( {
        processId: config.processId,
        activityId: config.activityId,
        taskTabVisibilityConfig: config.taskTabVisibilityConfig
    } );

    var items = new Array();
    items.push( activityTabPanel );

    if ( config.files && config.files.length > 0 ) {
        var documentsViewPanel = new Ext.ux.plusmpm.DocumentsViewPanel( {
            files: config.files
        } );
        items.push( documentsViewPanel );
    }

    config = Ext.apply( {
        id: 'activity_form_panel',
        layout: 'border',
        bodyBorder: false,
        border: false,
        renderTo: 'task_body_main_div',
        boxMinHeight: 499,
        height: 500,
        items: items
    }, config );

    Ext.ux.plusmpm.ActivityFormPanel.superclass.constructor.call( this, config );

}; // end of Ext.ux.plusmpm.ActivityFormPanel constructor

Ext
                .extend(
                                Ext.ux.plusmpm.ActivityFormPanel,
                                Ext.Panel,
                                {

                                    processId: '',

                                    activityId: '',

                                    tablesDefinition: [],

                                    tables: [],

                                    textareaIds: [],

                                    previousAcceptanceFailed: false,

                                    previousAcceptanceFailedAlertTitle: PW.t('previousAcceptanceFailedAlertTitle'),

                                    previousAcceptanceFailedAlertMsg: PW.t('previousAcceptanceFailedAlertMsg'),

                                    validateTablesErrorText: PW.t('validateTablesErrorText'),

                                    removeLoadMask: function removeFormLoadMask() {
                                        Ext.get( 'loading' ).remove();
                                        Ext.get( 'loading-mask' ).remove();
                                    },

                                    recalculateHeights: function() {
                                        var activityFormHeight = Ext.get( "task_body_tab_div" ).getHeight( true );

                                        if ( this.referenceCommentPanel != null ) {
                                            this.referenceCommentPanel.recalculateHeight();
                                            activityFormHeight = activityFormHeight + this.referenceCommentPanel.getHeight();
                                            activityFormHeight = activityFormHeight + ( this.referenceActivityTabPanel.getFrameHeight() * 2 );

                                            if ( this.items.getCount() > 1 ) {
                                                // są wyświetlane dokumenty,
                                                // ustalam minimalną wysokość
                                                // formularza
                                                var nDocumentViewElementMinHeight = Ext.getBody().getHeight()
                                                                + ( this.referenceActivityTabPanel.getFrameHeight() * 3 );
                                                if ( nDocumentViewElementMinHeight > activityFormHeight ) {
                                                    activityFormHeight = nDocumentViewElementMinHeight;
                                                }
                                            }
                                            this.setHeight( activityFormHeight );
                                        }
                                    },

                                    recalculateTablesWidths: function( mainFormPanelWidth ) {
                                        Ext.each( this.tables, function( table, index, allTables ) {
                                            if ( table.rendered === true ) {
                                                table.setWidth( mainFormPanelWidth - 25 );
                                                table.onRefresh( null, null, table, null, true );
                                            }
                                        } );
                                    },

                                    generateTables: function() {
                                        Ext.each( this.tablesDefinition, function( tableDef, index, allTableDef ) {
                                            var dynamicTable;
                                            if ( tableDef.bReadOnly === true ) {
                                                dynamicTable = new Ext.ux.plusmpm.VariableSetGridPanel( {
                                                    variableSetConfig: {
                                                        setId: tableDef.setId,
                                                        storeId: tableDef.targetDivId.concat( "_JsonStore" ),
                                                        processId: this.processId,
                                                        activityId: this.activityId,
                                                        variables: tableDef.variableSetVariables,
                                                        targetDivId: tableDef.targetDivId,
                                                        collapsed: tableDef.isCollapsed
                                                    },
                                                    stateId: tableDef.sStateId.concat( "_GridPanel" )
                                                } );
                                            } else {
                                                dynamicTable = new Ext.ux.plusmpm.VariableSetEditorGridPanel( {
                                                    variableSetConfig: {
                                                        setId: tableDef.setId,
                                                        storeId: tableDef.targetDivId.concat( "_JsonStore" ),
                                                        processId: this.processId,
                                                        activityId: this.activityId,
                                                        variables: tableDef.variableSetVariables,
                                                        variablesEditorConfig: tableDef.variableSetEditorsConfig,
                                                        targetDivId: tableDef.targetDivId,
                                                        local: tableDef.local
                                                    },
                                                    stateId: tableDef.sStateId.concat( "_EditorGridPanel" ),
                                                    collapsed: tableDef.isCollapsed
                                                } );
                                            }

                                            if ( tableDef.jsonData ) {
                                                dynamicTable.getStore().loadData( tableDef.jsonData );
                                            }
                                            this.tables.push( dynamicTable );
                                        }, this );
                                    },

                                    validateTables: function() {
                                        var allTablesValid = true;
                                        Ext.each( this.tables, function( table, index, allTables ) {
                                            table.getStore().each( function( nextRecord, recordIndex, allRecord ) {
                                                if ( ( nextRecord.phantom === true ) || ( nextRecord.isValid() !== true ) ) {
                                                    alert( "[" + table.title + "] : " + this.validateTablesErrorText );
                                                    var htmlElement = Ext.get( table.getView().getRow( recordIndex ) );
                                                    htmlElement.setStyle( {
                                                        "border-color": "red"
                                                    } );
                                                    allTablesValid = false;
                                                    return false;
                                                } // end if
                                            }, this ); // end each
                                            return allTablesValid;
                                        }, this ); // end each
                                        return allTablesValid;
                                    },

                                    generateResizeableTextareas: function() {
                                        if ( this.textareaIds && this.textareaIds.length > 0 ) {
                                            Ext.each( this.textareaIds, function( textareaId, index, allTextareaIds ) {
                                                var wrappedTextarea = new Ext.Resizable( document.getElementById( textareaId ), {
                                                    wrap: true,
                                                    width: 260,
                                                    height: 60,
                                                    minWidth: 125,
                                                    minHeight: 25,
                                                    maxWidth: 800,
                                                    maxHeight: 300
                                                } );

                                                wrappedTextarea.el.setStyle( 'float', 'left' );

                                                wrappedTextarea.on( 'resize', function( wrapper, width, height, e ) {
                                                    this.recalculateHeights();
                                                }, this );
                                            }, this );
                                        }
                                    },

                                    afterrenderEventHandler: function( panel ) {
                                        Ext.each( panel.tables, function( table, index, allTables ) {
                                            if ( table.rendered === true && table.getView().autoFill === true ) {
                                                table.getView().forceFit = true;
                                                table.getView().refresh();
                                                table.getView().forceFit = false;
                                            }
                                        } );

                                        panel.recalculateHeights();
                                        panel.removeLoadMask();

                                        if ( true === panel.previousAcceptanceFailed ) {
                                            Ext.Msg.show( {
                                                title: panel.previousAcceptanceFailedAlertTitle,
                                                msg: panel.previousAcceptanceFailedAlertMsg,
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.MessageBox.WARNING
                                            } );
                                        }
                                    },

                                    initComponent: function() {
                                        this.generateTables();
                                        this.generateResizeableTextareas();

                                        this.on( 'afterrender', this.afterrenderEventHandler, this, {
                                            single: true
                                        } );

                                        Ext.ux.plusmpm.ActivityFormPanel.superclass.initComponent.call( this );
                                    }

                                } ); // end of Ext.extend
