(function(Ext) {
	
Ext.define('Suncode.datasourcemanager.mixins.ToolTip', {
	
	initTooltip: function(field, parameter){
		var id = this.getParameterId(parameter) + '-tip',
			tooltipImgEl = '<div id="' + id + '" class="tooltip-image"></div>';
		
		if(field.xtype == 'label') {
			field.html += tooltipImgEl;
		}
		else {
			field.afterLabelTextTpl = tooltipImgEl;
		}
		
		field.listeners = Ext.apply( {}, field.listeners, {
			afterRender: {
				fn: function(){
					new Ext.ToolTip({
		    			dismissDelay: 0,
		    			target: id,
		    			html: parameter.description,
		    			floating: true,
		    			shadow: false
		    		});
    			}
			}
		});
    },
    
    getParameterId: function(field){
    	if(field.id){
    		return field.id;
    	}
    	else if(field.itemId){
    		return field.itemId;
    	}
    	else {
    		return '';
    	}
    }
	
});
	
})(Ext4);