(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.component.MultiValueField', {
        extend: 'Suncode.datasourcemanager.component.ParametersForm',
        alias: 'widget.multivaluefield',
        mixins: ['Ext.form.field.Field'],

        fields: [],

        layout: {
            type: 'vbox',
            align: 'stretch'
        },

        // TODO ostatni element nie powinien miec ustawionego margin
        defaults: {
            margin: '0 0 5 0'
        },

        constructor: function (config) {
            this.callParent(arguments);
        },

        initComponent: function () {
            this.callParent(arguments);

            this.addEvents('change', 'addField');
            this.on('change', this.onChange);
            this.addRow(true);
        },

        onChange: function () {
            const me = this;
            me.items.each(function (item, index) {
                if (item.showAddButton && item.hideAddButton) {
                    if (index === me.items.length - 1) {
                        item.showAddButton();
                        return;
                    }
                    item.hideAddButton();
                }
                if (item.showUpButton && item.showDownButton && item.hideDownButton && item.hideUpButton) {
                    item.showUpButton();
                    item.showDownButton();
                    if (index === me.items.length - 1) {
                        item.hideDownButton();
                    }
                    if (index === 1) {
                        item.hideUpButton();
                    }
                }
            });
        },

        addRow: function (ghost, position) {
            var conf = {
                xtype: 'removablefield',
                itemConfig: this.itemConfig,
                name: this.name,
                fields: this.fields,
                asPlaceholder: ghost
            }
            var row;
            if (!position) {
                row = this.add(conf);
            } else {
                row = this.insert(position, conf);
            }
            this.fireEvent('change');

            return row;
        },

        removeRow: function (row) {
            if (this.items && this.items.length === 1) {
                row.setAsPlaceholder();
            } else if (this.items && this.items.length > 1) {
                this.remove(row);
            }
            this.fireEvent('change');
        },

        switchValue: function (field, isUpSwitch) {
            const position = this.items.indexOf(field);

            if ((position > 1 && isUpSwitch) || (position < this.items.length - 1 && !isUpSwitch)) {
                const items = this.items;

                if (!Ext.isEmpty(items) && Ext.isFunction(items.switchValuesWithPanel)) {
                    if (isUpSwitch) {
                        items.switchValuesWithPanel(position, true);
                        return;
                    }
                    items.switchValuesWithPanel(position, false);
                    return;
                }
                if (isUpSwitch) {
                    this.switchValues(position, position - 1);
                    return;
                }
                this.switchValues(position, position + 1)
            }
        },

        switchValuesWithPanel: function (position, isUpSwitch) {
            this.items.each(function (panel, index, length) {
                const array = panel.items.first();
                if (isUpSwitch) {
                    array.switchValues(position, position - 1);
                    return;
                }
                array.switchValues(position, position + 1);
            }, this);
        },

        switchValues: function (oldIndex, newIndex) {
            const elementAtOldIndex = this.items.getAt(oldIndex);
            const elementAtNewIndex = this.items.getAt(newIndex);

            if (!Ext.isEmpty(elementAtOldIndex) && !Ext.isEmpty(elementAtNewIndex)) {
                this.items.insert(oldIndex, elementAtNewIndex);
                this.items.insert(newIndex, elementAtOldIndex);

                this.fireEvent('change');
            }
        },

        // TODO zaimplementować getErrors
        setValues: function (values) {
            if (!values) return;
            var me = this,
                groupedValues = new Ext.util.MixedCollection(),
                valuesCount = 0;

            Ext.each(me.fields, function (field) {
                var id = field.itemId;
                groupedValues.add(id, values[id]);
            });

            if (groupedValues.getCount() > 0) {
                valuesCount = groupedValues.first()
                    ? groupedValues.first().length
                    : 0;
            }

            if (valuesCount > 0) {
                Ext.each(me.query('removablefield'), function (item) {
                    me.remove(item);
                });

                for (i = 0; i < valuesCount; i++) {
                    var value = new Ext.util.MixedCollection();

                    groupedValues.eachKey(function (key, item) {
                        if (item !== undefined) {
                            value.add(key, item[i]);
                        }
                    });
                    me.addRow().setValue(value);
                }
            }
        },

        getValue: function (fieldId) {
            var fields = this.query('removablefield');
            if (fields.length === 1 && fields[0].asPlaceholder) {
                return [];
            }

            var values = [];
            try {
              fields.forEach(function (item) {
                values.push(item.getValue(fieldId));
              });
            }
            catch (e) {
              // ignored
            }

            return values;
        },

        updateLabel: function () {
            // [FIX] aktualizacja etykiety usuwała niepotrzebnie tooltip
        }
    });
	
})(Ext4);