(function(Ext) {
    
    Ext.define('Suncode.datasourcemanager.component.DataSourceResultWindow', {
        extend: 'Ext.window.Window',
        xtype: 'datasourceresultwindow',
        
        requires: [
            'Suncode.datasourcemanager.component.DataSourceResultGrid'
        ],
        
        title: PW.t('datasources-result-window-title'),
        width: 1000,
        height: 670,
        modal: true,
        frame: false,
        layout: 'fit',

        temporaryDataSource: undefined,
        
        constructor: function( temporaryDataSource ) {
            this.temporaryDataSource = temporaryDataSource;
            
            this.callParent(arguments);
        },
        
        initComponent: function () {
            this.items = [new Suncode.datasourcemanager.component.DataSourceResultGrid(this.temporaryDataSource.dataSource.outputParameters, this.temporaryDataSource.uuid)];
            
            this.buttons = [{
                text: PW.t('close'),
                handler: this.close,
                scope: this
            }];
            
            this.callParent(arguments);
        }

    });

})(Ext4);
