    Ext.namespace('Ext.suncode.dashboard');

    var messages = Suncode.context('dashboard').messages;

    /**
     * <pre>
     * Formularz ustawień gadżetu. Biblioteka: Ext3
     *
     * Budowany jest na podstawie skryptu dostarczonego przez gadżet.
     * </pre>
     */
    Ext.suncode.dashboard.PropertiesForm = Ext.extend(Ext.Panel, {
        cls: 'dashboard-props-form',

        forceChange: false,
        autoHeight: true,
        frame: false,
        border: false,
        trackResetOnLoad: true,

        constructor: function (config) {
            var me = this,
                gadget = config.gadget,
                script = gadget.configurationScript;

            Ext.apply(me, {
                gadget: gadget,
                script: script,
            });

            return Ext.suncode.dashboard.PropertiesForm.superclass.constructor.call(me, config);
        },

        initComponent: function () {
            var me = this,
                elements;

            Ext.apply(me, {
                listeners: {
                    scope: me,
                    activate: me.onActivate,
                },
                items: [
                    {
                        xtype: 'form',
                        border: false,
                        autoScroll: true,
                        labelAlign: 'top',
                        ref: 'propertiesContainer',
                        defaults: {
                            width: 250,
                            msgTarget: 'under',
                        },
                    },
                ],
                buttonAlign: 'left',
                fbar: new Ext.Toolbar({
                    items: [
                        {
                            xtype: 'spacer',
                            width: 18,
                        },
                        {
                            text: messages('gadget.props.save'),
                            scope: me,
                            handler: me.saveProperties,
                        },
                        {
                            text: messages('gadget.props.cancel'),
                            ref: 'cancelBtn',
                            handler: function () {
                                me.propertiesContainer.getForm().reset();
                                me.fireEvent('cancel', false);
                            },
                        },
                    ],
                }),
            });

            // inicjalizacja
            Ext.suncode.dashboard.PropertiesForm.superclass.initComponent.call(me);

            (context = new Ext.suncode.dashboard.ScriptContext(me.propertiesContainer, me.gadget)),
                // wywołanie skryptu budującego
                eval('(function(Properties){' + me.script + '})(context);');

            // tooltip's
            me.on('render', function () {
                me.propertiesContainer.getForm().items.each(function (field) {
                    field.on({
                        scope: me,
                        render: me.renderTooltip,
                        valid: me.handleResize,
                        invalid: me.handleResize,
                    });
                });
            });
        },

        onActivate: function () {
            var me = this;

            me.fbar.cancelBtn.setVisible(me.forceChange !== true);
            me.forceChange = false;
        },

        saveProperties: function () {
            var me = this,
                gadgetId = me.gadget.id,
                dashboard = Ext.suncode.dashboard.Dashboard.instance;

            if (!me.loadMask) {
                me.loadMask = new Ext.LoadMask(me.getEl(), {msg: messages('gadget.props.saving')});
            }

            me.loadMask.show();
            me.propertiesContainer.getForm().submit({
                method: 'POST',
                url: 'api/dashboard/' + dashboard.id + '/gadgets/' + gadgetId + '/properties',
                success: function (form, action) {
                    me.loadMask.hide();
                    me.commitFields(form);
                    me.fireEvent('save', true);
                },
                failure: function () {
                    me.loadMask.hide();
                },
                scope: me,
            });
        },

        commitFields: function (form) {
            form.items.each(function (field) {
                field.originalValue = field.getValue();
            });
        },

        renderTooltip: function (field) {
            var me = this;

            if (field.inputType == 'hidden') {
                return;
            }

            if (field.tooltip) {
                var parent = field.getEl().parent('.x-form-item'),
                    label = parent.child('label'),
                    tooltip = {
                        tag: 'span',
                        html: field.tooltip,
                        cls: 'field-tooltip',
                    };

                if (label) {
                    Ext.DomHelper.insertAfter(label, tooltip);
                } else {
                    Ext.DomHelper.insertFirst(parent, tooltip);
                }
            }
        },

        handleResize: function () {
            Ext.suncode.dashboard.Dashboard.getInstance().getLayoutManager().recalculatePositions();
        },
    });

    Ext.suncode.dashboard.ScriptContext = function (form, gadget) {
        var me = this,
            form = form,
            gadget = gadget,
            dashboard = Ext.suncode.dashboard.Dashboard.getInstance();

        function field(name, xtype, label, config) {
            var property = gadget.properties[name];

            config = config || {};

            return Ext.apply(
                {
                    xtype: xtype,
                    name: name,
                    fieldLabel: label,
                    value: property ? property.value : undefined,
                    width: 305,
                    minWidth: 305,
                },
                config
            );
        }

        Ext.apply(me, {
            /**
             * Zwraca budowaną instancję Ext.form.FormPanel
             */
            getForm: function () {
                return form;
            },

            /**
             * Zwraca fieldset, do którego powinny być dodawane właściwości
             */
            getFieldSet: function () {
                return form;
            },

            add: function () {
                form.add.apply(form, arguments);
            },

            insert: function () {
                form.insert.apply(form, arguments);
            },

            remove: function () {
                form.remove.apply(form, arguments);
            },

            removeAll: function () {
                form.removeAll.apply(form, arguments);
            },

            /**
             * Zwraca absolutną ścieżkę do zasobu wtyczki.
             */
            getPluginUrl: function (url) {
                if (url.indexOf('/') == -1) {
                    url = '/' + url;
                }
                return Suncode.getAbsolutePath('/plugin/' + gadget.plugin.key + url);
            },

            /**
             * Zwraca absolutną ścieżkę do Workflow.
             * @see Suncode.getAbsolutePath(url)
             */
            getAbosluteUrl: function (url) {
                return Suncode.getAbsolutePath(url);
            },

            /**
             * Zwraca właściwość gadżetu o podanej nazwie.
             * @return {name: <nazwa>, value: 'wartość'}
             */
            getProperty: function (name) {
                return gadget.properties[name];
            },

            /**
             * Zwraca wartość podanej właściwości
             */
            value: function (name) {
                var prop = this.getProperty(name);
                return prop ? prop.value : undefined;
            },

            /**
             * Odświeża layout tej formy, dodatkowo ustawia odpowiednią wysokość dashboardu.
             */
            refreshLayout: function () {
                form.doLayout();
                dashboard.getLayoutManager().recalculatePositions();
            },

            /*
             * Metody szablonowe właściwości
             */

            /**
             * Tworzy pole ukryte.
             * @xtype: hidden
             *
             * @param name nazwa pola
             * @param config opcjonalny obiekt konfiguracyjny, rozszerzający stworzony komponent
             */
            hidden: function (name, config) {
                config = config || {};

                return Ext.apply(field(name, 'hidden'), config);
            },

            /**
             * Tworzy pole tekstowe.
             * @xtype: textfield
             *
             * @param name nazwa pola
             * @param label label pola
             * @param config opcjonalny obiekt konfiguracyjny, rozszerzający stworzony komponent
             */
            text: function (name, label, config) {
                config = config || {};
                config.cls = 'x4-form-text';

                return Ext.apply(field(name, 'textfield', label), config);
            },

            /**
             * Tworzy pole liczbowe.
             * @xtype: numberfield
             *
             * @param name nazwa pola
             * @param label label pola
             * @param config opcjonalny obiekt konfiguracyjny, rozszerzający stworzony komponent
             */
            number: function (name, label, config) {
                config = config || {};

                return Ext.apply(field(name, 'numberfield', label), config);
            },

            /**
             * Tworzy pole listy wyboru. Użytkownik może również wpisać własną wartość.
             *
             * @xtype: combo
             *
             * @param name nazwa pola
             * @param label label pola
             * @param data tablica elementów listy gdzie każdy element listą wartości [<value>, <name>] np [['1', 'Jeden'], ['2', 'Dwa']]
             * @param config opcjonalny obiekt konfiguracyjny, rozszerzający stworzony komponent
             */
            list: function (name, label, data, config) {
                config = config || {};

                return Ext.apply(
                    field(name, 'combo', label, {
                        hiddenName: name,
                        mode: 'local',
                        triggerAction: 'all',
                        valueField: 'value',
                        displayField: 'name',
                        width: 250,
                        minWidth: 250,
                        store: new Ext.data.ArrayStore({
                            fields: ['value', 'name'],
                            data: data,
                        }),
                        autoSelect: true,
                    }),
                    config
                );
            },

            /**
             * Tworzy dynamiczną listę wyboru. Dane pobierane są z podanego adresu URL.
             *
             * @xtype: combo
             *
             * @param name nazwa pola
             * @param label label pola
             * @param url adres servletu, który należy wywołać aby pobrać dane
             * @param config opcjonalny obiekt konfiguracyjny, rozszerzający stworzony komponent
             */
            dynamicList: function (name, label, url, config) {
                config = config || {};

                var storeTemp = new Ext.data.JsonStore({
                    autoLoad: true,
                    proxy: new Ext.data.HttpProxy({
                        method: 'GET',
                        url: url,
                    }),
                    idProperty: 'value',
                    root: 'records',
                    fields: ['name', 'value'],
                });

                storeTemp.on('load', function () {
                    var combo = form.items.find(function (obj) {
                        return obj.name == name;
                    });
                    var value = storeTemp.data.items.find(function (obj) {
                        return obj.id == combo.value;
                    });
                    if (value !== undefined) {
                        var displayValue = value.data.name;
                        combo.setRawValue(displayValue);
                    }
                });

                return Ext.apply(
                    field(name, 'combo', label, {
                        hiddenName: name,
                        mode: 'remote',
                        triggerAction: 'all',
                        valueField: 'value',
                        displayField: 'name',
                        width: 250,
                        minWidth: 250,
                        store: new Ext.data.JsonStore({
                            autoLoad: true,
                            autoDestroy: true,
                            proxy: new Ext.data.HttpProxy({
                                method: 'GET',
                                url: url,
                            }),
                            idProperty: 'value',
                            root: 'records',
                            fields: ['name', 'value'],
                            filter: function (filters, value) {
                                Ext.data.Store.prototype.filter.apply(this, [filters, value ? new RegExp(Ext.escapeRe(value), 'i') : value]);
                            },
                        }),
                        autoSelect: true,
                    }),
                    config
                );
            },
        });
    };
