(function (Ext) {
  Ext.define('Suncode.dashboard.administration.store.SharedDashboards', {
    extend: 'Ext.data.Store',
    model: 'Suncode.dashboard.administration.model.Dashboard',
    storeId: 'SharedDashboards',

    pageSize: 25,
    buffered: true,

    proxy: {
      type: 'ajax',
      url: Suncode.context('dashboard').base + '/api/dashboards/query',
      extraParams: {
        type: 'shared',
      },
      simpleSortMode: true,
      reader: {
        type: 'json',
        root: 'data',
      },
    },
      setUserParameter: function(user) {
          this.getProxy().setExtraParam('user', user);
      }
  });
})(Ext4);
