(function (Ext) {
    Ext.define('Suncode.deactivateUsers.view.WindowManager', {
        extend: 'Ext.window.Window',
        alias: 'widget.winmanager',
        autoShow: true,
        width: 1000,
        manageHeight: true,
        height: 750,
        closeAction: 'destroy',
        modal: true,
        frame: true,
        layout: 'fit',
        items: [{
            xtype: 'assignments-panel'
        }],

        initComponent: function () {
            Ext.apply(this, {
                buttons: [{
                    text: window.isDeactivationEditMode ? PW.t('edit') : PW.t('deactive'),
                    disabled: true,
                    action: 'deactiveButton',
                    id: 'deactiveButton'
                }, {
                    text: PW.t('cancel'), action: 'cancelButton'
                }]
            });

            this.callParent();
        }
    });
}(this.Ext4));