(function (Ext) {
    Ext.define('Suncode.deactivateUsers.store.UsersStore', {
        extend: 'Ext.data.Store',
        model: 'Suncode.deactivateUsers.model.UsersModel',
        pageSize: 10,
        folderSort: true,
        sorters: [{property: 'userName', direction: 'ASC'}],
        proxy: {
            type: 'ajax',
            url: 'api/users/query',
            actionMethods: {read: 'GET'},
            reader: {type: 'json', root: 'data'}
        },
        filters: [
            function (record) {
                if (record.get("userName") === Ext.getCmp('deactivation').userid) {
                    return false;
                }

                return true;

            }
        ]
    });
}(this.Ext4));