(function (Ext) {
  Ext.define('Favourites.settings.view.FavouriteConfigWindow', {
    extend: 'Favourites.settings.view.FavouriteBaseWindow',
    xtype: 'favourites-favouriteconfigwindow',
    itemId: 'favourites-config-window',
    requires: ['Favourites.model.Favourite'],

    height: 600,
    width: 800,
    modal: true,
    padding: '0 8px 8px 8px',

    initComponent: function () {
      Ext.apply(this, {
        items: [
          {
            xtype: 'form',
            layout: 'form',
            width: '100%',
            bodyPadding: 8,
            frame: false,
            defaults: {
              xtype: 'textfield',
              labelAlign: 'top',
            },
            items: [
              {
                fieldLabel: Favourites.I18N.m('name'),
                name: 'name',
                allowBlank: false,
                disabled: true,
              },
              {
                xtype: 'checkbox',
                labelAlign: 'left',
                fieldLabel: Favourites.I18N.m('customName'),
                name: 'customName',
                listeners: {
                  change: this.handleCustomNameCheckboxChange,
                },
              },
              {
                name: 'displayNameMode',
                hidden: true,
              },
              {
                fieldLabel: Favourites.I18N.m('type'),
                name: 'typeDescription',
                readOnly: true,
              },
              {
                fieldLabel: Favourites.I18N.m('parameter'),
                itemId: 'parameter',
                name: 'parameter',
                allowBlank: true,
                hidden: true,
                maxLength: 250,
              },
              {
                xtype: 'checkbox',
                labelAlign: 'left',
                fieldLabel: Favourites.I18N.m('countresults'),
                name: 'counted',
                hidden: true,
              },
              {
                xtype: 'checkbox',
                labelAlign: 'left',
                fieldLabel: Favourites.I18N.m('Otworz_w_nowym_oknie'),
                name: 'newWindow',
              },
            ],
            buttons: [
              {
                text: Favourites.I18N.m('delete'),
                formBind: true,
                iconCls: 'dvnt-icon-delete',
                handler: this.deleteElement,
                scope: this,
              },
              {
                text: Favourites.I18N.m('save'),
                formBind: true,
                iconCls: 'dvnt-icon-plus-circle',
                handler: this.updateElement,
                scope: this,
              },
              {
                text: Favourites.I18N.m('exit'),
                iconCls: 'dvnt-icon-x-symbol',
                handler: () => {
                  this.close();
                },
              },
            ],
          },
        ],
      });

      this.callParent(arguments);
      this.form = this.down('form');
      this.nameField = this.form.down('textfield[name="name"]');
      this.countField = this.form.down('checkbox[name="counted"]');
      this.customNameField = this.form.down('checkbox[name="customName"]');
      this.displayNameModeField = this.form.down('textfield[name="displayNameMode"]');
      this.newWindowField = this.form.down('checkbox[name="newWindow"]');
    },

    show: function () {
      this.form.getForm().reset();
      this.callParent(arguments);
    },

    bindFavourite: function (favourite, parameter, countable, counted, newWindow) {
      this.bindFavouriteBase(favourite, parameter);

      this.customNameField.setValue(favourite.data.displayNameMode === 'CUSTOM');
      this.countField.setVisible(countable);
      this.countField.setValue(counted);
      this.displayNameModeField.setValue(favourite.data.displayNameMode);
      this.newWindowField.setValue(newWindow);
    },

    deleteElement() {
      let favourite = this.form.getRecord();
      this.fireEvent('deleteFavourite', favourite);
    },

    updateElement() {
      let favourite = this.form.getRecord();

      this.form.updateRecord(favourite);
      let parameterField = this.form.query('#parameter')[0];
      if (parameterField.isVisible() && parameterField.getValue()) {
        favourite.set('description', favourite.get('parameter'));
      }
      if (this.form.isValid()) {
        this.fireEvent('updateFavourite', favourite);
        this.form.getForm().reset();
      }
    },
  });
})(window.Ext4);
