jQuery.extend(PW, {

	/**
	 * Helper class for server logging.
	 * You can specify message and location. If location is not specified, then page location is sent.
	 * 
	 * AlternateClassName: `ServerLogger`.
	 *
	 * @class PW.ServerLogger
	 */
    ServerLogger : {

    	/**
    	 * Method to log errors.
    	 *
    	 * @method error
    	 * @param {String} message Message to log.
    	 * @param {String} location Location of error which will be logged with message.
    	 */
    	error: function(message, location) {
    	    ServerLogger.log('api/logger/error', message, location);
    	},
    	
    	/**
    	 * Method to log on debug level.
    	 *
    	 * @method debug
    	 * @param {String} message Message to log.
    	 * @param {String} location Location of error which will be logged with message.
    	 */
    	debug: function(message, location) {
    	    ServerLogger.log('api/logger/debug', message, location);
    	},
    	
    	/**
         * Method to log on info level.
         *
         * @method info
         * @param {String} message Message to log.
         * @param {String} location Location of error which will be logged with message.
         */
        info: function(message, location) {
            ServerLogger.log('api/logger/info', message, location);
        },
        
        /**
         * Method to log on trace level.
         *
         * @method trace
         * @param {String} message Message to log.
         * @param {String} location Location of error which will be logged with message.
         */
        trace: function(message, location) {
            ServerLogger.log('api/logger/trace', message, location);
        },
        
        /**
         * Method to log on warn level.
         *
         * @method warn
         * @param {String} message Message to log.
         * @param {String} location Location of error which will be logged with message.
         */
        warn: function(message, location) {
            ServerLogger.log('api/logger/warn', message, location);
        },
    	
    	log: function(url, message, location) {
    	    jQuery.ajax({
                type: 'POST',
                url: url,
                contentType: "application/json",
                processData: false,
                data: JSON.stringify({
                    location: location || ServerLogger.resolvePageLocation(),
                    message: message
                })
            });
    	},
    	
    	resolvePageLocation: function() {
    	    var location = window.location.href;
    	    if(!location) {
    	        return '';
    	    }
    	    
    	    var splittedLocation = location.split('?')[0].split('/');
    	    
    	    return splittedLocation[splittedLocation.length - 1];
    	}
    }

});

ServerLogger = PW.ServerLogger;