CREATE OR REPLACE FUNCTION copy_docids()
RETURNS void AS $$
DECLARE
    row RECORD;
    length Integer;
    count Integer;
    vfileid bigint;
BEGIN

	--Tworzenie sekwencji
    IF not EXISTS (SELECT * FROM information_schema.sequences WHERE sequence_name = 'pm_activity_document_id_seq') THEN
        --RAISE notice '-- Tworze sekwencje ';
        CREATE SEQUENCE pm_activity_document_id_seq;
    end if;
	--Tworzenie tabeli
	IF NOT EXISTS( SELECT 1=1 as exist FROM pg_tables WHERE schemaname='public'  AND tablename = 'pm_activity_document' )
	THEN
		RAISE notice '-- Tabela pm_activity_document nie istnieje w bazie';
		CREATE TABLE pm_activity_document
		(
		  id bigint NOT NULL,
		  date timestamp without time zone,
		  activity numeric(19,0) not null,
		  file bigint not null,
		  process numeric(19,0),
		  userid numeric(19,0),
		  version bigint,
		  CONSTRAINT pm_activity_document_pkey PRIMARY KEY (id),
		  CONSTRAINT pm_ad_fk_activity FOREIGN KEY (activity) REFERENCES activities (objectid),
		  CONSTRAINT pm_ad_fk_fv FOREIGN KEY (version) REFERENCES pm_file_versions (id),
		  CONSTRAINT pm_ad_fk_process FOREIGN KEY (process) REFERENCES processes (objectid),
		  CONSTRAINT pm_ad_fk_files FOREIGN KEY (file) REFERENCES pm_files (id),
		  CONSTRAINT pm_ad_fk_user FOREIGN KEY (userid) REFERENCES usertable (objectid)
		);
	ELSE
		ALTER TABLE pm_activity_document alter column process drop not null;
		ALTER TABLE pm_activity_document alter column userid drop not null;
		ALTER TABLE pm_activity_document alter column version drop not null;
		ALTER TABLE pm_activity_document alter column date drop not null;
	END IF;
                 
    FOR row IN SELECT activity as activityid, string_to_array(variablevaluevchar, ',') AS ids
                from activitydata 
                WHERE variabledefinitionid='DocIds'
                AND variablevaluevchar IS NOT NULL
                AND variablevaluevchar != ''
    LOOP
        length := array_length(row.ids, 1);
        count := 1;
        LOOP
            EXIT WHEN count > length;
 
            BEGIN
                 
                vfileid=CAST(row.ids[count] AS bigint);
                -- RAISE notice '-- FileId % ', vfileid;
                -- RAISE notice '-- ActId % ', row.activityid;
				INSERT INTO pm_activity_document (id,activity,file) 
				VALUES ( nextval('pm_activity_document_id_seq'),row.activityid,vfileid);
                 
                -- RAISE notice '--  FileId: %; ActivityId: %, count: %;', vfileid, row.activityid, count;
				--Może wystąpić wyjątek z powodu już nie istniejącego dokumentu
            EXCEPTION WHEN OTHERS THEN
            --    RAISE notice '-- Pomijam FileId: %; ActivityId: %, count: %;', vfileid, row.activityid, count;
            END;
 
            count := count + 1;
        END LOOP;
 
    END LOOP;
 
    RETURN;
END;
$$ LANGUAGE plpgsql;
 
select copy_docids();

--uaktualnia koloumne process w pm_activity_document
update  pm_activity_document pa set process=(select a.process from activities a where pa.activity=objectid) where process is null;

--uaktualnia koloumny date,userid,version w pm_activity_document
update  pm_activity_document pa set date=file_date,userid=ut.objectid,version=fv.id
from pm_files f join usertable ut on ut.userid=f.uploader join pm_file_versions fv on fv.fileid=f.id  where pa.file=f.id 
and pa.date is null or pa.userid is null or pa.version is null;

ALTER TABLE pm_activity_document alter column process set not null;
ALTER TABLE pm_activity_document alter column userid set not null;
ALTER TABLE pm_activity_document alter column version set not null;
ALTER TABLE pm_activity_document alter column date set not null;

		
DROP FUNCTION copy_docids();