/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.simulation.duplicated.context.sequencer;

import com.plusmpm.database.hibernate.query.SimpleQuery;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import com.suncode.pwfl.workflow.simulation.duplicated.context.sequencer.SimulationSequencerService;
import java.beans.ConstructorProperties;
import org.hibernate.Session;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

public class SimulationSequencerServiceImpl
implements SimulationSequencerService {
    private final TransactionWrapper transactionWrapper;

    public long getNextSequenceValue(String sequenceName) {
        return this.nextValue(sequenceName, 1, 1);
    }

    public long nextValue(String sequenceName, int initialValue, int incrementValue) {
        return (Long)this.transactionWrapper.doInHibernateTransaction(session -> {
            SimpleQuery simpleQuery = new SimpleQuery("SELECT 1 FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_NAME = UPPER('" + sequenceName + "')");
            Object sequenceExists = simpleQuery.uniqueResult(session);
            if (sequenceExists == null) {
                this.createSequence(session, sequenceName, initialValue, incrementValue);
            }
            Object[][] scalars = new Object[][]{{"nextval", StandardBasicTypes.LONG}};
            simpleQuery = new SimpleQuery("SELECT NEXTVAL('" + sequenceName + "') AS nextval", scalars);
            Long nextVal = (Long)simpleQuery.uniqueResult(session);
            return nextVal;
        });
    }

    private void createSequence(Session session, String sequenceName, int initialValue, int incrementValue) {
        String query = "CREATE SEQUENCE " + sequenceName + " START WITH " + initialValue + " INCREMENT BY " + incrementValue;
        session.createSQLQuery(query).executeUpdate();
    }

    @ConstructorProperties(value={"transactionWrapper"})
    @Autowired
    public SimulationSequencerServiceImpl(TransactionWrapper transactionWrapper) {
        this.transactionWrapper = transactionWrapper;
    }

    static {
        SimulationUtils.assertIsInSimulation();
    }
}

