/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.suncode.pwfl.web.ui.ScriptInjection;
import com.suncode.pwfl.web.ui.UIFragment;
import com.suncode.pwfl.web.ui.WebScripts;
import com.suncode.pwfl.web.ui.WebScriptsCache;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;

@Component
class WebScriptsRegistry
implements WebScripts,
WroModelFactory {
    private static final Pattern fragmentRegexp = Pattern.compile("[a-z0-9-_\\./]+");
    @Autowired
    private WebScriptsCache cache;
    private final WroModel model = new WroModel();

    WebScriptsRegistry() {
    }

    @PostConstruct
    public void initUiFragments() {
        for (UIFragment fragment : UIFragment.values()) {
            this.initFragment(fragment.id());
        }
    }

    public WroModel create() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFragment(String fragmentId) {
        WroModel wroModel = this.model;
        synchronized (wroModel) {
            this.validateFragment(fragmentId);
            Group group = this.getGroup(fragmentId);
            if (group == null) {
                group = new Group(fragmentId);
                this.model.addGroup(group);
            }
        }
    }

    public ScriptInjection inject(UIFragment fragment, org.springframework.core.io.Resource resource) {
        Assert.notNull((Object)fragment, (String)"Fragment must not be null");
        return this.inject(fragment.id(), resource);
    }

    public ScriptInjection inject(String fragmentId, org.springframework.core.io.Resource resource) {
        this.initFragment(fragmentId);
        Script script = new Script(fragmentId, resource);
        script.inject();
        return script;
    }

    private void validateFragment(String fragmentId) {
        Assert.notNull((Object)fragmentId, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (!fragmentRegexp.matcher(fragmentId).matches()) {
            throw new IllegalArgumentException("Fragment identifier is not valid (allowed characters: a-z 0-9 - _ . /)");
        }
    }

    private Group getGroup(String name) {
        return new WroModelInspector(this.model).getGroupByName(name);
    }

    private Resource createWroResource(org.springframework.core.io.Resource resource) {
        URL url = this.getResourceUrl(resource);
        Resource res = new Resource();
        res.setUri(url.toExternalForm());
        res.setType(ResourceType.JS);
        res.setMinimize(true);
        return res;
    }

    private URL getResourceUrl(org.springframework.core.io.Resource resource) {
        try {
            return resource.getURL();
        }
        catch (IOException e) {
            throw new IllegalStateException("Injected resource [" + resource + "] could not be resolved to URL");
        }
    }

    private void invalidateCache(Group group) {
        CacheKey cacheKey = new CacheKey(group.getName(), ResourceType.JS, true);
        this.cache.invalidate(cacheKey);
        WebScripts.UrlCacheParameter.get().invalidate(group.getName());
    }

    public void destroy() {
    }

    private class Script
    implements ScriptInjection {
        final String groupName;
        final org.springframework.core.io.Resource resource;

        Script(String groupName, org.springframework.core.io.Resource resource) {
            Assert.notNull((Object)resource, (String)"[Assertion failed] - this argument is required; it must not be null");
            this.groupName = groupName;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void inject() {
            WroModel wroModel = WebScriptsRegistry.this.model;
            synchronized (wroModel) {
                Group group = WebScriptsRegistry.this.getGroup(this.groupName);
                group.addResource(WebScriptsRegistry.this.createWroResource(this.resource));
                WebScriptsRegistry.this.invalidateCache(group);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            WroModel wroModel = WebScriptsRegistry.this.model;
            synchronized (wroModel) {
                Resource res;
                Group group = WebScriptsRegistry.this.getGroup(this.groupName);
                if (group != null && group.hasResource((res = WebScriptsRegistry.this.createWroResource(this.resource)).getUri())) {
                    group.replace(WebScriptsRegistry.this.createWroResource(this.resource), Collections.emptyList());
                    WebScriptsRegistry.this.invalidateCache(group);
                }
            }
        }

        public org.springframework.core.io.Resource getResource() {
            return this.resource;
        }

        public String getFragmentId() {
            return this.groupName;
        }
    }
}

